/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.event;

import de.effectivecompany.gui.components.EFCActionAccelerator;
import de.effectivecompany.gui.constants.EFCActionAcceleratorKey;
import de.effectivecompany.gui.interfaces.handler.ActionHandler;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCombination;
import org.controlsfx.control.action.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EFCAbstractAction
extends Action
implements EFCActionAccelerator {
    private static Logger logger = LoggerFactory.getLogger(EFCAbstractAction.class);
    protected ActionHandler actionHandler;

    public EFCAbstractAction() {
        super("");
        this.setEventHandler(ae -> this.processAction(this.getIdent(), null));
    }

    public EFCAbstractAction(String title) {
        super(title);
        this.setEventHandler(ae -> this.processAction(this.getIdent(), null));
    }

    public EFCAbstractAction(String title, Image icon) {
        this(title);
        this.setGraphic((Node)new ImageView(icon));
    }

    public void setActionHandler(ActionHandler actionHandler) {
        this.actionHandler = actionHandler;
    }

    public void removeActionHandler() {
        this.actionHandler = null;
    }

    public ActionHandler getActionHandler() {
        return this.actionHandler;
    }

    public void processAction(String ident, Object context) {
        if (this.actionHandler != null) {
            this.actionHandler.handleAction(ident, context);
        } else {
            logger.error("NO ACTION HANDLER SET FOR " + this.getClass().getSimpleName());
        }
    }

    public abstract String getIdent();

    @Override
    public void addAccelerator(EFCActionAcceleratorKey accelerator) {
        this.setAccelerator((KeyCombination)accelerator.getAcceleratorKeyFx());
    }
}

