/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.event;

import de.effectivecompany.base.datatypes.EFCBlob;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.fx.event.EFCAbstractAction;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class EFCActionExportClientLog
extends EFCAbstractAction {
    public static final String IDENT = "EXPORT_CLIENT_LOG";

    public EFCActionExportClientLog() {
        super(Translator.tr((String)"ACTION_EXPORT_CLIENT_LOG"), EFCLookAndFeelManager.ICON_TOOLBAR_EMAIL_FX);
        this.setLongText(Translator.tr((String)"ACTION_EXPORT_CLIENT_LOG"));
    }

    @Override
    public void processAction(String ident, Object context) {
        File folder = new File(System.getProperty("java.io.tmpdir") + "/efc/logs");
        File[] listOfFiles = folder.listFiles();
        ArrayList<File> listOfServerLogs = new ArrayList<File>();
        for (int i = 0; i < listOfFiles.length; ++i) {
            byte[] buffer = listOfFiles[i].getName().getBytes();
            byte[] compareobject = new String("efc_client").getBytes();
            boolean ismatching = true;
            for (int j = 0; j < compareobject.length; ++j) {
                if (buffer[j] == compareobject[j]) continue;
                ismatching = false;
            }
            if (!ismatching) continue;
            listOfServerLogs.add(listOfFiles[i]);
        }
        byte[] buffer = new byte[1024];
        UUID uuid = UUID.randomUUID();
        try {
            FileOutputStream fos = new FileOutputStream(System.getProperty("java.io.tmpdir") + "/efc/fileuploads/" + uuid);
            ZipOutputStream zos = new ZipOutputStream(fos);
            for (File file : listOfServerLogs) {
                try {
                    int len;
                    ZipEntry ze = new ZipEntry(file.getName());
                    zos.putNextEntry(ze);
                    FileInputStream inputStream = new FileInputStream(file);
                    while ((len = inputStream.read(buffer)) > 0) {
                        zos.write(buffer, 0, len);
                    }
                    inputStream.close();
                    zos.closeEntry();
                    System.out.println("Done");
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            zos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        byte[] data = null;
        Path path = Paths.get(System.getProperty("java.io.tmpdir") + "/efc/fileuploads/" + uuid, new String[0]);
        try {
            data = Files.readAllBytes(path);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        EFCBlob attachmentFile = new EFCBlob(data);
        try {
            Class<?> clazz = Class.forName("de.effectivecompany.gui.util.MailTools", false, this.getClass().getClassLoader());
            clazz.getMethod("createExportClientLogMailDialog", EFCBlob.class).invoke(null, attachmentFile);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException eex) {
            EFCDesktop.reportError(eex);
        }
        File file = new File(System.getProperty("java.io.tmpdir") + "/efc/fileuploads/" + uuid);
        try {
            file.delete();
        }
        catch (Exception exc) {
            EFCDesktop.reportError(exc);
        }
    }

    @Override
    public String getIdent() {
        return IDENT;
    }
}

