/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.utils;

import de.effectivecompany.base.datatypes.EFCDateTime;
import de.effectivecompany.base.datatypes.EFCOption;
import de.effectivecompany.base.datatypes.EFCQuantity;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.i18n.Translator;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.util.StringConverter;

public class EFCConverterUtil {
    public static StringConverter<EFCString> getEFCStringConverter() {
        return new StringConverter<EFCString>(){

            public String toString(EFCString object) {
                if (object == null) {
                    return null;
                }
                return object.getData();
            }

            public EFCString fromString(String string) {
                return new EFCString(string);
            }
        };
    }

    public static StringConverter<EFCQuantity> getEFCQuantityConverter() {
        return new StringConverter<EFCQuantity>(){

            public String toString(EFCQuantity object) {
                if (object == null || object.getData() == null) {
                    return null;
                }
                return object.getData().toString();
            }

            public EFCQuantity fromString(String string) {
                return new EFCQuantity(string);
            }
        };
    }

    public static StringBinding getEFCOptionBinding(EFCOption option) {
        return Bindings.createStringBinding(() -> option == null || option.getData() == null ? null : Translator.tr((String)("OPT_" + option.getOptions().getSimpleName().toUpperCase() + "_" + option.toString().toUpperCase())), (Observable[])new Observable[0]);
    }

    public static StringBinding getEFCDateTimeBinding(EFCDateTime datetime) {
        return Bindings.createStringBinding(() -> datetime == null || datetime.getData() == null ? "" : datetime.toString(), (Observable[])new Observable[0]);
    }
}

