/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.utils;

import javafx.beans.property.Property;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.skin.TableHeaderRow;
import javafx.scene.control.skin.TableViewSkin;
import javafx.scene.input.MouseEvent;

public class TableViewUtil {
    public static void addCustomTableMenu(TableView tableView) {
        tableView.setTableMenuButtonVisible(true);
        TableViewUtil.setCustomContextMenu(tableView);
    }

    private static void setCustomContextMenu(TableView table) {
        TableViewSkin tableSkin = (TableViewSkin)table.getSkin();
        ObservableList children = tableSkin.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Node node = (Node)children.get(i);
            if (!(node instanceof TableHeaderRow)) continue;
            TableHeaderRow tableHeaderRow = (TableHeaderRow)node;
            double defaultHeight = tableHeaderRow.getHeight();
            tableHeaderRow.setPrefHeight(defaultHeight);
            for (Node child : tableHeaderRow.getChildren()) {
                if (!child.getStyleClass().contains((Object)"show-hide-columns-button")) continue;
                ContextMenu columnPopupMenu = TableViewUtil.createContextMenu(table);
                child.setOnMousePressed(me -> {
                    columnPopupMenu.show(child, Side.BOTTOM, 0.0, 0.0);
                    me.consume();
                });
            }
        }
    }

    private static ContextMenu createContextMenu(final TableView table) {
        ContextMenu cm = new ContextMenu();
        Label showAll = new Label("Show all");
        showAll.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                for (Object obj : table.getColumns()) {
                    ((TableColumn)obj).setVisible(true);
                }
            }
        });
        CustomMenuItem cmi = new CustomMenuItem((Node)showAll);
        cmi.setHideOnClick(false);
        cm.getItems().add((Object)cmi);
        Label hideAll = new Label("Hide all");
        hideAll.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                for (Object obj : table.getColumns()) {
                    ((TableColumn)obj).setVisible(false);
                }
            }
        });
        cmi = new CustomMenuItem((Node)hideAll);
        cmi.setHideOnClick(false);
        cm.getItems().add((Object)cmi);
        cm.getItems().add((Object)new SeparatorMenuItem());
        for (Object obj : table.getColumns()) {
            TableColumn tableColumn = (TableColumn)obj;
            CheckBox cb = new CheckBox(tableColumn.getText());
            cb.selectedProperty().bindBidirectional((Property)tableColumn.visibleProperty());
            cmi = new CustomMenuItem((Node)cb);
            cmi.setHideOnClick(false);
            cm.getItems().add((Object)cmi);
        }
        return cm;
    }
}

