/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl;

import de.effectivecompany.gui.components.fx.wfl.WflGroupTaskPane;
import de.effectivecompany.gui.components.fx.wfl.WflMyQueuedTaskListPane;
import de.effectivecompany.gui.components.fx.wfl.WflMyTaskPane;
import de.effectivecompany.gui.components.fx.wfl.WflPanelType;
import de.effectivecompany.gui.laf.EFCMaterialIcons;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import org.kordamp.ikonli.javafx.FontIcon;

public class EFCWflTitledPane
extends TitledPane {
    private String id;
    private WflPanelType panelType;

    public EFCWflTitledPane(String title) {
        this(title, null);
    }

    public EFCWflTitledPane(String title, Node content) {
        this.setText(title);
        if (content != null) {
            this.setContent(content);
        }
    }

    public EFCWflTitledPane(WflPanelType panelType, boolean forAdmin, String title, String id, java.awt.Color color) {
        this(panelType, forAdmin, title, id, color, null);
    }

    public EFCWflTitledPane(final WflPanelType panelType, final boolean forAdmin, String title, final String id, java.awt.Color color, String iconname) {
        this.setText(title);
        this.panelType = panelType;
        this.setMaxWidth(500.0);
        this.setMinWidth(500.0);
        this.id = id;
        if (iconname == null || iconname.isEmpty()) {
            Rectangle ret = new Rectangle(15.0, 15.0);
            if (color != null && !color.equals(java.awt.Color.white)) {
                ret.setFill((Paint)Color.rgb((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue()));
            } else {
                ret.setOpacity(0.0);
            }
            this.setGraphic((Node)ret);
        } else {
            FontIcon icon = new FontIcon(EFCMaterialIcons.getMaterialIcon(iconname));
            if (color != null && !color.equals(java.awt.Color.white)) {
                icon.setIconColor((Paint)Color.rgb((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue()));
            } else {
                icon.setIconColor((Paint)Color.BLACK);
            }
            icon.resize(20.0, 20.0);
            this.setGraphic((Node)icon);
        }
        this.expandedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    switch (panelType) {
                        case CREATE_TASK: {
                            break;
                        }
                        case GROUP_TASKS: {
                            EFCWflTitledPane.this.setContent((Node)new WflGroupTaskPane(id, forAdmin));
                            break;
                        }
                        case MAIL_INBOX: {
                            break;
                        }
                        case MY_PROCESSES_LIST: {
                            break;
                        }
                        case TASKS: 
                        case MYTASKS: 
                        case MYCREATEDTASKSFINISHED: {
                            EFCWflTitledPane.this.setContent((Node)new WflMyTaskPane(id, forAdmin));
                            break;
                        }
                        case PROCESSES_LIST: {
                            break;
                        }
                        case QUEUED_TASKS: {
                            EFCWflTitledPane.this.setContent((Node)new WflMyQueuedTaskListPane(id, forAdmin));
                            break;
                        }
                    }
                }
            }
        });
    }

    public void setWorking(boolean isWorking) {
    }

    public String getTaskId() {
        return this.id;
    }

    public void setTaskId(String taskId) {
        this.id = taskId;
    }

    public void setWflContent(Node node) {
        this.setContent(node);
    }
}

