/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl;

import de.effectivecompany.gui.components.root.EFCMainPanel;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Ellipse;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.util.Duration;

public class EFCWflToggleButton
extends ToggleButton {
    private Ellipse circle;
    private Label text;
    private StackPane number;
    private StackPane flag;
    private final ProgressIndicator pin = new ProgressIndicator();
    private SimpleBooleanProperty disable = new SimpleBooleanProperty(false);

    public EFCWflToggleButton(String imageResource) {
        this(imageResource, null);
    }

    public EFCWflToggleButton(String imageResource, String tooltip) {
        Image imageProcesses = new Image(EFCMainPanel.class.getResourceAsStream(imageResource));
        this.circle = new Ellipse(7.0, 7.0);
        this.circle.setFill((Paint)Color.BLUE);
        this.text = new Label();
        this.text.setTextFill((Paint)Color.WHITE);
        this.text.setFont(Font.font((String)"Roboto", (FontWeight)FontWeight.BOLD, (double)10.0));
        this.number = new StackPane();
        this.number.setVisible(false);
        this.number.getChildren().addAll((Object[])new Node[]{this.circle, this.text});
        this.flag = new StackPane();
        this.flag.setVisible(false);
        if (tooltip != null) {
            Tooltip tp = new Tooltip(tooltip);
            tp.setHideDelay(new Duration(1500.0));
            this.setTooltip(tp);
        }
        this.pin.setProgress(-1.0);
        this.pin.setVisible(false);
        this.pin.setMinWidth(22.0);
        this.pin.setMinHeight(22.0);
        this.pin.setMaxHeight(22.0);
        this.pin.setMaxWidth(22.0);
        this.setMinWidth(35.0);
        this.setMinHeight(35.0);
        this.setMaxHeight(35.0);
        this.setMaxWidth(35.0);
        StackPane stack = new StackPane();
        StackPane.setAlignment((Node)this.number, (Pos)Pos.BOTTOM_CENTER);
        StackPane.setMargin((Node)this.number, (Insets)new Insets(15.0, 0.0, 0.0, 0.0));
        stack.getChildren().addAll((Object[])new Node[]{new ImageView(imageProcesses), this.number, this.pin});
        this.setVisible(true);
        this.setGraphic((Node)stack);
    }

    public void actualizeActiveCount(Integer activeProcCount) {
        if (activeProcCount > 0) {
            String ctext = Integer.toString(activeProcCount);
            int count = ctext.length();
            if (count > 1) {
                this.circle.setRadiusX((double)count * 0.75 * 7.0);
            } else {
                this.circle.setRadiusX(7.0);
            }
            this.text.setText(ctext);
            this.number.setVisible(true);
        } else {
            this.number.setVisible(false);
        }
    }

    public void setAdminFlag() {
        Circle circle = new Circle(5.0);
        circle.setFill((Paint)Color.RED);
        Label text = new Label();
        text.setTextFill((Paint)Color.WHITE);
        text.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)10.0));
        text.setText("A");
        this.flag.setVisible(true);
        this.flag.getChildren().addAll((Object[])new Node[]{circle, text});
        StackPane.setMargin((Node)circle, (Insets)new Insets(-20.0, 20.0, 0.0, 0.0));
        StackPane.setMargin((Node)text, (Insets)new Insets(-20.0, 20.0, 0.0, 0.0));
        ((StackPane)this.getGraphic()).getChildren().add(2, (Object)this.flag);
    }

    public void fire() {
        if (!this.isEnabled().booleanValue()) {
            super.fire();
        }
    }

    public void setWorking(boolean isWorking) {
        this.pin.setVisible(isWorking);
        this.pin.setDisable(isWorking);
    }

    public Boolean isEnabled() {
        return this.disable.getValue();
    }

    public void setEnabled(Boolean enabled) {
        this.disable.set(enabled == false);
    }
}

