/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl;

import de.effectivecompany.app.syswfl.BoWflVariable;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.gui.components.editor.util.DateTimeFormatter;
import de.effectivecompany.gui.components.fx.components.editor.EFCDatePicker;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.fx.wfl.WflPane;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import javafx.beans.property.Property;
import javafx.util.StringConverter;

public class WflDatePicker
extends EFCDatePicker {
    public WflDatePicker(WflPane parent, BoWflVariable var, String taskId) {
        if (var.getAct_isWritable().getData() != null && !var.getAct_isWritable().getData().booleanValue()) {
            this.setDisable(true);
        }
        this.setConverter((StringConverter)new StringConverter<LocalDate>(){
            private java.time.format.DateTimeFormatter dateTimeFormatter = java.time.format.DateTimeFormatter.ofPattern("dd.MM.yyyy");

            public String toString(LocalDate localDate) {
                if (localDate == null) {
                    return "";
                }
                return this.dateTimeFormatter.format(localDate);
            }

            public LocalDate fromString(String dateString) {
                if (dateString == null || dateString.trim().isEmpty()) {
                    return null;
                }
                Date date = DateTimeFormatter.convertDate(dateString);
                if (date != null) {
                    Instant instant = Instant.ofEpochMilli(date.getTime());
                    return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).toLocalDate();
                }
                return null;
            }
        });
        this.setId(taskId);
        parent.getModel().put(taskId + var.getAct_id().toString(), (Property<?>)this.valueProperty());
        EFCString varId = var.getAct_id();
        this.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null) {
                EFCMap vars = new EFCMap();
                Object value = null;
                for (String v : parent.getModel().keySet()) {
                    if (!v.equalsIgnoreCase(this.getId() + varId)) continue;
                    value = parent.getModel().get(v).getValue();
                    if (value != null && value instanceof LocalDate) {
                        Instant instant = ((LocalDate)value).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
                        Date res = Date.from(instant);
                        vars.put((Object)varId, (Object)new EFCString(Long.toString(res.getTime())));
                        continue;
                    }
                    vars.put((Object)varId, (Object)new EFCString());
                }
                WflController.getInstance().setTaskVariables(parent, new EFCString(this.getId()), (EFCMap<EFCString, EFCString>)vars);
            }
        });
        if (var.getAct_value().getData() != null && !var.getAct_value().getData().isEmpty()) {
            Instant instant = Instant.ofEpochMilli(Long.parseLong(var.getAct_value().getData()));
            this.valueProperty().setValue((Object)LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).toLocalDate());
        }
        if (var.getAct_isRequired().getData() != null && var.getAct_isRequired().getData().booleanValue()) {
            this.setStyle("-fx-border-color: red");
        }
    }
}

