/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl;

import de.effectivecompany.app.syswfl.BoWflVariable;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.gui.components.fx.components.editor.EFCDoubleTextfield;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.fx.wfl.WflPane;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;

public class WflDoubleTextfield
extends EFCDoubleTextfield {
    private SimpleObjectProperty<Double> doubleProperty = new SimpleObjectProperty();
    final SimpleBooleanProperty isChangedDouble = new SimpleBooleanProperty(false);

    public WflDoubleTextfield(final WflPane parent, final BoWflVariable var, String taskId) {
        this.setPrefWidth(100.0);
        if (var.getAct_isRequired().getData() != null && var.getAct_isRequired().getData().booleanValue()) {
            this.setStyle("-fx-border-color: red");
        }
        Double val = null;
        if (var.getAct_isWritable().getData() != null && !var.getAct_isWritable().getData().booleanValue()) {
            this.setDisable(true);
        }
        if (var.getAct_value().getData() != null && !var.getAct_value().getData().isEmpty()) {
            try {
                val = Double.valueOf(var.getAct_value().getData());
            }
            catch (NumberFormatException ex) {
                try {
                    val = NumberFormat.getInstance(Locale.GERMANY).parse(var.getAct_value().getData()).doubleValue();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        this.doubleProperty.set(val);
        this.setId(taskId);
        StringConverter<Double> converter = new StringConverter<Double>(){

            public Double fromString(String s) {
                Double val = null;
                if (s != null && !s.isEmpty()) {
                    try {
                        val = Double.valueOf(s);
                    }
                    catch (NumberFormatException ex) {
                        try {
                            val = NumberFormat.getInstance(Locale.GERMANY).parse(s).doubleValue();
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                }
                WflDoubleTextfield.this.doubleProperty.set(val);
                return val;
            }

            public String toString(Double d) {
                return d == null ? "" : WflDoubleTextfield.this.format.format(d);
            }
        };
        TextFormatter textFormatter = new TextFormatter((StringConverter)converter, (Object)val, this.filter);
        this.setTextFormatter(textFormatter);
        parent.getModel().put(taskId + var.getAct_id().toString(), (Property<?>)this.doubleProperty);
        this.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (WflDoubleTextfield.this.focusedProperty().get() && oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null) {
                    WflDoubleTextfield.this.isChangedDouble.set(true);
                }
            }
        });
        this.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                if (oldPropertyValue.booleanValue() && !newPropertyValue.booleanValue() && WflDoubleTextfield.this.isChangedDouble.get()) {
                    EFCMap vars = new EFCMap();
                    Object value = null;
                    for (String v : parent.getModel().keySet()) {
                        if (!v.equalsIgnoreCase(WflDoubleTextfield.this.getId() + var.getAct_id())) continue;
                        value = parent.getModel().get(v).getValue();
                        if (value != null && value.toString() != null && !value.toString().isEmpty()) {
                            vars.put((Object)var.getAct_id(), (Object)new EFCString(value.toString()));
                            continue;
                        }
                        vars.put((Object)var.getAct_id(), (Object)new EFCString());
                    }
                    WflController.getInstance().setTaskVariables(parent, new EFCString(WflDoubleTextfield.this.getId()), (EFCMap<EFCString, EFCString>)vars);
                    WflDoubleTextfield.this.isChangedDouble.set(false);
                }
            }
        });
    }
}

