/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl;

import de.effectivecompany.app.syswfl.BoWflTask;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.fx.wfl.WflActionButtonPane;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.fx.wfl.WflPane;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javafx.concurrent.Task;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;

public class WflGroupTaskPane
extends WflPane {
    public WflGroupTaskPane(String act_id, boolean forAdmin) {
        super(act_id, forAdmin);
        this.setWorking(true);
        Task<BoWflTask> getTask = WflController.getInstance().getTaskService(act_id);
        getTask.setOnSucceeded(event -> {
            if (event.getSource().valueProperty().get() != null) {
                BoWflTask task = (BoWflTask)event.getSource().valueProperty().get();
                if (task.getAct_processInstanceId() != null && task.getAct_processInstanceId().getData() != null) {
                    this.getTaskProcIdMap().put((Object)task.getAct_id().getData(), (Object)task.getAct_processInstanceId().getData());
                }
                GridPane gridpane = new GridPane();
                gridpane.setPadding(new Insets(5.0));
                gridpane.setHgap(5.0);
                gridpane.setVgap(5.0);
                Text description = new Text(task.getAct_description().toString());
                gridpane.add((Node)description, 0, 0, 2, 1);
                HBox dueDateHbox = new HBox();
                if (task.getAct_lastActionTime() != null && task.getAct_lastActionTime().getData() != null) {
                    Label dueDateTextfield = new Label();
                    Instant instant = task.getAct_lastActionTime().getDate().toInstant();
                    LocalDateTime localDate = instant.atZone(ZoneId.systemDefault()).toLocalDateTime();
                    dueDateTextfield.setText(DateTimeFormatter.ofPattern("dd.MM.yyyy").format(localDate));
                    Label dueDateLabel = new Label(Translator.tr((String)"FLD_ACT_LASTACTIVITYDATE"));
                    dueDateLabel.setPrefWidth(150.0);
                    dueDateHbox.getChildren().addAll((Object[])new Node[]{dueDateLabel, dueDateTextfield});
                }
                VBox vbox = new VBox();
                vbox.setSpacing(10.0);
                vbox.setPadding(new Insets(10.0, 0.0, 0.0, 20.0));
                vbox.getChildren().addAll((Object[])new Node[]{gridpane, this.getErrorMsg(), new WflActionButtonPane(this, task), dueDateHbox, this.getWflDataTablebase()});
                this.setTop((Node)this.getToolbar());
                this.setContent((Node)vbox);
                this.setWorking(false);
                boolean forProcInstId = task.getPjmprogkey() != null && task.getPjmprogkey().getAct_value().getData() != null && task.getPjmprogkey().getAct_value().getData().equals("PJMDOC");
                WflController.getInstance().getAttachments(this.getWflDataTablebase(), task.getAct_processInstanceId().getData(), task.getAct_id().getData(), forProcInstId);
                WflController.getInstance().getComments(this.getWflDataTablebase(), task.getAct_processInstanceId().getData(), task.getAct_id().getData());
            }
        });
        WflController.getInstance().executeTask(getTask);
    }
}

