/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl;

import de.effectivecompany.app.syswfl.BoWflTask;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.gui.key.Key;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.fx.wfl.EFCWflProgButton;
import de.effectivecompany.gui.components.fx.wfl.WflActionButtonPane;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.fx.wfl.WflPane;
import de.effectivecompany.gui.components.fx.wfl.service.WflAssigneeComboBox;
import de.effectivecompany.gui.components.root.EFCNavigator;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;

public class WflMyQueuedTaskListPane
extends WflPane {
    public WflMyQueuedTaskListPane(String act_id, boolean forAdmin) {
        super(act_id, forAdmin);
        this.setWorking(true);
        Task<BoWflTask> getTask = WflController.getInstance().getTaskService(act_id);
        getTask.setOnSucceeded(event -> {
            if (event.getSource().valueProperty().get() != null) {
                BoWflTask task = (BoWflTask)event.getSource().valueProperty().get();
                EFCWflProgButton gotoPjmButton = null;
                EFCNavigator.ExecProg prog = null;
                if (!task.getWflkey().isEmpty() && (prog = EFCNavigator.getInstance().getProgram(task.getPjmprogkey().getAct_value().getData())) != null) {
                    Key key = new Key();
                    task.getWflkey().entrySet().forEach(entry -> key.addKeyValue(((EFCString)entry.getKey()).getData(), ((EFCString)entry.getValue()).getData()));
                    gotoPjmButton = new EFCWflProgButton(Translator.tr((String)("GOTO_" + task.getPjmprogkey().getAct_value().getData())), prog, key);
                }
                GridPane gridpane = new GridPane();
                gridpane.setPadding(new Insets(5.0));
                gridpane.setHgap(5.0);
                gridpane.setVgap(5.0);
                Text description = new Text(task.getAct_description().toString());
                gridpane.add((Node)description, 0, 0);
                Label errorMsg = new Label();
                errorMsg.setWrapText(true);
                errorMsg.setPrefHeight(30.0);
                HBox dueDateHbox = new HBox();
                if (task.getAct_lastActionTime() != null && task.getAct_lastActionTime().getData() != null) {
                    Label dueDateTextfield = new Label();
                    Instant instant = task.getAct_lastActionTime().getDate().toInstant();
                    LocalDateTime localDate = instant.atZone(ZoneId.systemDefault()).toLocalDateTime();
                    dueDateTextfield.setText(DateTimeFormatter.ofPattern("dd.MM.yyyy").format(localDate));
                    Label dueDateLabel = new Label(Translator.tr((String)"FLD_ACT_LASTACTIVITYDATE"));
                    dueDateLabel.setPrefWidth(75.0);
                    dueDateHbox.getChildren().addAll((Object[])new Node[]{dueDateLabel, dueDateTextfield});
                }
                Label assigneeLabel = new Label(Translator.tr((String)"FLD_ACT_DELEGATE_TASK"));
                WflAssigneeComboBox assignee = new WflAssigneeComboBox();
                final Button delegate = new Button(Translator.tr((String)"WFL_TASK_DELEGATE"));
                delegate.setId(task.getAct_id().toString());
                delegate.setVisible(false);
                delegate.setOnAction(e -> {
                    Button src = (Button)e.getSource();
                    WflController.getInstance().delegateTask(src.getId(), errorMsg, assignee.getAssignee().getSelected().getData(), false);
                });
                assignee.getAssignee().setPrefWidth(200.0);
                assignee.getAssignee().valueProperty().addListener((ChangeListener)new ChangeListener<Object>(){

                    public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
                        if (newValue != null) {
                            delegate.setVisible(true);
                        } else {
                            delegate.setVisible(false);
                        }
                    }
                });
                VBox vbox = new VBox();
                vbox.setSpacing(5.0);
                vbox.setPadding(new Insets(10.0, 0.0, 0.0, 10.0));
                vbox.getChildren().addAll((Object[])new Node[]{gridpane, this.getErrorMsg(), new WflActionButtonPane(this, task), dueDateHbox, assigneeLabel, new HBox(10.0, new Node[]{assignee, delegate})});
                this.setContent((Node)vbox);
                this.setWorking(false);
            }
        });
        WflController.getInstance().executeTask(getTask);
    }
}

