/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl;

import de.effectivecompany.app.syswfl.BoWflTask;
import de.effectivecompany.app.syswfl.BoWflVariable;
import de.effectivecompany.app.syswfl.service.SvBoWflTasks;
import de.effectivecompany.base.datatypes.EFCDateTime;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.gui.key.Key;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.wfl.BoWflFormValueCombobox;
import de.effectivecompany.gui.components.fx.wfl.EFCWflProgButton;
import de.effectivecompany.gui.components.fx.wfl.WflActionButtonPane;
import de.effectivecompany.gui.components.fx.wfl.WflCheckbox;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.fx.wfl.WflDatePicker;
import de.effectivecompany.gui.components.fx.wfl.WflDoubleTextfield;
import de.effectivecompany.gui.components.fx.wfl.WflIdentityLinkTable;
import de.effectivecompany.gui.components.fx.wfl.WflLabel;
import de.effectivecompany.gui.components.fx.wfl.WflLongTextfield;
import de.effectivecompany.gui.components.fx.wfl.WflPane;
import de.effectivecompany.gui.components.fx.wfl.WflPanelType;
import de.effectivecompany.gui.components.fx.wfl.WflStringTextfield;
import de.effectivecompany.gui.components.root.EFCNavigator;
import de.effectivecompany.gui.constants.EFCConstants;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javafx.concurrent.Task;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;

public class WflMyTaskPane
extends WflPane {
    private final SvBoWflTasks svBoWflTasks = (SvBoWflTasks)SpringHelper.getBean((String)"syswfl_SvBoWflTasks");

    public WflMyTaskPane(String act_id, boolean forAdmin) {
        super(act_id, forAdmin);
        this.setWorking(true);
        Task<BoWflTask> getTask = WflController.getInstance().getActual() == WflPanelType.MYCREATEDTASKSFINISHED ? WflController.getInstance().getFinishedTaskService(act_id) : WflController.getInstance().getTaskService(act_id);
        getTask.setOnSucceeded(event -> {
            if (event.getSource().valueProperty().get() != null) {
                Integer dmstistracingtype;
                BoWflTask task = (BoWflTask)event.getSource().valueProperty().get();
                if (task.getAct_processInstanceId() != null && task.getAct_processInstanceId().getData() != null) {
                    this.getTaskProcIdMap().put((Object)task.getAct_id().getData(), (Object)task.getAct_processInstanceId().getData());
                }
                if (task.getAct_variables().containsKey((Object)EFCConstants.WFL_VAR_DMSTISTRACINGTYPE) && (dmstistracingtype = Integer.valueOf(Integer.parseInt(((BoWflVariable)task.getAct_variables().get((Object)EFCConstants.WFL_VAR_DMSTISTRACINGTYPE)).getAct_value().getData()))) >= 10 && !task.getAct_variables().containsKey((Object)EFCConstants.WFL_LOCALVAR_FIRST_OPENED)) {
                    EFCThreadUtil.fatBuilder(th -> th.doOutside(() -> this.svBoWflTasks.setVariableTask(task.getAct_id(), EFCConstants.WFL_LOCALVAR_FIRST_OPENED, new EFCString(new EFCDateTime(new Date()).toString()))));
                }
                GridPane gridpane = new GridPane();
                gridpane.setPadding(new Insets(5.0));
                gridpane.setHgap(5.0);
                gridpane.setVgap(5.0);
                Text description = new Text(task.getAct_description().toString());
                gridpane.add((Node)description, 0, 0, 2, 1);
                int row = 3;
                EFCWflProgButton gotoButton = null;
                for (EFCString key : task.getAct_formvariables().keySet()) {
                    BoWflVariable var = (BoWflVariable)task.getAct_formvariables().get((Object)key);
                    EFCNavigator.ExecProg prog = null;
                    String variable = var.getAct_id().getData();
                    if (variable.contains("prog_") && (prog = EFCNavigator.getInstance().getProgram(variable.replace("prog_", "").toUpperCase())) != null) {
                        Key formKey = new Key();
                        gotoButton = new EFCWflProgButton(Translator.tr((String)"MENU_GOTO"), prog, formKey, task);
                        continue;
                    }
                    WflLabel label = new WflLabel(var);
                    gridpane.add((Node)label, 0, row);
                    switch (var.getAct_type().getData()) {
                        case 20: {
                            gridpane.add((Node)new WflDatePicker(this, var, task.getAct_id().getData()), 1, row);
                            break;
                        }
                        case 10: {
                            gridpane.add((Node)new WflLongTextfield(this, var, task.getAct_id().getData()), 1, row);
                            break;
                        }
                        case 50: {
                            gridpane.add((Node)new WflDoubleTextfield(this, var, task.getAct_id().getData()), 1, row);
                            break;
                        }
                        case 0: {
                            gridpane.add((Node)new WflStringTextfield(this, var, task.getAct_id().getData()), 1, row);
                            break;
                        }
                        case 30: {
                            gridpane.add((Node)new WflCheckbox(this, var, task.getAct_id().getData()), 1, row);
                            break;
                        }
                        case 40: {
                            gridpane.add((Node)new BoWflFormValueCombobox(this, var, task.getAct_id().getData()), 1, row);
                        }
                    }
                    row += 2;
                }
                if (gotoButton != null) {
                    gridpane.add(gotoButton, 2, row - 1);
                }
                HBox dueDateHbox = new HBox();
                if (task.getAct_lastActionTime() != null && task.getAct_lastActionTime().getData() != null) {
                    Label dueDateTextfield = new Label();
                    Instant instant = task.getAct_lastActionTime().getDate().toInstant();
                    LocalDateTime localDate = instant.atZone(ZoneId.systemDefault()).toLocalDateTime();
                    dueDateTextfield.setText(DateTimeFormatter.ofPattern("dd.MM.yyyy").format(localDate));
                    Label dueDateLabel = new Label(Translator.tr((String)"FLD_ACT_LASTACTIVITYDATE"));
                    dueDateLabel.setPrefWidth(150.0);
                    dueDateHbox.getChildren().addAll((Object[])new Node[]{dueDateLabel, dueDateTextfield});
                }
                VBox vbox = new VBox();
                vbox.setSpacing(5.0);
                vbox.setPadding(new Insets(0.0, 0.0, 0.0, 20.0));
                vbox.getChildren().addAll((Object[])new Node[]{gridpane, this.getErrorMsg(), new WflActionButtonPane(this, task), dueDateHbox});
                if (WflController.getInstance().getActual() == WflPanelType.MYCREATEDTASKS) {
                    vbox.getChildren().addAll((Object[])new Node[]{new Label(Translator.tr((String)"FLD_ACT_WFLIDENTITY_LINKS")), new WflIdentityLinkTable(this, task)});
                }
                vbox.getChildren().addAll((Object[])new Node[]{this.getWflDataTablebase()});
                if (task.getAct_endTime().getData() == null) {
                    this.setTop((Node)this.getToolbar());
                }
                this.setContent((Node)vbox);
                this.setWorking(false);
                boolean forProcInstId = task.getPjmprogkey() != null && task.getPjmprogkey().getAct_value().getData() != null && task.getPjmprogkey().getAct_value().getData().equals("PJMDOC");
                WflController.getInstance().getAttachments(this.getWflDataTablebase(), task.getAct_processInstanceId().getData(), task.getAct_id().getData(), forProcInstId);
                WflController.getInstance().getComments(this.getWflDataTablebase(), task.getAct_processInstanceId().getData(), task.getAct_id().getData());
            }
        });
        WflController.getInstance().executeTask(getTask);
    }
}

