/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl;

import de.effectivecompany.app.syswfl.BoWflAttachment;
import de.effectivecompany.app.syswfl.BoWflComment;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.client.controller.WflActions;
import de.effectivecompany.gui.components.fx.EFCFxButton;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.fx.wfl.WflPane;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ToolBar;

public class WflToolbar
extends ToolBar {
    private final Button edit;
    private final Button save;
    private final Button delete;
    private final Button cancel;
    private final Button add;
    private final Button remove;
    private final Button show;
    private WflPane parent = null;
    private final EventHandler<ActionEvent> saveAttachmentEvent = event -> {
        BoWflAttachment attachment = (BoWflAttachment)this.parent.getWflDataTablebase().getDataTable().getSelectionModel().getSelectedItem();
        attachment.setAct_name(this.parent.getWflDataTablebase().getAttNameTextField().getText());
        attachment.setAct_description(this.parent.getWflDataTablebase().getAttDescriptionTextArea().getText());
        attachment.setAct_url(this.parent.getWflDataTablebase().getAttUrlTextField().getText());
        WflController.getInstance().saveAttachment(this.parent.getWflDataTablebase(), this.parent.getErrorMsg(), attachment);
        this.disableSaveAttachment();
        this.parent.getWflDataTablebase().getCommentTable().setDisable(false);
        this.parent.getWflDataTablebase().getDataTable().setDisable(false);
    };
    private final EventHandler<ActionEvent> showAttachmentEvent = event -> {
        BoWflAttachment bo = (BoWflAttachment)this.parent.getWflDataTablebase().getDataTable().getSelectionModel().getSelectedItem();
        boolean isUrl = false;
        String id = bo.getAct_id().getData();
        if (bo.getAct_url() != null && bo.getAct_url().getData() != null && !bo.getAct_url().getData().isEmpty()) {
            isUrl = true;
            id = bo.getAct_url().getData();
        }
        if (id != null || !id.isEmpty()) {
            WflController.getInstance().getAttachmentContent(bo.getAct_name().getData(), id, isUrl);
        }
    };
    private final EventHandler<ActionEvent> deleteAttachmentEvent = event -> {
        BoWflAttachment bo = (BoWflAttachment)this.parent.getWflDataTablebase().getDataTable().getSelectionModel().getSelectedItem();
        if (bo != null) {
            WflController.getInstance().deleteAttachment(this.parent.getWflDataTablebase(), bo);
        }
    };
    private final EventHandler<ActionEvent> cancelAttachmentEvent = event -> {
        this.parent.getWflDataTablebase().getDataTable().disableProperty().setValue(Boolean.valueOf(false));
        this.parent.getWflDataTablebase().getCommentTable().setDisable(false);
        this.disableCancelComment();
        this.disableSaveAttachment();
    };
    private final EventHandler<ActionEvent> deleteCommentEvent = event -> {
        if (this.parent.getWflDataTablebase().getCommentTable().getSelectionModel().getSelectedItem() != null) {
            WflController.getInstance().deleteComment(this.parent.getWflDataTablebase(), (BoWflComment)this.parent.getWflDataTablebase().getCommentTable().getSelectionModel().getSelectedItem());
        }
    };
    private final EventHandler<ActionEvent> saveCommentEvent = event -> {
        Button src = (Button)event.getSource();
        String procInstId = (String)this.parent.getTaskProcIdMap().get((Object)src.getId());
        if (this.parent.getWflDataTablebase().getCommentMessageTextField().textProperty().get() != null && !((String)this.parent.getWflDataTablebase().getCommentMessageTextField().textProperty().get()).isEmpty()) {
            WflController.getInstance().addComment(this.parent.getWflDataTablebase(), this.parent.getErrorMsg(), procInstId, src.getId(), (String)this.parent.getWflDataTablebase().getCommentMessageTextField().textProperty().get());
            this.parent.getWflDataTablebase().getCommentTable().disableProperty().setValue(Boolean.valueOf(false));
            this.parent.getToolbar().disableSaveComment();
            this.parent.getToolbar().disableCancelComment();
            this.parent.getToolbar().enableRemoveComment();
        }
    };
    private final EventHandler<ActionEvent> editAttachmentEvent = event -> {
        this.parent.getWflDataTablebase().getDataTable().setDisable(true);
        this.parent.getWflDataTablebase().getCommentTable().setDisable(true);
        this.disableAddAttachment();
        this.enableSaveAttachment();
        this.enableCancelAttachment();
        this.disableShowAttachment();
        this.parent.getWflDataTablebase().getAttNameTextField().textProperty().unbind();
        this.parent.getWflDataTablebase().getAttDescriptionTextArea().textProperty().unbind();
        this.parent.getWflDataTablebase().getAttUrlTextField().textProperty().unbind();
    };
    private final EventHandler<ActionEvent> addCommentEvent = event -> {
        this.parent.getWflDataTablebase().getCommentTable().disableProperty().setValue(Boolean.valueOf(true));
        this.parent.getWflDataTablebase().getCommentMessageTextField().textProperty().unbind();
        this.parent.getWflDataTablebase().getCommentMessageTextField().clear();
        this.disableAddComment();
        this.enableSaveComment();
        this.enableCancelComment();
        this.enableRemoveComment();
    };
    private final EventHandler<ActionEvent> cancelCommentEvent = event -> {
        this.parent.getWflDataTablebase().getCommentTable().disableProperty().setValue(Boolean.valueOf(false));
        this.parent.getWflDataTablebase().getCommentMessageTextField().clear();
        this.disableCancelComment();
    };
    EventHandler<ActionEvent> addAttachmentEvent = event -> {
        Button src = (Button)event.getSource();
        String procInstId = this.parent.getTaskProcIdMap().containsKey((Object)src.getId()) && ((String)this.parent.getTaskProcIdMap().get((Object)src.getId())).isEmpty() ? null : (String)this.parent.getTaskProcIdMap().get((Object)src.getId());
        WflActions.addWflAttachment(this.parent, null, src.getId(), procInstId);
    };

    public WflToolbar(String taskId, WflPane parent) {
        this.edit = new EFCFxButton(taskId, EFCLookAndFeelManager.ICON_TOOLBAR_OPEN_FX, Translator.tr((String)"ACTION_OPEN_DESC"));
        this.save = new EFCFxButton(taskId, EFCLookAndFeelManager.ICON_TOOLBAR_SAVE_FX, Translator.tr((String)"ACTION_SAVE_DESC"));
        this.delete = new EFCFxButton(taskId, EFCLookAndFeelManager.ICON_TOOLBAR_DELETE_FX, Translator.tr((String)"ACTION_DELETE_DESC"));
        this.cancel = new EFCFxButton(taskId, EFCLookAndFeelManager.ICON_TOOLBAR_CANCEL_FX, Translator.tr((String)"ACTION_CANCEL_DESC"));
        this.add = new EFCFxButton(taskId, EFCLookAndFeelManager.ICON_TOOLBAR_LIST_ADD_FX, Translator.tr((String)"ACTION_LIST_ADD_DESC"));
        this.remove = new EFCFxButton(taskId, EFCLookAndFeelManager.ICON_TOOLBAR_LIST_REMOVE_FX, Translator.tr((String)"ACTION_LIST_REMOVE_DESC"));
        this.show = new EFCFxButton(taskId, EFCLookAndFeelManager.ICON_TOOLBAR_RELATED_DOCS_FX, Translator.tr((String)"ACTION_RELATED_DOCS_DESC"));
        this.parent = parent;
        this.edit.setDisable(true);
        this.save.setDisable(true);
        this.delete.setDisable(true);
        this.add.setDisable(true);
        this.cancel.setDisable(true);
        this.remove.setDisable(true);
        this.show.setDisable(true);
        this.setStyle("-fx-background-color: rgb(" + EFCLookAndFeelManager.COLOR_INFOTEXT_BACKGROUND.getRed() + ", " + EFCLookAndFeelManager.COLOR_INFOTEXT_BACKGROUND.getGreen() + ", " + EFCLookAndFeelManager.COLOR_INFOTEXT_BACKGROUND.getBlue() + ")");
        this.getItems().addAll((Object[])new Node[]{this.edit, this.save, this.delete, this.cancel, this.add, this.remove, this.show});
    }

    public Button getEdit() {
        return this.edit;
    }

    public Button getSave() {
        return this.save;
    }

    public Button getDelete() {
        return this.delete;
    }

    public Button getCancel() {
        return this.cancel;
    }

    public Button getAdd() {
        return this.add;
    }

    public Button getRemove() {
        return this.remove;
    }

    public Button getShow() {
        return this.show;
    }

    public void enableShowAttachment() {
        this.show.setOnAction(this.showAttachmentEvent);
        this.show.setDisable(false);
    }

    public void disableShowAttachment() {
        this.show.setOnAction(null);
        this.show.setDisable(true);
    }

    public void enableRemoveAttachment() {
        this.remove.setOnAction(this.deleteAttachmentEvent);
        this.remove.setDisable(false);
    }

    public void disableRemoveAttachment() {
        this.remove.setOnAction(null);
        this.remove.setDisable(true);
    }

    public void enableSaveAttachment() {
        this.save.setOnAction(this.saveAttachmentEvent);
        this.save.setDisable(false);
    }

    public void disableSaveAttachment() {
        this.save.setOnAction(null);
        this.save.setDisable(true);
    }

    public void enableAddAttachment() {
        this.add.setOnAction(this.addAttachmentEvent);
        this.add.setDisable(false);
    }

    public void disableAddAttachment() {
        this.add.setOnAction(null);
        this.add.setDisable(true);
    }

    public void enableEditAttachment() {
        this.edit.setOnAction(this.editAttachmentEvent);
        this.edit.setDisable(false);
    }

    public void disableEditAttachment() {
        this.edit.setOnAction(null);
        this.edit.setDisable(true);
    }

    public void enableCancelComment() {
        this.remove.setOnAction(this.cancelCommentEvent);
        this.remove.setDisable(false);
    }

    public void disableCancelComment() {
        this.remove.setOnAction(null);
        this.remove.setDisable(true);
    }

    public void enableCancelAttachment() {
        this.remove.setOnAction(this.cancelAttachmentEvent);
        this.remove.setDisable(false);
    }

    public void disableCancelAttachment() {
        this.remove.setOnAction(null);
        this.remove.setDisable(true);
    }

    public void enableRemoveComment() {
        this.remove.setOnAction(this.deleteCommentEvent);
        this.remove.setDisable(false);
    }

    public void disableRemoveComment() {
        this.remove.setOnAction(null);
        this.remove.setDisable(true);
    }

    public void enableSaveComment() {
        this.save.setOnAction(this.saveCommentEvent);
        this.save.setDisable(false);
    }

    public void disableSaveComment() {
        this.save.setOnAction(null);
        this.save.setDisable(true);
    }

    public void enableAddComment() {
        this.add.setOnAction(this.addCommentEvent);
        this.add.setDisable(false);
    }

    public void disableAddComment() {
        this.add.setOnAction(null);
        this.add.setDisable(true);
    }
}

