/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl.service;

import de.effectivecompany.app.syswfl.service.SvBoWflProcDef;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.root.EFCDesktop;
import javafx.concurrent.Task;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCActiveProcessesForActualUserCountService {
    private static Logger logger = LoggerFactory.getLogger(EFCActiveProcessesForActualUserCountService.class);
    private final SvBoWflProcDef processes = (SvBoWflProcDef)SpringHelper.getBean((String)"syswfl_SvBoWflProcDef");
    private WflController controller;

    public EFCActiveProcessesForActualUserCountService(WflController controller) {
        this.controller = controller;
    }

    public void start(boolean isAdmin) {
        if (isAdmin) {
            this.controller.getWflButtonBar().setAdminActualizeActiveProcessesForActualUserCountWorking(true);
        } else {
            this.controller.getWflButtonBar().setActualizeActiveProcessesForActualUserCountWorking(true);
        }
        Task<Integer> task = this.createTask(isAdmin);
        task.setOnSucceeded(taskEvent -> {
            if (taskEvent.getSource().valueProperty().get() != null) {
                if (isAdmin) {
                    this.controller.getWflButtonBar().adminActualizeActiveProcessesForActualUserCount((Integer)taskEvent.getSource().valueProperty().get());
                } else {
                    this.controller.getWflButtonBar().actualizeActiveProcessesForActualUserCount((Integer)taskEvent.getSource().valueProperty().get());
                }
            }
            if (isAdmin) {
                this.controller.getWflButtonBar().setAdminActualizeActiveProcessesForActualUserCountWorking(false);
            } else {
                this.controller.getWflButtonBar().setActualizeActiveProcessesForActualUserCountWorking(false);
            }
        });
        task.setOnFailed(taskEvent -> {
            if (isAdmin) {
                this.controller.getWflButtonBar().setAdminActualizeActiveProcessesForActualUserCountWorking(false);
                this.controller.getWflButtonBar().adminActualizeActiveProcessesForActualUserCount(0);
            } else {
                this.controller.getWflButtonBar().setActualizeActiveProcessesForActualUserCountWorking(false);
                this.controller.getWflButtonBar().actualizeActiveProcessesForActualUserCount(0);
            }
            if (!(taskEvent.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
            }
            logger.error("", taskEvent.getSource().exceptionProperty().get());
        });
        this.controller.executeTask(task);
    }

    private Task<Integer> createTask(final boolean isAdmin) {
        return new Task<Integer>(){

            protected Integer call() throws Exception {
                if (isAdmin) {
                    return EFCActiveProcessesForActualUserCountService.this.processes.getActiveProcessesForAdminCount().getIntValue();
                }
                return EFCActiveProcessesForActualUserCountService.this.processes.getActiveProcessesForActualUserCount().getIntValue();
            }
        };
    }
}

