/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl.service;

import de.effectivecompany.app.syswfl.BoWflTaskHeader;
import de.effectivecompany.app.syswfl.service.SvBoWflTasks;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.root.EFCDesktop;
import java.util.List;
import javafx.concurrent.Task;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCActiveTasksByGroupService {
    private static Logger logger = LoggerFactory.getLogger(EFCActiveTasksByGroupService.class);
    private final SvBoWflTasks tasks = (SvBoWflTasks)SpringHelper.getBean((String)"syswfl_SvBoWflTasks");
    private WflController controller;

    public EFCActiveTasksByGroupService(WflController controller) {
        this.controller = controller;
    }

    public void start(boolean forAdmin) {
        this.controller.getWflTaskByGroupListPane().setWorking(true);
        Task<EFCList<BoWflTaskHeader>> task = this.createTask(forAdmin);
        task.setOnSucceeded(taskEvent -> {
            if (taskEvent.getSource().valueProperty().get() != null && this.controller.getWflTaskByGroupListPane() != null) {
                this.controller.getWflTaskByGroupListPane().setMyTaskList((List)taskEvent.getSource().valueProperty().get());
            }
            if (this.controller.getWflTaskByGroupListPane() != null) {
                this.controller.getWflTaskByGroupListPane().setWorking(false);
            }
        });
        task.setOnFailed(taskEvent -> {
            if (!(taskEvent.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
            }
            logger.error("", taskEvent.getSource().exceptionProperty().get());
        });
        this.controller.executeTask(task);
    }

    private Task<EFCList<BoWflTaskHeader>> createTask(final boolean forAdmin) {
        return new Task<EFCList<BoWflTaskHeader>>(){

            protected EFCList<BoWflTaskHeader> call() throws Exception {
                if (forAdmin) {
                    return EFCActiveTasksByGroupService.this.tasks.getActiveTasksForGroupForAdmin();
                }
                return EFCActiveTasksByGroupService.this.tasks.getActiveTasksForGroup();
            }
        };
    }
}

