/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl.service;

import de.effectivecompany.app.syswfl.BoWflAttachment;
import de.effectivecompany.app.syswfl.service.SvBoWflProcDef;
import de.effectivecompany.base.datatypes.EFCBlob;
import de.effectivecompany.base.datatypes.EFCOption;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.EFCController;
import de.effectivecompany.gui.components.fx.wfl.WflPane;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.util.EFCThreadUtil;
import javafx.concurrent.Task;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCAddAttachmentService {
    private static Logger logger = LoggerFactory.getLogger(EFCAddAttachmentService.class);
    private final SvBoWflProcDef processes = (SvBoWflProcDef)SpringHelper.getBean((String)"syswfl_SvBoWflProcDef");

    public void startService(WflPane controller, EFCController efcController, String processId, String taskId, String name, String description, String type, EFCBlob data, String url) {
        if (controller != null && controller.getWflDataTablebase() != null) {
            controller.getWflDataTablebase().getDataPin().setVisible(true);
        }
        if (efcController != null) {
            efcController.lockControl();
        }
        Task<BoWflAttachment> task = this.createTask(processId, taskId, name, description, url, data, type);
        task.setOnSucceeded(taskEvent -> {
            if (controller != null && controller.getWflDataTablebase() != null && controller.getWflDataTablebase().getDataTable() != null && taskEvent.getSource().valueProperty().get() != null) {
                BoWflAttachment attachment = (BoWflAttachment)taskEvent.getSource().valueProperty().get();
                controller.getWflDataTablebase().getDataTable().getItems().add((Object)attachment);
                controller.getWflDataTablebase().getDataTable().disableProperty().setValue(Boolean.valueOf(false));
            }
            if (efcController != null) {
                EFCDesktop.showInfoDlg(Translator.tr((String)"MSG_FRAME_SAVEDATA_DONE"));
                efcController.unlockControl();
                efcController.actionActualizeObject();
            }
            if (controller != null && controller.getWflDataTablebase() != null) {
                controller.getWflDataTablebase().getDataPin().setVisible(false);
            }
        });
        task.setOnFailed(taskEvent -> {
            if (controller != null && controller.getWflDataTablebase() != null) {
                controller.getWflDataTablebase().getDataPin().setVisible(false);
            }
            if (efcController != null) {
                efcController.unlockControl();
            }
            if (!(taskEvent.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
            }
            logger.error("", taskEvent.getSource().exceptionProperty().get());
        });
        EFCThreadUtil.getCachedExecutorService().submit((Runnable)task);
    }

    private Task<BoWflAttachment> createTask(final String processId, final String taskId, final String name, final String description, final String url, final EFCBlob data, final String type) {
        return new Task<BoWflAttachment>(){

            protected BoWflAttachment call() throws Exception {
                BoWflAttachment attachment = new BoWflAttachment();
                attachment.setAct_description(description);
                attachment.setAct_name(name);
                attachment.setAct_processInstanceId(processId);
                attachment.setAct_taskId(taskId);
                attachment.setData(data);
                attachment.setAct_type(type);
                attachment.setAct_url(url);
                if (url != null && !url.isEmpty()) {
                    attachment.setAct_attachmenttype(new EFCOption(Integer.valueOf(20)));
                    attachment.setAct_type("url");
                } else {
                    attachment.setAct_attachmenttype(new EFCOption(Integer.valueOf(10)));
                }
                return EFCAddAttachmentService.this.processes.addAttachment(attachment);
            }
        };
    }
}

