/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl.service;

import de.effectivecompany.app.syswfl.BoWflAttachment;
import de.effectivecompany.app.syswfl.service.SvBoWflProcDef;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.fx.wfl.WflTableBase;
import de.effectivecompany.gui.components.root.EFCDesktop;
import javafx.concurrent.Task;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCDeleteAttachmentService {
    private static Logger logger = LoggerFactory.getLogger(EFCDeleteAttachmentService.class);
    private final SvBoWflProcDef processes = (SvBoWflProcDef)SpringHelper.getBean((String)"syswfl_SvBoWflProcDef");
    private WflController controller;

    public EFCDeleteAttachmentService(WflController controller) {
        this.controller = controller;
    }

    public void startService(WflTableBase dataTable, BoWflAttachment attachment) {
        dataTable.getDataPin().setVisible(true);
        Task<Void> task = this.createTask(attachment.getAct_id().getData());
        task.setOnSucceeded(event -> {
            if (dataTable != null) {
                dataTable.getDataTable().getItems().remove((Object)attachment);
            }
            dataTable.getDataPin().setVisible(false);
        });
        task.setOnFailed(taskEvent -> {
            dataTable.getDataPin().setVisible(false);
            if (!(taskEvent.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
            }
            logger.error("", taskEvent.getSource().exceptionProperty().get());
        });
        this.controller.executeTask(task);
    }

    private Task<Void> createTask(final String attachmentId) {
        return new Task<Void>(){

            protected Void call() throws Exception {
                EFCDeleteAttachmentService.this.processes.deleteAttachment(attachmentId);
                return null;
            }
        };
    }
}

