/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl.service;

import de.effectivecompany.app.syswfl.BoWflComment;
import de.effectivecompany.app.syswfl.service.SvBoWflProcDef;
import de.effectivecompany.base.datatypes.EFCBoolean;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.fx.wfl.WflTableBase;
import de.effectivecompany.gui.components.root.EFCDesktop;
import javafx.concurrent.Task;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCDeleteCommentService {
    private static Logger logger = LoggerFactory.getLogger(EFCDeleteCommentService.class);
    private final SvBoWflProcDef processes = (SvBoWflProcDef)SpringHelper.getBean((String)"syswfl_SvBoWflProcDef");
    private WflController controller;

    public EFCDeleteCommentService(WflController controller) {
        this.controller = controller;
    }

    public void startService(WflTableBase dataTable, BoWflComment comment) {
        dataTable.getcommentPin().setVisible(true);
        Task<EFCBoolean> task = this.createTask(comment.getAct_id().getData());
        task.setOnSucceeded(event -> {
            if (dataTable != null && event.getSource().getValue() != null && event.getSource().getValue() instanceof EFCBoolean && ((EFCBoolean)event.getSource().getValue()).getData().booleanValue()) {
                dataTable.getCommentTable().getItems().remove((Object)comment);
            }
            dataTable.getcommentPin().setVisible(false);
        });
        task.setOnFailed(taskEvent -> {
            dataTable.getcommentPin().setVisible(false);
            if (!(taskEvent.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
            }
            logger.error("", taskEvent.getSource().exceptionProperty().get());
        });
        this.controller.executeTask(task);
    }

    private Task<EFCBoolean> createTask(final String commentId) {
        return new Task<EFCBoolean>(){

            protected EFCBoolean call() throws Exception {
                return EFCDeleteCommentService.this.processes.deleteComment(commentId);
            }
        };
    }
}

