/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl.service;

import de.effectivecompany.app.syswfl.BoWflAttachment;
import de.effectivecompany.app.syswfl.service.SvBoWflProcDef;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.fx.wfl.WflTableBase;
import de.effectivecompany.gui.components.root.EFCDesktop;
import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.concurrent.Task;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCGetAttachmentsService {
    private static Logger logger = LoggerFactory.getLogger(EFCGetAttachmentsService.class);
    private final SvBoWflProcDef processes = (SvBoWflProcDef)SpringHelper.getBean((String)"syswfl_SvBoWflProcDef");
    private WflController controller;

    public EFCGetAttachmentsService(WflController controller) {
        this.controller = controller;
    }

    public void startService(WflTableBase dataTable, String processId, String taskId, boolean forProcInstId) {
        dataTable.getDataPin().setVisible(true);
        Task<EFCList<BoWflAttachment>> task = processId != null && !processId.isEmpty() && forProcInstId ? this.createTaskForProcessId(processId) : this.createTaskForTaskId(taskId);
        task.setOnSucceeded(event -> {
            if (dataTable != null) {
                dataTable.getDataTable().getItems().clear();
                if (event.getSource().valueProperty().get() != null) {
                    dataTable.getDataTable().setItems(FXCollections.observableArrayList((Collection)((EFCList)event.getSource().valueProperty().get())));
                }
            }
            dataTable.getDataPin().setVisible(false);
        });
        task.setOnFailed(taskEvent -> {
            dataTable.getDataPin().setVisible(false);
            if (!(taskEvent.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
            }
            logger.error("", taskEvent.getSource().exceptionProperty().get());
        });
        this.controller.executeTask(task);
    }

    private Task<EFCList<BoWflAttachment>> createTaskForTaskId(final String taskId) {
        return new Task<EFCList<BoWflAttachment>>(){

            protected EFCList<BoWflAttachment> call() throws Exception {
                return EFCGetAttachmentsService.this.processes.getAttachmentsForTask(taskId);
            }
        };
    }

    private Task<EFCList<BoWflAttachment>> createTaskForProcessId(final String processId) {
        return new Task<EFCList<BoWflAttachment>>(){

            protected EFCList<BoWflAttachment> call() throws Exception {
                return EFCGetAttachmentsService.this.processes.getAttachmentsForProc(processId);
            }
        };
    }
}

