/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl.service;

import de.effectivecompany.app.sys.MdSysUsrBas;
import de.effectivecompany.app.sys.service.SvMdSysUsrBas;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.pane.EFCLockPane;
import de.effectivecompany.gui.components.fx.wfl.EFCComboBox;
import de.effectivecompany.gui.components.fx.wfl.EFCSelectionListView;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.root.EFCDesktop;
import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCGetUsersService {
    private static Logger logger = LoggerFactory.getLogger(EFCGetUsersService.class);
    private final SvMdSysUsrBas svMdSysUsrBas = (SvMdSysUsrBas)SpringHelper.getBean((String)"sys_SvMdSysUsrBas");
    private WflController controller;

    public EFCGetUsersService(WflController controller) {
        this.controller = controller;
    }

    public void startService(EFCSelectionListView commentTable, EFCLockPane pin, boolean sameWflGrp) {
        pin.setVisible(true);
        Task<EFCList<MdSysUsrBas>> task = this.createTask(sameWflGrp);
        task.setOnSucceeded(event -> {
            if (commentTable != null) {
                commentTable.getItems().clear();
                if (event.getSource().valueProperty().get() != null) {
                    ObservableList ob = FXCollections.observableArrayList((Collection)((EFCList)event.getSource().valueProperty().get()));
                    commentTable.setItems(ob);
                }
            }
            pin.setVisible(false);
        });
        task.setOnFailed(taskEvent -> {
            pin.setVisible(false);
            if (!(taskEvent.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
            }
            logger.error("", taskEvent.getSource().exceptionProperty().get());
        });
        this.controller.executeTask(task);
    }

    public void startService(EFCComboBox commentTable, EFCLockPane pin, boolean sameWflGrp) {
        pin.setVisible(true);
        Task<EFCList<MdSysUsrBas>> task = this.createTask(sameWflGrp);
        task.setOnSucceeded(event -> {
            if (commentTable != null) {
                commentTable.getItems().clear();
                if (event.getSource().valueProperty().get() != null) {
                    ObservableList ob = FXCollections.observableArrayList((Collection)((EFCList)event.getSource().valueProperty().get()));
                    commentTable.getItems().clear();
                    commentTable.getItems().add(null);
                    commentTable.getItems().addAll((Collection)ob);
                }
            }
            pin.setVisible(false);
        });
        task.setOnFailed(taskEvent -> {
            pin.setVisible(false);
            if (!(taskEvent.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
            }
            logger.error("", taskEvent.getSource().exceptionProperty().get());
        });
        this.controller.executeTask(task);
    }

    private Task<EFCList<MdSysUsrBas>> createTask(final boolean sameWflGrp) {
        return new Task<EFCList<MdSysUsrBas>>(){

            protected EFCList<MdSysUsrBas> call() throws Exception {
                if (sameWflGrp) {
                    return EFCGetUsersService.this.svMdSysUsrBas.getAllForUserInSameWflGrps();
                }
                return EFCGetUsersService.this.svMdSysUsrBas.getAllWithWflGrp();
            }
        };
    }
}

