/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl.service;

import de.effectivecompany.app.app.service.SvSysMail;
import de.effectivecompany.app.sys.BoSysMailBase;
import de.effectivecompany.app.sys.DcSysMailSelect;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.root.EFCDesktop;
import java.util.List;
import javafx.concurrent.Task;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCMailInboxTaskService {
    private static Logger logger = LoggerFactory.getLogger(EFCMailInboxTaskService.class);
    private final SvSysMail svSysMail = (SvSysMail)SpringHelper.getBean((String)"app_SvSysMail");
    private WflController controller;

    public EFCMailInboxTaskService(WflController controller) {
        this.controller = controller;
    }

    public void start() {
        Task<DcSysMailSelect> task = this.createTask();
        task.setOnSucceeded(taskEvent -> {
            if (taskEvent.getSource().valueProperty().get() != null && this.controller.getEfcWflMailInboxListPane() != null) {
                this.controller.getEfcWflMailInboxListPane().setInboxList((List<BoSysMailBase>)((DcSysMailSelect)taskEvent.getSource().valueProperty().get()).getMailList());
            }
        });
        task.setOnFailed(taskEvent -> {
            this.controller.getWflButtonBar().setActualizeMyCreatedTasksCountWorking(false);
            if (!(taskEvent.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
            }
            logger.error("", taskEvent.getSource().exceptionProperty().get());
        });
        this.controller.executeTask(task);
    }

    private Task<DcSysMailSelect> createTask() {
        return new Task<DcSysMailSelect>(){

            protected DcSysMailSelect call() throws Exception {
                return EFCMailInboxTaskService.this.svSysMail.getMailsFromFolderTransfer();
            }
        };
    }
}

