/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl.service;

import de.effectivecompany.app.syscl.ClSysWflParamDet;
import de.effectivecompany.app.syswfl.BoWflTask;
import de.effectivecompany.app.syswfl.BoWflVariable;
import de.effectivecompany.app.syswfl.service.SvBoWflTasks;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.util.ObjectUtil2;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.EFCController;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.fx.wfl.WflPane;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.constants.EFCParamConstants;
import java.util.Map;
import javafx.concurrent.Task;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCSetVariablesForTaskService {
    private static Logger logger = LoggerFactory.getLogger(EFCSetVariablesForTaskService.class);
    private final SvBoWflTasks tasks = (SvBoWflTasks)SpringHelper.getBean((String)"syswfl_SvBoWflTasks");
    private WflController controller;

    public EFCSetVariablesForTaskService() {
    }

    public EFCSetVariablesForTaskService(WflController controller) {
        this.controller = controller;
    }

    public Task<BoWflTask> createTask(final BoWflTask task, final EFCController controller) {
        return new Task<BoWflTask>(){

            protected BoWflTask call() throws Exception {
                EFCMap variables = new EFCMap();
                BoWflVariable pjmprogkey = (BoWflVariable)task.getAct_variables().get((Object)EFCParamConstants.WFL_CONST_PROGKEY);
                EFCList paramList = new EFCList();
                if (pjmprogkey != null && pjmprogkey.getAct_value() != null && WflController.getInstance().getWflParams().get((Object)pjmprogkey.getAct_value()) != null) {
                    paramList = (EFCList)WflController.getInstance().getWflParams().get((Object)pjmprogkey.getAct_value());
                    for (Map.Entry entry : task.getAct_formvariables().entrySet()) {
                        if (!((EFCString)entry.getKey()).getData().toLowerCase().startsWith("var_")) continue;
                        for (ClSysWflParamDet det : paramList) {
                            if (det.getWflextparamcode().getData() == null || !((BoWflVariable)entry.getValue()).getAct_id().getData().equalsIgnoreCase(det.getWflextparamcode().getData()) || det.getIssyncsystowflext().getData() == null || !det.getIssyncsystowflext().getData().booleanValue() || det.getSysparamcode().getData() == null || det.getSysparamcode().getData().isEmpty()) continue;
                            Object value = ObjectUtil2.getAttributeByDomainName((String)det.getSysparamcode().getData(), (Object)controller.getBusObj());
                            if (value != null) {
                                variables.put((Object)det.getWflextparamcode(), (Object)new EFCString(value.toString()));
                                continue;
                            }
                            variables.put((Object)det.getWflextparamcode(), (Object)new EFCString());
                        }
                    }
                }
                return EFCSetVariablesForTaskService.this.tasks.setVariablesForTask(task.getAct_id(), variables);
            }
        };
    }

    public Task<BoWflTask> createTask(final EFCString taskId, final EFCMap<EFCString, EFCString> variables) {
        return new Task<BoWflTask>(){

            protected BoWflTask call() throws Exception {
                return EFCSetVariablesForTaskService.this.tasks.setVariablesForTask(taskId, variables);
            }
        };
    }

    public void startService(WflPane taskPane, EFCString taskId, EFCMap<EFCString, EFCString> variables) {
        taskPane.setWorking(true);
        Task<BoWflTask> task = this.createTask(taskId, variables);
        task.setOnSucceeded(handler -> taskPane.setWorking(false));
        task.setOnFailed(taskEvent -> {
            taskPane.setWorking(false);
            if (!(taskEvent.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
            }
            logger.error("", taskEvent.getSource().exceptionProperty().get());
        });
        this.controller.executeTask(task);
    }
}

