/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl.service;

import de.effectivecompany.app.syswfl.BoWflProc;
import de.effectivecompany.app.syswfl.service.SvBoWflProcDef;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.msg.MsgType;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.root.EFCDesktop;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Label;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCStartProcessService {
    private static Logger logger = LoggerFactory.getLogger(EFCStartProcessService.class);
    private final SvBoWflProcDef processes = (SvBoWflProcDef)SpringHelper.getBean((String)"syswfl_SvBoWflProcDef");
    private WflController controller;

    public EFCStartProcessService(WflController controller) {
        this.controller = controller;
    }

    public EFCStartProcessService() {
    }

    public void startService(String processId, EFCMap<EFCString, EFCString> variables, Label label) {
        if (this.controller != null && this.controller.getWflAvailableProcPane() != null) {
            this.controller.getWflAvailableProcPane().setWorking(true);
        }
        Task<BoWflProc> task = this.createTask(processId, variables);
        task.setOnSucceeded(this.getonSucceededHandler(label));
        task.setOnFailed(taskEvent -> {
            if (this.controller != null && this.controller.getWflAvailableProcPane() != null) {
                this.controller.getWflAvailableProcPane().setWorking(false);
            }
            if (!(taskEvent.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
            }
            logger.error("", taskEvent.getSource().exceptionProperty().get());
        });
        this.controller.executeTask(task);
    }

    public Task<BoWflProc> createTask(final String processId, final EFCMap<EFCString, EFCString> variables) {
        return new Task<BoWflProc>(){

            protected BoWflProc call() throws Exception {
                return EFCStartProcessService.this.processes.startProcess(new EFCString(processId), variables);
            }
        };
    }

    private EventHandler<WorkerStateEvent> getonSucceededHandler(final Label label) {
        return new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                if (label != null && event.getSource().valueProperty().get() != null && event.getSource().valueProperty().get() instanceof BoWflProc) {
                    BoWflProc proc = (BoWflProc)event.getSource().valueProperty().get();
                    if (proc.getCompleteMsgList().getMaxSeverity() == MsgType.ERROR) {
                        StringBuilder message = new StringBuilder("");
                        proc.getCompleteMsgList().getMsgList().forEach(msg -> message.append(msg.getMsg().getMsg()));
                        label.setText(message.toString());
                    } else {
                        label.setText("Prozess gestartet. " + proc.getAct_id() + " " + proc.getAct_name());
                    }
                }
                if (EFCStartProcessService.this.controller != null) {
                    EFCStartProcessService.this.controller.getWflAvailableProcPane().setWorking(false);
                }
            }
        };
    }
}

