/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl.service;

import de.effectivecompany.app.syswfl.BoWflTaskHeader;
import de.effectivecompany.app.syswfl.service.SvBoWflTasks;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.root.EFCDesktop;
import java.util.List;
import javafx.concurrent.Task;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCTaskForActualUserService {
    private static Logger logger = LoggerFactory.getLogger(EFCTaskForActualUserService.class);
    private final SvBoWflTasks tasks = (SvBoWflTasks)SpringHelper.getBean((String)"syswfl_SvBoWflTasks");
    private WflController controller;
    private String filter;

    public EFCTaskForActualUserService(WflController controller) {
        this.controller = controller;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void start(boolean forAdmin) {
        if (forAdmin) {
            this.controller.getWflButtonBar().setAdminActualizeTasksForActualUserCountWorking(true);
        } else {
            this.controller.getWflButtonBar().setActualizeTasksForActualUserCountWorking(true);
        }
        if (this.controller.getWflMyQueuedTaskListPane() != null) {
            this.controller.getWflMyQueuedTaskListPane().setWorking(true);
        }
        Task<EFCList<BoWflTaskHeader>> task = this.createTask(forAdmin);
        task.setOnSucceeded(taskEvent -> {
            if (taskEvent.getSource().valueProperty().get() != null && this.controller.getWflMyQueuedTaskListPane() != null) {
                this.controller.getWflMyQueuedTaskListPane().setMyQueuedTaskList((List)taskEvent.getSource().valueProperty().get());
            }
            if (forAdmin) {
                this.controller.getWflButtonBar().setAdminActualizeTasksForActualUserCountWorking(false);
            } else {
                this.controller.getWflButtonBar().setActualizeTasksForActualUserCountWorking(false);
            }
            if (this.controller.getWflMyQueuedTaskListPane() != null) {
                this.controller.getWflMyQueuedTaskListPane().setWorking(false);
            }
        });
        task.setOnFailed(taskEvent -> {
            if (forAdmin) {
                this.controller.getWflButtonBar().setAdminActualizeTasksForActualUserCountWorking(false);
            } else {
                this.controller.getWflButtonBar().setActualizeTasksForActualUserCountWorking(false);
            }
            if (this.controller.getWflMyQueuedTaskListPane() != null) {
                this.controller.getWflMyQueuedTaskListPane().setWorking(false);
            }
            if (!(taskEvent.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
            }
            logger.error("", taskEvent.getSource().exceptionProperty().get());
        });
        this.controller.executeTask(task);
    }

    private Task<EFCList<BoWflTaskHeader>> createTask(final boolean forAdmin) {
        return new Task<EFCList<BoWflTaskHeader>>(){

            protected EFCList<BoWflTaskHeader> call() throws Exception {
                if (forAdmin) {
                    if (EFCTaskForActualUserService.this.controller.getAdminFilter().get() != null && !EFCTaskForActualUserService.this.controller.getAdminFilter().get().isEmpty()) {
                        return EFCTaskForActualUserService.this.tasks.getTasksForActualUserForAdmin(EFCTaskForActualUserService.this.controller.getAdminFilter().get());
                    }
                    return EFCTaskForActualUserService.this.tasks.getTasksForActualUserForAdmin((String)null);
                }
                if (EFCTaskForActualUserService.this.controller.getFilter().get() != null && !EFCTaskForActualUserService.this.controller.getFilter().get().isEmpty()) {
                    return EFCTaskForActualUserService.this.tasks.getTasksForActualUser(EFCTaskForActualUserService.this.controller.getFilter().get());
                }
                return EFCTaskForActualUserService.this.tasks.getTasksForActualUser((String)null);
            }
        };
    }
}

