/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl.service;

import de.effectivecompany.app.syswfl.service.SvBoWflTasks;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.root.EFCDesktop;
import javafx.concurrent.Task;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCTasksForActualUserCountService {
    private static Logger logger = LoggerFactory.getLogger(EFCTasksForActualUserCountService.class);
    private final SvBoWflTasks tasks = (SvBoWflTasks)SpringHelper.getBean((String)"syswfl_SvBoWflTasks");
    private WflController controller;

    public EFCTasksForActualUserCountService(WflController controller) {
        this.controller = controller;
    }

    public void start(boolean isAdmin) {
        if (isAdmin) {
            this.controller.getWflButtonBar().setAdminActualizeTasksForActualUserCountWorking(true);
        } else {
            this.controller.getWflButtonBar().setActualizeTasksForActualUserCountWorking(true);
        }
        Task<Integer> task = this.createTask(isAdmin);
        task.setOnSucceeded(taskEvent -> {
            if (taskEvent.getSource().valueProperty().get() != null) {
                if (isAdmin) {
                    this.controller.getWflButtonBar().adminActualizeTasksForActualUserCount((Integer)taskEvent.getSource().valueProperty().get());
                } else {
                    this.controller.getWflButtonBar().actualizeTasksForActualUserCount((Integer)taskEvent.getSource().valueProperty().get());
                }
            }
            if (isAdmin) {
                this.controller.getWflButtonBar().setAdminActualizeTasksForActualUserCountWorking(false);
            } else {
                this.controller.getWflButtonBar().setActualizeTasksForActualUserCountWorking(false);
            }
        });
        task.setOnFailed(taskEvent -> {
            if (isAdmin) {
                this.controller.getWflButtonBar().setAdminActualizeTasksForActualUserCountWorking(false);
                this.controller.getWflButtonBar().adminActualizeTasksForActualUserCount(0);
            } else {
                this.controller.getWflButtonBar().setActualizeTasksForActualUserCountWorking(false);
                this.controller.getWflButtonBar().actualizeTasksForActualUserCount(0);
            }
            if (!(taskEvent.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
            }
            logger.error("", taskEvent.getSource().exceptionProperty().get());
        });
        this.controller.executeTask(task);
    }

    private Task<Integer> createTask(final boolean isAdmin) {
        return new Task<Integer>(){

            protected Integer call() throws Exception {
                if (isAdmin) {
                    if (EFCTasksForActualUserCountService.this.controller.getAdminFilter().get() != null && !EFCTasksForActualUserCountService.this.controller.getAdminFilter().get().isEmpty()) {
                        return EFCTasksForActualUserCountService.this.tasks.getTasksForActualUserForAdminCount(EFCTasksForActualUserCountService.this.controller.getAdminFilter().get()).getIntValue();
                    }
                    return EFCTasksForActualUserCountService.this.tasks.getTasksForActualUserForAdminCount((String)null).getIntValue();
                }
                if (EFCTasksForActualUserCountService.this.controller.getFilter().get() != null && !EFCTasksForActualUserCountService.this.controller.getFilter().get().isEmpty()) {
                    return EFCTasksForActualUserCountService.this.tasks.getTasksForActualUserCount(EFCTasksForActualUserCountService.this.controller.getFilter().get()).getIntValue();
                }
                return EFCTasksForActualUserCountService.this.tasks.getTasksForActualUserCount((String)null).getIntValue();
            }
        };
    }
}

