/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl.service;

import de.effectivecompany.app.syswfl.BoWflTask;
import de.effectivecompany.app.syswfl.service.SvBoWflTasks;
import de.effectivecompany.base.msg.MsgType;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.root.EFCDesktop;
import javafx.concurrent.Task;
import javafx.scene.control.Label;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCUnclaimTaskService {
    private static Logger logger = LoggerFactory.getLogger(EFCUnclaimTaskService.class);
    private final SvBoWflTasks tasks = (SvBoWflTasks)SpringHelper.getBean((String)"syswfl_SvBoWflTasks");
    private WflController controller;

    public EFCUnclaimTaskService(WflController controller) {
        this.controller = controller;
    }

    public void startService(String taskId, Label label, boolean forAdmin) {
        if (this.controller != null) {
            EFCUnclaimTaskService eFCUnclaimTaskService = this;
            if (eFCUnclaimTaskService.controller.getWflMyTaskListPane() != null) {
                EFCUnclaimTaskService eFCUnclaimTaskService2 = this;
                eFCUnclaimTaskService2.controller.getWflMyTaskListPane().setWorking(true);
            }
        }
        if (this.controller != null && this.controller.getWflTaskByGroupListPane() != null) {
            this.controller.getWflTaskByGroupListPane().setWorking(true);
        }
        Task<BoWflTask> task = this.createTask(taskId);
        task.setOnSucceeded(taskEvent -> {
            if (taskEvent.getSource().valueProperty().get() != null && ((BoWflTask)taskEvent.getSource().valueProperty().get()).getCompleteMsgList().getMaxSeverity() == MsgType.ERROR) {
                StringBuilder message = new StringBuilder("");
                ((BoWflTask)taskEvent.getSource().valueProperty().get()).getCompleteMsgList().getMsgList().forEach(msg -> message.append(msg.getMsg().getMsg()));
                label.setText(message.toString());
            } else {
                label.setText("Aufgabe abgelehnt.");
                if (this.controller != null) {
                    EFCUnclaimTaskService eFCUnclaimTaskService = this;
                    if (eFCUnclaimTaskService.controller.getWflMyTaskListPane() != null) {
                        EFCUnclaimTaskService eFCUnclaimTaskService2 = this;
                        eFCUnclaimTaskService2.controller.getWflMyTaskListPane().remove(((BoWflTask)taskEvent.getSource().valueProperty().get()).getAct_id().getData());
                    }
                }
                if (this.controller != null && this.controller.getWflTaskByGroupListPane() != null) {
                    this.controller.getWflTaskByGroupListPane().remove(((BoWflTask)taskEvent.getSource().valueProperty().get()).getAct_id().getData());
                }
            }
            if (this.controller != null) {
                EFCUnclaimTaskService eFCUnclaimTaskService = this;
                if (eFCUnclaimTaskService.controller.getWflMyTaskListPane() != null) {
                    EFCUnclaimTaskService eFCUnclaimTaskService3 = this;
                    eFCUnclaimTaskService3.controller.getWflMyTaskListPane().setWorking(false);
                }
            }
            if (this.controller != null && this.controller.getWflTaskByGroupListPane() != null) {
                this.controller.getWflTaskByGroupListPane().setWorking(false);
            }
        });
        task.setOnFailed(taskEvent -> {
            if (this.controller != null) {
                EFCUnclaimTaskService eFCUnclaimTaskService = this;
                if (eFCUnclaimTaskService.controller.getWflMyTaskListPane() != null) {
                    EFCUnclaimTaskService eFCUnclaimTaskService2 = this;
                    eFCUnclaimTaskService2.controller.getWflMyTaskListPane().setWorking(false);
                }
            }
            if (this.controller != null && this.controller.getWflTaskByGroupListPane() != null) {
                this.controller.getWflTaskByGroupListPane().setWorking(false);
            }
            if (!(taskEvent.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
            }
            logger.error("", taskEvent.getSource().exceptionProperty().get());
        });
        this.controller.executeTask(task);
    }

    private Task<BoWflTask> createTask(final String taskId) {
        return new Task<BoWflTask>(){

            protected BoWflTask call() throws Exception {
                return EFCUnclaimTaskService.this.tasks.unclaimTask(taskId);
            }
        };
    }
}

