/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.wfl.service;

import de.effectivecompany.app.syswfl.service.SvBoWflTasks;
import de.effectivecompany.base.datatypes.EFCBoolean;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.root.EFCDesktop;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Label;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCUndoTaskService {
    private static Logger logger = LoggerFactory.getLogger(EFCUndoTaskService.class);
    private final SvBoWflTasks tasks = (SvBoWflTasks)SpringHelper.getBean((String)"syswfl_SvBoWflTasks");
    private WflController controller;

    public EFCUndoTaskService(WflController controller) {
        this.controller = controller;
    }

    public void startService(String taskId, Label label, boolean forAdmin) {
        if (this.controller != null && this.controller.getWflMyQueuedTaskListPane() != null) {
            this.controller.getWflMyQueuedTaskListPane().setWorking(true);
        }
        Task<EFCBoolean> task = this.createTask(taskId);
        task.setOnSucceeded(this.getonSucceededHandler(label, forAdmin));
        task.setOnFailed(this.getonFailedHandler(label, forAdmin));
        this.controller.executeTask(task);
    }

    private Task<EFCBoolean> createTask(final String taskId) {
        return new Task<EFCBoolean>(){

            protected EFCBoolean call() throws Exception {
                return EFCUndoTaskService.this.tasks.undoTask(new EFCString(taskId));
            }
        };
    }

    private EventHandler<WorkerStateEvent> getonFailedHandler(Label label, boolean forAdmin) {
        return new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent taskEvent) {
                if (EFCUndoTaskService.this.controller != null && EFCUndoTaskService.this.controller.getWflMyQueuedTaskListPane() != null) {
                    EFCUndoTaskService.this.controller.getWflMyQueuedTaskListPane().setWorking(false);
                }
                if (!(taskEvent.getSource().exceptionProperty().get() instanceof PersistenceException)) {
                    EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
                }
                logger.error("", taskEvent.getSource().exceptionProperty().get());
            }
        };
    }

    private EventHandler<WorkerStateEvent> getonSucceededHandler(final Label label, boolean forAdmin) {
        return new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                if (label != null) {
                    if (event.getSource().valueProperty().get() != null && ((EFCBoolean)event.getSource().valueProperty().get()).getData().booleanValue()) {
                        label.setText(((EFCBoolean)event.getSource().valueProperty().get()).toString());
                    } else {
                        label.setText("Aufgabe beendet.");
                    }
                }
                if (EFCUndoTaskService.this.controller != null && EFCUndoTaskService.this.controller.getWflMyQueuedTaskListPane() != null) {
                    EFCUndoTaskService.this.controller.getWflMyQueuedTaskListPane().setWorking(false);
                }
            }
        };
    }
}

