/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.image;

import de.effectivecompany.base.datatypes.EFCBlob;
import de.effectivecompany.base.i18n.Translator;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class EFCImageViewer {
    private BufferedImage scaledImage;

    public EFCImageViewer(EFCBlob blob) {
        this.setImage(blob.getInputStream());
        JOptionPane.showMessageDialog(null, new ImageIcon(this.scaledImage), Translator.tr((String)"DLG_TITLE_IMAGE_VIEWER"), -1);
    }

    public EFCImageViewer(BufferedImage bufferedImage) {
        this.setImage(bufferedImage);
        JOptionPane.showMessageDialog(null, new ImageIcon(this.scaledImage), Translator.tr((String)"DLG_TITLE_IMAGE_VIEWER"), -1);
    }

    private void setImage(BufferedImage bufferedImage) {
        this.checkImageSize(bufferedImage);
    }

    private void setImage(InputStream stream) {
        try {
            this.checkImageSize(ImageIO.read(stream));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkImageSize(BufferedImage image) {
        int imageHeight;
        int imageWidth;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        double screenSizeMaxWidth = (double)screenSize.width * 0.75;
        double screenSizeMaxHeight = (double)screenSize.height * 0.75;
        int imageWidthScaled = imageWidth = image.getWidth();
        int imageHeightScaled = imageHeight = image.getHeight();
        double scaleFactor = 0.9;
        int scaleSteps = 0;
        while ((double)imageWidthScaled > screenSizeMaxWidth || (double)imageHeightScaled > screenSizeMaxHeight) {
            imageWidthScaled = (int)((double)imageWidthScaled * scaleFactor);
            imageHeightScaled = (int)((double)imageHeightScaled * scaleFactor);
            ++scaleSteps;
        }
        if (scaleSteps > 0) {
            this.scaleImage(image, (double)imageWidthScaled / (double)imageWidth);
        } else {
            this.scaledImage = image;
        }
    }

    private void scaleImage(BufferedImage image, double scaleFactor) {
        double scale = scaleFactor;
        AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(scale, scale), new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC));
        this.scaledImage = op.filter(image, null);
    }
}

