/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.model.table;

import de.effectivecompany.gui.components.model.table.BOTableModel;
import de.effectivecompany.gui.components.model.table.EFCTableColExt;
import de.effectivecompany.gui.components.model.table.ListTableModel;
import de.effectivecompany.gui.components.model.table.ScbTableModel;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;

public class EFCColumnModel
extends DefaultTableColumnModelExt {
    private static final long serialVersionUID = -3985931556260755055L;
    private TableModel model;
    private LinkedHashSet<EFCTableColExt> columns = new LinkedHashSet();

    public EFCColumnModel(TableModel model) {
        this.model = model;
    }

    public Vector<TableColumn> getTableColumns() {
        return this.tableColumns;
    }

    public void setTableColumns(Vector<TableColumn> tableColumns) {
        this.tableColumns = tableColumns;
    }

    public void addColumn(TableColumn aColumn) {
        if (this.getColumnExt(aColumn.getIdentifier()) == null) {
            String columnIdent;
            int modelColumn = aColumn.getModelIndex();
            if (this.model instanceof BOTableModel) {
                columnIdent = ((BOTableModel)this.model).getCols().get(modelColumn);
                if (aColumn instanceof EFCTableColExt) {
                    ((EFCTableColExt)((Object)aColumn)).setToolTipText(((BOTableModel)this.model).getColumnDescription(modelColumn));
                }
                aColumn.setIdentifier(columnIdent);
            } else if (this.model instanceof ListTableModel) {
                columnIdent = ((ListTableModel)this.model).getCols().get(modelColumn);
                if (aColumn instanceof EFCTableColExt) {
                    ((EFCTableColExt)((Object)aColumn)).setToolTipText(((ListTableModel)this.model).getColumnDescription(modelColumn));
                }
                aColumn.setIdentifier(columnIdent);
            } else if (this.model instanceof ScbTableModel) {
                columnIdent = ((ScbTableModel)this.model).getCols().get(modelColumn);
                if (aColumn instanceof EFCTableColExt) {
                    ((EFCTableColExt)((Object)aColumn)).setToolTipText(((ScbTableModel)this.model).getColumnDescription(modelColumn));
                }
                aColumn.setIdentifier(columnIdent);
            }
            super.addColumn(aColumn);
            boolean contains = false;
            for (EFCTableColExt tabColumnExt : this.columns) {
                if (!tabColumnExt.getIdentifier().equals(aColumn.getIdentifier())) continue;
                contains = true;
            }
            if (!contains && aColumn instanceof EFCTableColExt) {
                this.columns.add((EFCTableColExt)((Object)aColumn));
            }
        }
    }

    protected void moveToInvisible(TableColumnExt col) {
        super.moveToInvisible(col);
        for (TableColumnExt tableColumnExt : this.columns) {
            if (!tableColumnExt.getIdentifier().equals(col.getIdentifier())) continue;
            tableColumnExt.setVisible(false);
        }
    }

    protected void moveToVisible(TableColumnExt col) {
        try {
            super.moveToVisible(col);
            for (TableColumnExt tableColumnExt : this.columns) {
                if (!tableColumnExt.getIdentifier().equals(col.getIdentifier())) continue;
                tableColumnExt.setVisible(true);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void moveColumn(int columnIndex, int newIndex) {
        if (columnIndex != newIndex) {
            this.updateCurrentColumns(columnIndex, newIndex);
        }
        super.moveColumn(columnIndex, newIndex);
    }

    private void updateCurrentColumns(int oldIndex, int newIndex) {
        ArrayList<EFCTableColExt> tempList = new ArrayList<EFCTableColExt>(this.columns);
        TableColumn movedColumn = (TableColumn)this.tableColumns.elementAt(oldIndex);
        int oldPosition = -1;
        for (int i = 0; i < tempList.size(); ++i) {
            if (!((EFCTableColExt)((Object)tempList.get(i))).getIdentifier().equals(movedColumn.getIdentifier())) continue;
            oldPosition = i;
        }
        TableColumn targetColumn = (TableColumn)this.tableColumns.elementAt(newIndex);
        int newPosition = -1;
        for (int i = 0; i < tempList.size(); ++i) {
            if (!((EFCTableColExt)((Object)tempList.get(i))).getIdentifier().equals(targetColumn.getIdentifier())) continue;
            newPosition = i;
        }
        tempList.remove(oldPosition);
        if (movedColumn instanceof EFCTableColExt) {
            tempList.add(newPosition, (EFCTableColExt)((Object)movedColumn));
        } else {
            tempList.add(newPosition, new EFCTableColExt((TableColumnExt)movedColumn));
        }
        this.columns.clear();
        this.columns.addAll(tempList);
    }

    public List<EFCTableColExt> getActColumns() {
        return new ArrayList<EFCTableColExt>(this.columns);
    }

    public void clearActColumns() {
        this.columns.clear();
    }
}

