/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.model.table;

import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.meta.MetaInfo;
import de.effectivecompany.base.util.ObjectUtil2;
import de.effectivecompany.base.util.StringUtil;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.interfaces.model.EFCListModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public class ListTableModel
extends AbstractTableModel
implements EFCListModel {
    private static final long serialVersionUID = 3851523873668919056L;
    private List<MetaInfo> data;
    private EFCList<String> colNames = new EFCList();
    private Map<String, Integer> columnWidths = new HashMap<String, Integer>();

    @Override
    public void loadData(List<MetaInfo> data) {
        this.data = data;
        this.fireTableDataChanged();
    }

    public void setColNames(EFCList<String> list) {
        this.colNames = list;
    }

    @Override
    public void clearColumnNames() {
        this.colNames.clear();
    }

    public void addCol(String col) {
        this.colNames.add((Object)col);
    }

    @Override
    public int getColumnCount() {
        return this.colNames.size();
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.data == null) {
            return null;
        }
        if (rowIndex >= this.data.size() || columnIndex >= this.colNames.size()) {
            return null;
        }
        MetaInfo dataobject = this.data.get(rowIndex);
        try {
            Object result = ObjectUtil2.getAttributeByDomainName((String)((String)this.colNames.get(columnIndex)), (Object)dataobject);
            return result;
        }
        catch (Exception ex) {
            EFCDesktop.reportError(ex);
            return null;
        }
    }

    @Override
    public String getColumnName(int column) {
        if (column < this.colNames.size()) {
            Object key = (String)this.colNames.get(column);
            key = "FLD_" + StringUtil.finalPart((String)key, (String)".");
            return Translator.tr((String)((String)key).toUpperCase());
        }
        return super.getColumnName(column);
    }

    public String getColumnDescription(int column) {
        if (column < this.colNames.size()) {
            Object key = (String)this.colNames.get(column);
            key = "FLD_" + StringUtil.finalPart((String)key, (String)".") + "_DESC";
            return Translator.tr((String)((String)key).toUpperCase());
        }
        return super.getColumnName(column);
    }

    @Override
    public String getColumnId(int column) {
        String key = null;
        if (column < this.colNames.size() && (key = (String)this.colNames.get(column)).contains(".")) {
            key = key.substring(key.lastIndexOf(".") + 1);
        }
        return key;
    }

    @Override
    public BusinessObject getObjectAtRow(int row) {
        if (row < 0) {
            throw new IndexOutOfBoundsException("row index needs to be >=0");
        }
        if (row >= this.data.size()) {
            return null;
        }
        return (BusinessObject)this.data.get(row);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Object object = this.getValueAt(0, columnIndex);
        if (object != null) {
            return object.getClass();
        }
        return super.getColumnClass(columnIndex);
    }

    public int getColIndex(String col) {
        return this.colNames.indexOf((Object)col);
    }

    public List<String> getCols() {
        return this.colNames;
    }

    @Override
    public void setColumnWidth(String ident, Integer width) {
        this.columnWidths.put(ident, width);
    }

    @Override
    public Integer getColumnWidth(String ident) {
        return this.columnWidths.get(ident);
    }
}

