/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.model.table;

import de.effectivecompany.app.scb.BoScbBas;
import de.effectivecompany.app.scbcl.ClScbScbKey;
import de.effectivecompany.app.scbcl.ClScbScbKeyDet;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.base.util.ObjectUtil2;
import de.effectivecompany.gui.interfaces.model.EFCScbTableModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScbTableModel
extends AbstractTableModel
implements EFCScbTableModel {
    private static Logger logger = LoggerFactory.getLogger(ScbTableModel.class);
    public static final long serialVersionUID = -5262345L;
    private List<BoScbBas> myData = new EFCList();
    private List<String> columns;
    private Map<String, String> columnLabels;
    private Map<String, Integer> columnWidths = new HashMap<String, Integer>();
    private boolean editable = true;
    private boolean locked = false;
    private ClScbScbKey scbkey = this.scbkey;

    public ScbTableModel() {
        this((List<BoScbBas>)new EFCList());
    }

    public ScbTableModel(List<BoScbBas> data) {
        this.columns = new ArrayList<String>(15);
        this.columnLabels = new HashMap<String, String>();
        this.loadData(data);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    public void addColLabel(String col, String label) {
        if (this.isLocked()) {
            throw new IllegalStateException("model is locked");
        }
        this.columnLabels.put(col, label);
    }

    public void addCol(String col) {
        if (this.isLocked()) {
            throw new IllegalStateException("model is locked");
        }
        if (!this.columns.contains(col)) {
            this.columns.add(col);
        }
    }

    @Override
    public int getColIndex(String col) {
        return this.columns.indexOf(col);
    }

    public void addAllCols(String[] addCols) {
        if (this.isLocked()) {
            throw new IllegalStateException("model is locked");
        }
        this.addAllCols(Arrays.asList(addCols));
    }

    public void addAllCols(List<String> addCols) {
        if (this.isLocked()) {
            throw new IllegalStateException("model is locked");
        }
        this.columns.addAll(addCols);
    }

    @Override
    public void setCols(String[] cols) {
        if (this.isLocked()) {
            throw new IllegalStateException("model is locked");
        }
        this.columns.clear();
        this.columns.addAll(Arrays.asList(cols));
        this.columnLabels.clear();
    }

    public void setCols(List<String> cols) {
        if (this.isLocked()) {
            throw new IllegalStateException("model is locked");
        }
        this.columns.clear();
        this.columns.addAll(cols);
        this.columnLabels.clear();
    }

    public List<String> getCols() {
        return this.columns;
    }

    @Override
    public String getColumnName(int column) {
        String key = this.columns.get(column);
        ClScbScbKeyDet clScbScbKeyDet = this.scbkey.getScbscbkeydetList().stream().filter(scbkeydet -> key.equals(scbkeydet.getScbchr().getScbchr().getData())).findFirst().orElse(null);
        if (clScbScbKeyDet != null) {
            return clScbScbKeyDet.getScbchr().getStext().getData();
        }
        return key;
    }

    public String getColumnDescription(int column) {
        String key = this.columns.get(column);
        if (this.columnLabels.containsKey(key)) {
            key = this.columnLabels.get(key);
        }
        return key;
    }

    @Override
    public String getColumnId(int column) {
        String key = this.columns.get(column);
        if (key.contains(".")) {
            key = key.substring(key.lastIndexOf(".") + 1);
        }
        return key;
    }

    @Override
    public int getRowCount() {
        if (this.myData != null && !this.myData.isEmpty()) {
            return this.myData.size() / this.scbkey.getScbscbkeydetList().size();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        BusinessObject data = null;
        if (this.myData == null) {
            return null;
        }
        if (columnIndex < 0) {
            throw new IndexOutOfBoundsException("column index needs to be >=0");
        }
        if (columnIndex >= this.columns.size()) {
            return null;
        }
        String colName = this.columns.get(columnIndex);
        ClScbScbKeyDet clScbScbKeyDet = this.scbkey.getScbscbkeydetList().stream().filter(scbkeydet -> colName.equals(scbkeydet.getScbchr().getScbchr().getData())).findFirst().orElse(null);
        int i = this.scbkey.getScbscbkeydetList().indexOf((Object)clScbScbKeyDet);
        data = this.getObjectAtRow(rowIndex += i * (this.myData.size() / this.scbkey.getScbscbkeydetList().size()));
        if (data == null) {
            return null;
        }
        if (colName != null) {
            try {
                return ObjectUtil2.getAttributeByDomainName((String)"view_scbvalue", (Object)data);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (!this.isEditable() || this.isLocked()) {
            return;
        }
        BusinessObject data = null;
        if (this.myData == null) {
            return;
        }
        if (columnIndex < 0) {
            throw new IndexOutOfBoundsException("column index needs to be >=0");
        }
        if (columnIndex >= this.columns.size()) {
            return;
        }
        String colName = this.columns.get(columnIndex);
        data = this.getObjectAtRow(rowIndex);
        if (data == null) {
            return;
        }
        logger.info("BOListTableModel.setValueAt()");
        if (colName != null) {
            try {
                ObjectUtil2.setAttrByDomainViaSetter((String)colName, (Object)data, (Object)value);
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Object object = this.getValueAt(0, columnIndex);
        if (object != null) {
            return object.getClass();
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public void loadData(List<BoScbBas> data) {
        if (data != null) {
            this.initMyData(data);
            return;
        }
        this.myData = new ArrayList<BoScbBas>();
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
        logger.debug("fireTableDataChanged in BOTableModel loadData(List<BusinessObject> data)");
    }

    private void initMyData(List<BoScbBas> data) {
        this.myData = data;
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
        logger.debug("fireTableDataChanged in BOTableModel initMyData(List<BusinessObject> data)");
    }

    @Override
    public BusinessObject getObjectAtRow(int row) {
        if (row < 0) {
            throw new IndexOutOfBoundsException("row index needs to be >=0");
        }
        if (row >= this.myData.size()) {
            return null;
        }
        return (BusinessObject)this.myData.get(row);
    }

    public int getObjectCount() {
        if (this.myData != null) {
            return this.myData.size();
        }
        return 0;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.isEditable() && !this.isLocked();
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public BusinessObject getMyDataFirstBO() {
        return (BusinessObject)this.myData.get(0);
    }

    public Map<String, String> getColumnLabels() {
        return this.columnLabels;
    }

    @Override
    public void setColumnWidth(String ident, Integer width) {
        this.columnWidths.put(ident, width);
    }

    @Override
    public Integer getColumnWidth(String ident) {
        return this.columnWidths.get(ident);
    }

    public void setScbkey(ClScbScbKey scbkey) {
        this.scbkey = scbkey;
    }
}

