/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.model.table;

import de.effectivecompany.base.datatypes.EFCOption;
import de.effectivecompany.base.gui.data.SearchResult;
import de.effectivecompany.base.gui.data.SearchResultList;
import de.effectivecompany.base.gui.data.SearchService;
import de.effectivecompany.base.gui.filter.Filter;
import de.effectivecompany.base.gui.filter.FilterCriteria;
import de.effectivecompany.base.gui.key.Key;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.root.EFCDesktop;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchServiceTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 11345162384555L;
    private static Logger logger = LoggerFactory.getLogger(SearchServiceTableModel.class);
    private String[] columns;
    private SearchResultList data;
    private SearchService searchSvc;
    private String searchList;
    private Filter searchFilter;
    private SearchService.SearchMetaInfo searchMetaInfo;
    private String[] orderFields;

    public SearchServiceTableModel(SearchService svc, String searchlist, String[] orderFields) {
        this.setSearchService(svc);
        this.searchList = searchlist;
        this.orderFields = orderFields;
        for (SearchService.SearchMetaInfo searchMetaInfo : this.searchSvc.getSearchListMetaInfos()) {
            if (!searchMetaInfo.getId().equals(this.searchList)) continue;
            this.searchMetaInfo = searchMetaInfo;
            ArrayList<String> columnStrings = new ArrayList<String>();
            for (SearchService.SearchColumnInfo columnInfo : searchMetaInfo.getFields()) {
                columnStrings.add(columnInfo.getName());
            }
            this.setColumns(columnStrings);
            this.fireTableStructureChanged();
            break;
        }
    }

    @Override
    public String getColumnName(int column) {
        if (column > this.columns.length) {
            return null;
        }
        String key = "FLD_" + this.columns[column].toUpperCase();
        return Translator.tr((String)key);
    }

    public String getColumnIdentifier(int column) {
        if (column > this.columns.length) {
            return null;
        }
        return this.columns[column];
    }

    public String[] getColumns() {
        return this.columns == null ? new String[]{} : this.columns;
    }

    public void setColumns(String[] columns) {
        this.columns = Arrays.copyOf(columns, columns.length);
    }

    public void setColumns(List<String> columns) {
        this.columns = columns.toArray(new String[0]);
    }

    @Override
    public int getColumnCount() {
        return this.columns == null ? 0 : this.columns.length;
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.data == null || this.data.isEmpty()) {
            return null;
        }
        Object result = null;
        Map object = ((SearchResult)this.data.get(row)).getData();
        if (object != null && object instanceof HashMap) {
            HashMap dataMap = (HashMap)object;
            String methname = this.columns[column];
            if (methname != null) {
                Object val = dataMap.get(methname.toUpperCase());
                if (val != null) {
                    result = val;
                } else {
                    Key key = ((SearchResult)this.data.get(row)).getKey();
                    if (key != null && (val = key.get((Object)methname.toUpperCase())) != null) {
                        result = val;
                    }
                }
            }
        }
        Class dataClass = ((SearchService.SearchColumnInfo)this.searchMetaInfo.getFields().get(column)).getClazz();
        if (result instanceof String) {
            try {
                Constructor constructor = dataClass.getConstructor(String.class);
                String sv = result;
                if (!sv.equals("")) {
                    result = constructor.newInstance(sv);
                }
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
            }
            catch (NoSuchMethodException ex) {
                logger.debug("no string constructor for " + dataClass);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                logger.debug("constructor invisible for " + dataClass);
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
        }
        if (result instanceof EFCOption) {
            EFCOption option = result;
            try {
                option.putOptionClass(ClassUtils.getClass((String)((SearchService.SearchColumnInfo)this.searchMetaInfo.getFields().get(column)).getOptionClass()));
            }
            catch (ClassNotFoundException ex) {
                EFCDesktop.reportError(ex);
            }
        }
        return result;
    }

    public Key getKeyAt(int row) {
        return row >= 0 && this.data.size() > row ? ((SearchResult)this.data.get(row)).getKey() : null;
    }

    public SearchResult getObjectAt(int row) {
        return row >= 0 ? (SearchResult)this.data.get(row) : null;
    }

    public int indexOf(Object o) {
        if (o == null) {
            return -1;
        }
        return this.data.indexOf(o);
    }

    public int findColumnByField(String fieldName) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].equals(fieldName)) continue;
            return i;
        }
        return -1;
    }

    public int firstIndexOfValue(String column, Object value) {
        int columnid = this.findColumnByField(column);
        if (columnid < 0) {
            throw new IllegalArgumentException("column " + column + " not found in table, available: " + Arrays.toString(this.columns));
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object rowValue = this.getValueAt(i, columnid);
            if (value == rowValue) {
                return i;
            }
            if (value == null || rowValue == null || !value.equals(rowValue)) continue;
            return i;
        }
        return -1;
    }

    public void setSearchService(SearchService svc) {
        this.searchSvc = svc;
    }

    public SearchService getSearchService() {
        return this.searchSvc;
    }

    public void loadData(String fieldName, String value, Filter baseFilter) {
        if (this.searchSvc == null) {
            throw new NullPointerException("search service is null");
        }
        if (fieldName.contains(".")) {
            fieldName = fieldName.substring(fieldName.lastIndexOf(".") + 1, fieldName.length());
        }
        baseFilter.addCriteria(new FilterCriteria(fieldName.toUpperCase(), 9, (Object)value));
        this.searchFilter = baseFilter;
        boolean bFound = false;
        for (String listId : this.searchSvc.getSearchListIds()) {
            if (!listId.equals(this.searchList)) continue;
            bFound = true;
            break;
        }
        if (!bFound) {
            logger.error("Searchlist " + this.searchList + "not found in SearchService " + this.searchSvc.getId());
            return;
        }
        this.data = this.orderFields.length > 0 ? this.searchSvc.search(this.orderFields, this.searchList, baseFilter) : this.searchSvc.search(this.searchList, baseFilter);
        this.fireTableDataChanged();
        logger.debug("fireTableDataChanged in SearchServiceTableModel loadData(String fieldName, String value)");
    }

    public Filter getSearchFilter() {
        return this.searchFilter;
    }

    public void clearData() {
        if (this.data != null) {
            this.data.clear();
            this.fireTableDataChanged();
        }
    }

    public Key getKeyOfRow(int row) {
        if (this.data != null && this.data.size() >= row && row >= 0) {
            return ((SearchResult)this.data.get(row)).getKey();
        }
        return null;
    }
}

