/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.panel;

import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.gui.components.EFCController;
import de.effectivecompany.gui.components.model.table.BOTableModel;
import de.effectivecompany.gui.components.model.table.EFCColumnModel;
import de.effectivecompany.gui.components.model.table.EFCTableColExt;
import de.effectivecompany.gui.components.model.table.EFCTableColumnLayoutInfo;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.components.swing.EFCTable;
import de.effectivecompany.gui.components.table.EFCColumnResizer;
import de.effectivecompany.gui.components.table.EFCNumberTable;
import de.effectivecompany.gui.data.BusinessObjectModel;
import de.effectivecompany.gui.events.SelectionContextChangeEvent;
import de.effectivecompany.gui.interfaces.listeners.DataChangeListener;
import de.effectivecompany.gui.interfaces.listeners.DoubleClickListener;
import de.effectivecompany.gui.interfaces.manager.DataChangeManager;
import de.effectivecompany.gui.interfaces.manager.ElementManager;
import de.effectivecompany.gui.interfaces.model.EFCTableModel;
import de.effectivecompany.gui.interfaces.panel.TablePanel;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.RowSorter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCBOTablePanel
extends EFCPanel
implements TablePanel {
    private static Logger logger = LoggerFactory.getLogger(EFCBOTablePanel.class);
    public static final long serialVersionUID = -733455L;
    private EFCTable jxTable;
    private EFCTableModel model;
    private BusinessObjectModel boModel;
    private boolean emptySelectionAllowed;
    private boolean unselected = true;
    private EFCColumnModel columnModel;
    private String layoutFileName;
    private List<EFCTableColExt> tableColumns = new ArrayList<EFCTableColExt>();
    private JScrollPane tablePane;
    private List<? extends RowSorter.SortKey> sortKeys;
    private EFCNumberTable rowTable;
    private TableComparator tableComparator;
    private Double sizeColumnMulti;
    private Runnable enterAction;

    public EFCBOTablePanel(ElementManager elementManager, DataChangeManager dataChangeManager, final String ident, final String parentIdent, boolean border, BusinessObjectModel boModel, final EFCController controller, EFCMap<String, Font> columnFonts) {
        super(elementManager, dataChangeManager, ident, parentIdent, border);
        this.boModel = boModel;
        MyListSelectionHandler mySelectionHandler = new MyListSelectionHandler();
        MyDataChangeHandler myDataChangeHandler = new MyDataChangeHandler();
        EFCPanel.MyFocusHandler myFocusHandler = new EFCPanel.MyFocusHandler(){

            @Override
            public void focusGained(FocusEvent event) {
                super.focusGained(event);
                EFCBOTablePanel.this.setBorder(EFCLookAndFeelManager.TABLE_BORRDER_OUTSIDE);
                int columnIndex = EFCBOTablePanel.this.getSelectedColumn();
                String column = "";
                if (columnIndex >= 0) {
                    column = ((BOTableModel)EFCBOTablePanel.this.getTableModel()).getColumnId(columnIndex);
                }
                controller.onParamContextChanged(parentIdent, ident, column, EFCBOTablePanel.this.getSelectedObject(), null);
            }

            @Override
            public void focusLost(FocusEvent event) {
                super.focusLost(event);
                EFCBOTablePanel.this.setBorder(EFCLookAndFeelManager.TABLE_BORRDER_EMPTYBORDER);
            }
        };
        boModel.addDataSetListener(myDataChangeHandler);
        this.model = new BOTableModel();
        this.jxTable = new EFCTable((TableModel)((Object)this.model), controller, columnFonts){

            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                super.changeSelection(rowIndex, columnIndex, EFCBOTablePanel.this.isEmptySelectionAllowed(), false);
                if (controller != null) {
                    controller.setActiveTableSelectionFocusIdent(EFCBOTablePanel.this.getIdent());
                }
            }
        };
        this.jxTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    evt.consume();
                    if (EFCBOTablePanel.this.enterAction != null) {
                        EFCBOTablePanel.this.enterAction.run();
                    }
                }
                if (evt.getKeyCode() == 9) {
                    evt.consume();
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                }
            }
        });
        this.jxTable.setTableIdent(ident);
        this.jxTable.addFocusListener(myFocusHandler);
        this.jxTable.getSelectionModel().addListSelectionListener(mySelectionHandler);
        this.columnModel = new EFCColumnModel((BOTableModel)this.model);
        this.jxTable.setColumnModel((TableColumnModel)((Object)this.columnModel));
        this.tablePane = new JScrollPane((Component)((Object)this.jxTable));
        this.add((Component)this.tablePane, "Center");
        this.jxTable.setAutoResizeMode(0);
        this.rowTable = new EFCNumberTable((JTable)((Object)this.jxTable), null);
        this.tableComparator = new TableComparator();
    }

    public void addDoubleClickListener(DoubleClickListener listener) {
        this.jxTable.addMouseListener(listener);
    }

    @Override
    public void addKeyListener(KeyListener l) {
        this.jxTable.addKeyListener(l);
    }

    @Override
    public KeyListener[] getKeyListeners() {
        return this.jxTable.getKeyListeners();
    }

    @Override
    public void removeKeyListener(KeyListener l) {
        this.jxTable.removeKeyListener(l);
    }

    public void setDataForListAdd(List<BusinessObject> data) {
        ElementManager elementManager = this.getElementManager();
        this.jxTable.setVisible(true);
        this.unselected = true;
        if (elementManager != null) {
            String prefix = this.getIdent() + ".";
            elementManager.resetAllFields(prefix);
        }
        this.model.loadData(data);
        this.reloadColumnModel();
        EFCColumnResizer.adjustColumnPreferredWidthsByType((JTable)((Object)this.jxTable), this.sizeColumnMulti, this.tableColumns);
        this.rowTable.updateTable();
        this.tablePane.setRowHeaderView((Component)((Object)this.rowTable));
        this.tablePane.setCorner("UPPER_LEFT_CORNER", this.rowTable.getTableHeader());
        Color buttonColor = ((JButton)this.jxTable.getColumnControl()).getForeground();
        ((JButton)this.jxTable.getColumnControl()).setForeground(buttonColor);
        this.setSelectedIndex(this.getObjectCount() - 1);
        this.scrollToVisible(this.jxTable, this.jxTable.getSelectedRow(), this.jxTable.getSelectedColumn());
    }

    public void setData(List<BusinessObject> data) {
        this.sortKeys = this.jxTable.getRowSorter().getSortKeys();
        this.jxTable.setAutoCreateRowSorter(false);
        ElementManager elementManager = this.getElementManager();
        if (data != null && data.isEmpty()) {
            this.jxTable.clearSelection();
        }
        this.jxTable.setVisible(true);
        int row = this.getSelectedIndex();
        this.unselected = true;
        if (elementManager != null) {
            String prefix = this.getIdent() + ".";
            elementManager.resetAllFields(prefix);
        }
        this.model.loadData(data);
        this.reloadColumnModel();
        EFCColumnResizer.adjustColumnPreferredWidthsByType((JTable)((Object)this.jxTable), this.sizeColumnMulti, this.tableColumns);
        this.rowTable.updateTable();
        this.tablePane.setRowHeaderView((Component)((Object)this.rowTable));
        this.tablePane.setCorner("UPPER_LEFT_CORNER", this.rowTable.getTableHeader());
        this.jxTable.setAutoCreateRowSorter(true);
        this.jxTable.getRowSorter().setSortKeys(this.sortKeys);
        this.jxTable.getRowSorter().allRowsChanged();
        if (data != null) {
            this.jxTable.newFilter();
        }
        if (row > this.model.getRowCount() - 1) {
            this.setSelectedIndex(0);
        } else if (row == -1) {
            if (this.emptySelectionAllowed) {
                this.setSelectedIndex(-1);
            } else {
                this.setSelectedIndex(0);
            }
        } else {
            this.setSelectedIndex(row);
        }
        this.scrollToVisible(this.jxTable, this.jxTable.getSelectedRow(), this.jxTable.getSelectedColumn());
    }

    public void refreshTable() {
        EFCThreadUtil.doLater(() -> this.jxTable.repaint());
    }

    public void scrollToVisible(JXTable table, int rowIndex, int vColIndex) {
        if (!(table.getParent() instanceof JViewport) || rowIndex == -1) {
            return;
        }
        JViewport viewport = (JViewport)table.getParent();
        Rectangle rect = table.getCellRect(rowIndex, vColIndex, true);
        Point pt = viewport.getViewPosition();
        rect.setLocation(pt.x, rect.y - pt.y);
        viewport.scrollRectToVisible(rect);
    }

    public void clearVisibleCols() {
        this.model.setCols(new String[0]);
    }

    public void addColLabel(String colname, String label) {
        if (colname != null) {
            ((BOTableModel)this.model).addColLabel(colname, label);
        }
    }

    public void addVisibleCol(String colname) {
        if (colname != null) {
            ((BOTableModel)this.model).addCol(colname);
        }
    }

    public void addColsToColumsModel(String[] colname) {
        if (colname != null) {
            this.columnModel.clearActColumns();
            for (int i = 0; i < colname.length; ++i) {
                EFCTableColExt columnExt = new EFCTableColExt(((BOTableModel)this.model).getColIndex(colname[i]));
                columnExt.setIdentifier(colname[i]);
                if (((BOTableModel)this.model).getColIndex(colname[i]) != -1) {
                    columnExt.setHeaderValue(((BOTableModel)this.model).getColumnName(((BOTableModel)this.model).getColIndex(colname[i])));
                }
                this.columnModel.addColumn((TableColumn)((Object)columnExt));
            }
        }
    }

    public void addVisibleCol(String[] colnames) {
        if (colnames != null) {
            ((BOTableModel)this.model).addAllCols(colnames);
        }
        if (this.model != null) {
            this.model.fireTableStructureChanged();
            logger.debug("fireTableStructureChanged in EFCBOTablePanel addVisibleCol");
        }
    }

    public String[] getAvaibleCols() {
        String[] columns = new String[((TableModel)((Object)this.model)).getColumnCount()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = this.model.getColumnId(i);
        }
        return columns;
    }

    public String[] getVisibleCols() {
        return ((BOTableModel)this.model).getCols().toArray(new String[0]);
    }

    @Override
    public int getSelectedIndex() {
        int selectedRow = this.jxTable.getSelectedRow();
        if (selectedRow >= 0) {
            try {
                return this.jxTable.convertRowIndexToModel(selectedRow);
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
                return -1;
            }
        }
        return -1;
    }

    public BusinessObject getSelectedObject() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex >= 0) {
            return this.model.getObjectAtRow(selectedIndex);
        }
        return null;
    }

    @Override
    public int getSelectedColumn() {
        int selectedColumn = this.jxTable.getSelectedColumn();
        if (selectedColumn >= 0) {
            return this.jxTable.convertColumnIndexToModel(selectedColumn);
        }
        return -1;
    }

    public boolean setSelectedColumn(int colNum) {
        int currentIndex;
        int n = currentIndex = this.unselected ? -1 : this.getSelectedColumn();
        if (colNum == currentIndex) {
            return true;
        }
        if (colNum < 0 || colNum >= ((TableModel)((Object)this.model)).getColumnCount()) {
            return false;
        }
        int viewIndex = this.jxTable.convertColumnIndexToView(colNum);
        this.jxTable.setColumnSelectionInterval(viewIndex, viewIndex);
        return true;
    }

    @Override
    public TableModel getTableModel() {
        return this.jxTable.getModel();
    }

    public int getObjectCount() {
        return ((BOTableModel)this.model).getObjectCount();
    }

    public boolean setSelectedIndex(int index) {
        int currentIndex;
        if (index == -1) {
            this.jxTable.clearSelection();
            this.boModel.setSelectedListItemIndex(this.getIdent(), index);
            return true;
        }
        int n = currentIndex = this.unselected ? -1 : this.getSelectedIndex();
        if (index == currentIndex) {
            return true;
        }
        if (index >= 0 && index < this.model.getRowCount()) {
            try {
                int viewIndex = this.jxTable.convertRowIndexToView(index);
                this.jxTable.setRowSelectionInterval(viewIndex, viewIndex);
                this.boModel.setSelectedListItemIndex(this.getIdent(), index);
            }
            catch (Throwable throwable) {}
        } else {
            return false;
        }
        return true;
    }

    public boolean setSelectedObject(BusinessObject object) {
        if (object == null) {
            return false;
        }
        for (int i = 0; i < ((BOTableModel)this.model).getObjectCount(); ++i) {
            if (this.model.getObjectAtRow(i) != object) continue;
            this.setSelectedIndex(i);
            return true;
        }
        return false;
    }

    public BusinessObject getObject(int num) {
        return this.model.getObjectAtRow(num);
    }

    public void setEditable(boolean b) {
        this.jxTable.setEditable(b);
    }

    public boolean isEditable() {
        return this.jxTable.isEditable();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(true);
    }

    @Override
    public void setColumnModelXML(String xml) {
        XMLDecoder xmlDecoder = new XMLDecoder(new ByteArrayInputStream(xml.getBytes()));
        List tableColumnLayoutInfos = (List)xmlDecoder.readObject();
        xmlDecoder.close();
        this.tableColumns.clear();
        for (String col : ((BOTableModel)this.jxTable.getModel()).getCols()) {
            EFCTableColumnLayoutInfo infoCol = new EFCTableColumnLayoutInfo(col);
            if (tableColumnLayoutInfos.contains(infoCol)) {
                EFCTableColumnLayoutInfo tableColumnLayoutInfo = (EFCTableColumnLayoutInfo)tableColumnLayoutInfos.get(tableColumnLayoutInfos.indexOf(infoCol));
                TableColumn column = this.jxTable.getColumn(tableColumnLayoutInfo.getColumnName());
                EFCTableColExt tableColumn = column instanceof EFCTableColExt ? (EFCTableColExt)((Object)this.jxTable.getColumn(tableColumnLayoutInfo.getColumnName())) : new EFCTableColExt((TableColumnExt)this.jxTable.getColumn(tableColumnLayoutInfo.getColumnName()));
                tableColumn.setPreferredWidth(tableColumnLayoutInfo.getWidth());
                tableColumn.setDefaultSize(false);
                tableColumn.setVisible(tableColumnLayoutInfo.isVisible());
                tableColumn.setOrder(tableColumnLayoutInfo.getOrder());
                this.tableColumns.add(tableColumn);
                continue;
            }
            EFCTableColExt tableColumn = new EFCTableColExt(((BOTableModel)this.jxTable.getModel()).getCols().indexOf(col));
            tableColumn.setHeaderValue(((BOTableModel)this.jxTable.getModel()).getColumnName(((BOTableModel)this.jxTable.getModel()).getCols().indexOf(col)));
            tableColumn.setIdentifier(infoCol.getColumnName());
            tableColumn.setVisible(true);
            this.tableColumns.add(tableColumn);
            tableColumn.setOrder(this.tableColumns.size() - 1);
        }
        Collections.sort(this.tableColumns, this.tableComparator);
        this.reloadColumnModel();
    }

    @Override
    public String getColumnModelXML() {
        EFCColumnModel tableColumnModel = (EFCColumnModel)((Object)this.jxTable.getColumnModel());
        ArrayList<EFCTableColumnLayoutInfo> tableColumnLayoutInfos = new ArrayList<EFCTableColumnLayoutInfo>();
        String xmlString = null;
        List<EFCTableColExt> tableColumns = tableColumnModel.getActColumns();
        for (int currentColumnIndex = 0; currentColumnIndex < tableColumns.size(); ++currentColumnIndex) {
            TableColumnExt tableColumn = tableColumns.get(currentColumnIndex);
            TableColumnExt col = tableColumnModel.getColumnExt(tableColumn.getIdentifier());
            EFCTableColumnLayoutInfo tableColumnLayoutInfo = new EFCTableColumnLayoutInfo(tableColumn.getIdentifier().toString(), currentColumnIndex, col.getWidth(), tableColumn.isVisible());
            tableColumnLayoutInfos.add(tableColumnLayoutInfo);
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        XMLEncoder xmlEncoder = new XMLEncoder(output);
        xmlEncoder.writeObject(tableColumnLayoutInfos);
        xmlEncoder.close();
        xmlString = output.toString();
        return xmlString;
    }

    @Override
    public void reloadColumnModel() {
        try {
            if (this.tableColumns.size() > 0) {
                EFCColumnModel tableColumnModel = new EFCColumnModel((TableModel)((Object)this.model));
                for (int i = 0; i < this.tableColumns.size(); ++i) {
                    tableColumnModel.addColumn((TableColumn)((Object)this.tableColumns.get(i)));
                }
                this.jxTable.setColumnModel((TableColumnModel)((Object)tableColumnModel));
            } else {
                EFCColumnModel tableColumnModel = new EFCColumnModel((TableModel)((Object)this.model));
                for (int i = 0; i < this.jxTable.getColumnCount(true); ++i) {
                    try {
                        EFCTableColExt tableColumn = new EFCTableColExt(this.jxTable.getColumnExt(i));
                        tableColumnModel.addColumn((TableColumn)((Object)tableColumn));
                        this.tableColumns.add(tableColumn);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.jxTable.setColumnModel((TableColumnModel)((Object)tableColumnModel));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public JXTable getTable() {
        return this.jxTable;
    }

    public BusinessObject getDoubleClickedRowBusObj(Point point) {
        int clickedRow = this.jxTable.rowAtPoint(point);
        if (clickedRow >= 0) {
            return this.model.getObjectAtRow(this.jxTable.convertRowIndexToModel(clickedRow));
        }
        return null;
    }

    public List<BusinessObject> getSortedBusObjList() {
        ArrayList<BusinessObject> busObjList = new ArrayList<BusinessObject>();
        for (int i = 0; i < this.jxTable.getRowSorter().getViewRowCount(); ++i) {
            busObjList.add(this.model.getObjectAtRow(this.jxTable.convertRowIndexToModel(i)));
        }
        return busObjList;
    }

    @Override
    public void terminate() {
        if (this.jxTable != null) {
            for (FocusListener focusListener : this.jxTable.getFocusListeners()) {
                this.jxTable.removeFocusListener(focusListener);
            }
            for (EventListener eventListener : this.jxTable.getMouseListeners()) {
                this.jxTable.removeMouseListener((MouseListener)eventListener);
            }
            for (EventListener eventListener : this.jxTable.getKeyListeners()) {
                this.jxTable.removeKeyListener((KeyListener)eventListener);
            }
            for (EventListener eventListener : ((DefaultListSelectionModel)this.jxTable.getSelectionModel()).getListSelectionListeners()) {
                this.jxTable.getSelectionModel().removeListSelectionListener((ListSelectionListener)eventListener);
            }
            for (DataChangeListener dataChangeListener : this.boModel.getDataSetListener()) {
                this.boModel.removeDataSetListener(dataChangeListener);
            }
        }
        this.removeAll();
        this.jxTable.removeAll();
        this.jxTable = null;
        this.model = null;
        this.boModel = null;
        this.columnModel = null;
        if (this.sortKeys != null) {
            this.sortKeys = null;
        }
        if (this.tableColumns != null) {
            this.tableColumns.clear();
            this.tableColumns = null;
        }
        this.rowTable.terminate();
        this.rowTable = null;
        this.tableComparator = null;
        this.tablePane.removeAll();
        this.tablePane = null;
        this.sizeColumnMulti = null;
        this.enterAction = null;
        super.terminate();
    }

    @Override
    public String getLayoutFileName() {
        return this.layoutFileName;
    }

    public void setLayoutFileName(String layoutFileName) {
        this.layoutFileName = layoutFileName;
    }

    public JScrollPane getTablePane() {
        return this.tablePane;
    }

    @Override
    public void clearTableColums() {
        this.tableColumns.clear();
    }

    public void setEnterAction(Runnable run) {
        this.enterAction = run;
    }

    public BusinessObjectModel getBoModel() {
        return this.boModel;
    }

    public void setEmptySelectionAllowed(boolean emptySelectionAllowed) {
        this.emptySelectionAllowed = emptySelectionAllowed;
    }

    public boolean isEmptySelectionAllowed() {
        return this.emptySelectionAllowed;
    }

    public EFCNumberTable getRowTable() {
        return this.rowTable;
    }

    public Double getSizeColumnMulti() {
        return this.sizeColumnMulti;
    }

    public void setSizeColumnMulti(Double sizeMulti) {
        this.sizeColumnMulti = sizeMulti;
    }

    private static class TableComparator
    implements Comparator<EFCTableColExt> {
        private TableComparator() {
        }

        @Override
        public int compare(EFCTableColExt o1, EFCTableColExt o2) {
            if (o1.getOrder() < o2.getOrder()) {
                return -1;
            }
            if (o1.getOrder() > o2.getOrder()) {
                return 1;
            }
            return 0;
        }
    }

    private class MyListSelectionHandler
    implements ListSelectionListener {
        private String lastClickedElement;
        private int lastClickedRow = -1;
        private int lastClickedColumn = -1;

        private MyListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            logger.debug("MyListSelectionHandler.valueChanged() on " + EFCBOTablePanel.this.getIdent());
            int column = EFCBOTablePanel.this.jxTable.getSelectedColumn();
            int row = EFCBOTablePanel.this.jxTable.getSelectedRow();
            if (column != -1) {
                column = EFCBOTablePanel.this.jxTable.convertColumnIndexToModel(column);
            }
            if (row != -1) {
                row = EFCBOTablePanel.this.jxTable.convertRowIndexToModel(row);
            }
            String colName = null;
            if (EFCBOTablePanel.this.unselected) {
                this.lastClickedColumn = -1;
                this.lastClickedRow = -1;
            }
            EFCBOTablePanel.this.unselected = false;
            colName = column >= 0 ? EFCBOTablePanel.this.model.getColumnId(column) : null;
            if (!EFCBOTablePanel.this.isEmptySelectionAllowed() && row == -1) {
                return;
            }
            if (this.lastClickedRow == row) {
                if (colName == null && this.lastClickedElement == null) {
                    return;
                }
                if (colName == null || colName.equalsIgnoreCase(this.lastClickedElement)) {
                    return;
                }
            }
            EFCBOTablePanel.this.boModel.setSelectedListItemIndex(EFCBOTablePanel.this.getIdent(), row);
            EFCBOTablePanel src = EFCBOTablePanel.this;
            Point oldPoint = new Point(this.lastClickedColumn, this.lastClickedRow);
            Point newPoint = new Point(column, row);
            SelectionContextChangeEvent sece = new SelectionContextChangeEvent(src, 2079, EFCBOTablePanel.this.getIdent(), oldPoint, newPoint);
            sece.setSelected(EFCBOTablePanel.this.getSelectedObject());
            DataChangeManager dcm = EFCBOTablePanel.this.getDataChangeManager();
            if (dcm != null) {
                dcm.onSelectionContextChanged(sece);
            }
            this.lastClickedRow = row;
            this.lastClickedColumn = column;
            this.lastClickedElement = colName;
        }
    }

    private class MyDataChangeHandler
    implements DataChangeListener {
        private MyDataChangeHandler() {
        }

        @Override
        public void attributeChanged(String fieldIdent, Object oldValue, Object newValue) {
            if (fieldIdent.startsWith(EFCBOTablePanel.this.getIdent())) {
                logger.debug("fireTableDataChanged in EFCBOTablePanel MyDataChangeHandler");
            }
        }

        @Override
        public void businessObjectChanged() {
            EFCBOTablePanel.this.model.fireTableStructureChanged();
            logger.debug("fireTableStructureChanged in EFCBOTablePanel MyDataChangeHandler");
        }
    }
}

