/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.panel;

import de.effectivecompany.base.data.BusinessDataObject;
import de.effectivecompany.base.data.LazyLoader;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.gui.components.model.table.EFCBoModel;
import de.effectivecompany.gui.components.panel.EFCGlassPanel;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.components.swing.EFCBoCellRenderer;
import de.effectivecompany.gui.components.swing.EFCBoTableRowHeader;
import de.effectivecompany.gui.events.BusinessTableInteractionEvent;
import de.effectivecompany.gui.events.FocusChangeEvent;
import de.effectivecompany.gui.events.SelectionContextChangeEvent;
import de.effectivecompany.gui.interfaces.listeners.BusinessTableInteractionListener;
import de.effectivecompany.gui.interfaces.listeners.FocusChangeListener;
import de.effectivecompany.gui.interfaces.listeners.UserInputListener;
import de.effectivecompany.gui.interfaces.manager.DataChangeManager;
import de.effectivecompany.gui.interfaces.manager.ElementManager;
import de.effectivecompany.gui.interfaces.panel.BusinessPanel;
import de.effectivecompany.gui.interfaces.panel.TablePanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.ClassUtils;
import org.jdesktop.swingx.JXTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCBusinessDataTablePanel
extends EFCPanel
implements BusinessPanel,
TablePanel {
    private static final long serialVersionUID = 3137410791332120442L;
    private static final Logger logger = LoggerFactory.getLogger(EFCBusinessDataTablePanel.class);
    private JXTable jxTable = new JXTable(1, 1);
    private JScrollPane scroll = new JScrollPane((Component)this.jxTable);
    private EFCGlassPanel glass;
    private Vector<FocusChangeListener> focusChangeListeners = new Vector();
    private Vector<UserInputListener> userInputListeners = new Vector();
    private Vector<BusinessTableInteractionListener> businessTableInteractionListeners = new Vector();
    private BusinessDataObject dataobject;
    private boolean datamodified;
    private String sidecol;
    private String bottomcol;
    private MyListSelectionHandler selectionHandler;
    private EFCBoTableRowHeader rowTable;
    private int cellWidth;
    private int cellHeight;
    private Runnable loadDone;

    public EFCBusinessDataTablePanel(ElementManager manager, DataChangeManager dcm, String ident, String parentIdent, boolean border, String celllayout, String headerLayout, double sizeMultiplier, boolean onlyLabels, boolean dragAndDropEnabled, int cellWidth, int cellHeight, Integer rowHeaderCellWidth) {
        super(manager, dcm, ident, parentIdent, border);
        this.cellWidth = cellWidth;
        this.cellHeight = cellHeight;
        this.selectionHandler = new MyListSelectionHandler();
        this.addBusinessTableListener(dcm);
        if (dragAndDropEnabled) {
            this.jxTable.setDragEnabled(true);
            this.jxTable.setDropMode(DropMode.USE_SELECTION);
            this.jxTable.setTransferHandler((TransferHandler)new BusinessObjectTransferHandler());
            this.jxTable.setFillsViewportHeight(true);
        }
        this.jxTable.setSortable(false);
        this.jxTable.setHorizontalScrollEnabled(true);
        this.jxTable.getSelectionModel().setSelectionMode(0);
        this.jxTable.setCellSelectionEnabled(true);
        this.jxTable.getSelectionModel().addListSelectionListener(this.selectionHandler);
        this.jxTable.getColumnModel().getSelectionModel().addListSelectionListener(this.selectionHandler);
        this.jxTable.setDefaultRenderer(BusinessObject.class, (TableCellRenderer)new EFCBoCellRenderer(celllayout, sizeMultiplier, onlyLabels, cellWidth, cellHeight));
        this.rowTable = new EFCBoTableRowHeader((JTable)this.jxTable, headerLayout, sizeMultiplier, onlyLabels, rowHeaderCellWidth);
        this.scroll.setRowHeaderView((Component)((Object)this.rowTable));
        this.scroll.setCorner("UPPER_LEFT_CORNER", this.rowTable.getTableHeader());
        this.rowTable.getTableHeader().setResizingAllowed(true);
        ((DefaultTableCellRenderer)this.jxTable.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
        this.glass = new EFCGlassPanel(this.scroll);
        this.add(this.glass);
    }

    public void addUserInputListener(UserInputListener listener) {
        this.userInputListeners.add(listener);
    }

    public UserInputListener[] getUserInputListeners() {
        return this.userInputListeners.toArray(new UserInputListener[0]);
    }

    public void removeUserInputListener(UserInputListener listener) {
        this.userInputListeners.remove(listener);
    }

    @Override
    public void addFocusChangeListener(FocusChangeListener listener) {
        this.focusChangeListeners.add(listener);
    }

    @Override
    public FocusChangeListener[] getFocusChangeListeners() {
        return this.focusChangeListeners.toArray(new FocusChangeListener[0]);
    }

    @Override
    public void removeFocusChangeListener(FocusChangeListener listener) {
        this.focusChangeListeners.remove(listener);
    }

    @Override
    public void fireFocusGainedEvent() {
        FocusChangeEvent event = new FocusChangeEvent(this, 2030, this.getIdent());
        this.notifyListeners(event);
    }

    @Override
    public void fireFocusLostEvent() {
        FocusChangeEvent event = new FocusChangeEvent(this, 2029, this.getIdent());
        this.notifyListeners(event);
    }

    private void notifyListeners(FocusChangeEvent event) {
        for (FocusChangeListener listener : this.getFocusChangeListeners()) {
            listener.onFocusChanged(event);
        }
    }

    public void setData(List<BusinessObject> data) {
        ElementManager em = this.getElementManager();
        if (em != null) {
            em.resetAllFields(this.getIdent() + ".");
        }
    }

    public void updateTable(EFCBoModel model) {
        model.setSideBarType(this.sidecol);
        model.setBottomBarType(this.bottomcol);
        this.jxTable.setModel((TableModel)model);
        this.jxTable.setEnabled(true);
        this.jxTable.setRowHeight(this.cellHeight);
        for (int index = 0; index < this.jxTable.getColumnModel().getColumnCount(); ++index) {
            TableColumn column = this.jxTable.getColumnModel().getColumn(index);
            column.setPreferredWidth(this.cellWidth);
        }
        EFCBoCellRenderer renderer = (EFCBoCellRenderer)this.jxTable.getDefaultRenderer(BusinessObject.class);
        renderer.setValuesChanged(true);
        this.setLocked(false);
        this.rowTable.updateTable();
    }

    public void setLocked(boolean locked) {
        if (this.glass != null) {
            this.glass.setEnabled(!locked);
            if (locked) {
                this.setCursor(new Cursor(3));
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    @Override
    public void setDataSource(BusinessDataObject data, Runnable loader) {
        this.dataobject = data;
        this.datamodified = true;
        this.loadDone = loader;
        this.repaint();
    }

    @Override
    public void setDataSource(BusinessDataObject data) {
        this.setDataSource(data, null);
    }

    public void setSideBarType(String type) {
        this.sidecol = type;
    }

    public void setBottomBarType(String type) {
        this.bottomcol = type;
    }

    private void loadData() {
        if (this.dataobject != null) {
            this.setLocked(true);
            new LoaderRunner(this.dataobject, this.loadDone).execute();
        }
        this.datamodified = false;
    }

    @Override
    public void paint(Graphics g) {
        if (this.datamodified) {
            this.loadData();
        }
        super.paint(g);
    }

    @Override
    public int getSelectedColumn() {
        return this.jxTable.getSelectedColumn();
    }

    @Override
    public int getSelectedIndex() {
        return this.jxTable.getSelectedRow();
    }

    @Override
    public TableModel getTableModel() {
        return this.jxTable.getModel();
    }

    @Override
    public void terminate() {
        ((EFCBoCellRenderer)this.jxTable.getDefaultRenderer(BusinessObject.class)).clearPanels();
        for (FocusListener focusListener : this.jxTable.getFocusListeners()) {
            this.jxTable.removeFocusListener(focusListener);
        }
        this.focusChangeListeners.clear();
        this.focusChangeListeners = null;
        this.jxTable.getSelectionModel().removeListSelectionListener(this.selectionHandler);
        this.selectionHandler = null;
        this.businessTableInteractionListeners.clear();
        this.userInputListeners.clear();
        this.focusChangeListeners = null;
        this.removeAll();
        this.jxTable = null;
        this.dataobject = null;
        this.glass = null;
        super.terminate();
    }

    @Override
    public JXTable getTable() {
        return this.jxTable;
    }

    public void addBusinessTableListener(BusinessTableInteractionListener listener) {
        this.businessTableInteractionListeners.add(listener);
    }

    public BusinessTableInteractionListener[] getBusinessTableListeners() {
        return this.businessTableInteractionListeners.toArray(new BusinessTableInteractionListener[0]);
    }

    public void removeBusinessTableInteractionListener(BusinessTableInteractionListener l) {
        this.businessTableInteractionListeners.remove(l);
    }

    @Override
    public void setColumnModelXML(String code) {
    }

    @Override
    public String getLayoutFileName() {
        return null;
    }

    @Override
    public void clearTableColums() {
    }

    @Override
    public void reloadColumnModel() {
    }

    @Override
    public String getColumnModelXML() {
        return null;
    }

    public EFCBoTableRowHeader getRowTable() {
        return this.rowTable;
    }

    public class BusinessObjectTransfer
    implements Transferable {
        private DataFlavor[] dataFlavors = new DataFlavor[]{DataFlavor.stringFlavor};
        private ArrayList<Object> testObjectList = null;

        public BusinessObjectTransfer(ArrayList<Object> testObjectList) {
            this.testObjectList = testObjectList;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return this.testObjectList;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            for (DataFlavor dataFlavor : this.dataFlavors) {
                if (!dataFlavor.equals(flavor)) continue;
                return true;
            }
            return false;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.dataFlavors;
        }
    }

    class BusinessObjectTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 3302272904915806525L;
        private boolean isError = false;
        private Integer startColumn;
        private Integer row;
        private ArrayList<BusinessObject> copyList = new ArrayList();

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        protected Transferable createTransferable(JComponent source) {
            int[] selectedRows;
            ArrayList<Object> toList = new ArrayList<Object>();
            for (int row : selectedRows = EFCBusinessDataTablePanel.this.jxTable.getSelectedRows()) {
                int[] selectedColumns;
                for (int column : selectedColumns = EFCBusinessDataTablePanel.this.jxTable.getSelectedColumns()) {
                    Object selectedObject = EFCBusinessDataTablePanel.this.jxTable.getValueAt(row, column);
                    if (!(selectedObject instanceof Object)) continue;
                    toList.add(selectedObject);
                }
            }
            this.isError = false;
            this.copyList.clear();
            return new BusinessObjectTransfer(toList);
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            Object newValue = null;
            if (!this.isError) {
                try {
                    int selectedColumn = EFCBusinessDataTablePanel.this.jxTable.getSelectedColumn();
                    int selectedRow = EFCBusinessDataTablePanel.this.jxTable.getSelectedRow();
                    List list = (List)data.getTransferData(DataFlavor.stringFlavor);
                    for (Object val : list) {
                        newValue = ClassUtils.getClass((String)val.getClass().getName()).newInstance();
                        ((JTable)source).getModel().setValueAt(newValue, selectedRow, selectedColumn);
                        ++selectedColumn;
                    }
                }
                catch (UnsupportedFlavorException | IOException | ClassNotFoundException e) {
                    logger.error(e.getMessage());
                }
                catch (InstantiationException e) {
                    logger.error(e.getMessage());
                }
                catch (IllegalAccessException e) {
                    logger.error(e.getMessage());
                }
                EFCBoCellRenderer renderer = (EFCBoCellRenderer)EFCBusinessDataTablePanel.this.jxTable.getDefaultRenderer(BusinessObject.class);
                renderer.setValuesChanged(true);
                BusinessTableInteractionEvent sece = new BusinessTableInteractionEvent(EFCBusinessDataTablePanel.this, 2045, EFCBusinessDataTablePanel.this.getIdent(), this.row, this.startColumn, this.copyList);
                for (BusinessTableInteractionListener listener : EFCBusinessDataTablePanel.this.businessTableInteractionListeners) {
                    listener.onBusinessTableInteraction(sece);
                }
                EFCBusinessDataTablePanel.this.jxTable.clearSelection();
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            JTable jt = (JTable)support.getComponent();
            try {
                boolean isOutOfHorizont = false;
                int column = jt.getSelectedColumn();
                int row = jt.getSelectedRow();
                this.startColumn = column;
                this.row = row;
                ArrayList<BusinessObject> tmpList = new ArrayList<BusinessObject>();
                for (int index = column; index < jt.getColumnCount(); ++index) {
                    tmpList.add((BusinessObject)jt.getValueAt(row, index));
                }
                ArrayList list = (ArrayList)support.getTransferable().getTransferData(DataFlavor.stringFlavor);
                this.copyList.addAll(list);
                for (Object val : list) {
                    jt.getModel().setValueAt(val, row, column);
                    ++column;
                }
                if (!isOutOfHorizont) {
                    for (int index = 0; index < tmpList.size(); ++index) {
                        jt.getModel().setValueAt(tmpList.get(index), row, column);
                        ++column;
                    }
                }
                if (isOutOfHorizont) {
                    column = jt.getSelectedColumn();
                    this.isError = true;
                    for (int index = 0; index < tmpList.size(); ++index) {
                        jt.getModel().setValueAt(tmpList.get(index), row, column);
                        ++column;
                    }
                }
            }
            catch (UnsupportedFlavorException ex) {
                logger.error(ex.getMessage());
            }
            catch (IOException ex) {
                logger.error(ex.getMessage());
            }
            return super.importData(support);
        }
    }

    private class LoaderRunner
    extends SwingWorker<EFCBoModel, Object> {
        private BusinessDataObject data2load;
        private Runnable callback;

        public LoaderRunner(BusinessDataObject data, Runnable callback) {
            this.data2load = data;
            EFCBusinessDataTablePanel.this.jxTable.setEnabled(false);
            this.callback = callback;
        }

        @Override
        protected EFCBoModel doInBackground() throws Exception {
            LazyLoader lazyLoader;
            this.data2load.lock();
            if (this.data2load instanceof LazyLoader && !(lazyLoader = (LazyLoader)this.data2load).isLoaded()) {
                lazyLoader.load();
                ((EFCBoCellRenderer)EFCBusinessDataTablePanel.this.jxTable.getDefaultRenderer(BusinessObject.class)).clearPanels();
            }
            this.data2load.unlock();
            return new EFCBoModel(this.data2load);
        }

        @Override
        protected void done() {
            try {
                EFCBoModel model = (EFCBoModel)this.get();
                EFCBusinessDataTablePanel.this.updateTable(model);
                if (this.callback != null) {
                    this.callback.run();
                }
            }
            catch (Throwable e) {
                EFCDesktop.reportError(e);
            }
        }
    }

    private class MyListSelectionHandler
    implements ListSelectionListener {
        private String lastClickedElement;
        private int lastClickedRow = -1;
        private int lastClickedColumn = -1;

        private MyListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            logger.debug("MyListSelectionHandler.valueChanged() on " + EFCBusinessDataTablePanel.this.getIdent());
            int column = EFCBusinessDataTablePanel.this.jxTable.getSelectedColumn();
            int row = EFCBusinessDataTablePanel.this.jxTable.getSelectedRow();
            if (column != -1) {
                column = EFCBusinessDataTablePanel.this.jxTable.convertColumnIndexToModel(column);
            }
            if (row != -1) {
                row = EFCBusinessDataTablePanel.this.jxTable.convertRowIndexToModel(row);
            }
            String colName = null;
            colName = column >= 0 ? EFCBusinessDataTablePanel.this.jxTable.getColumnName(EFCBusinessDataTablePanel.this.jxTable.getSelectedColumn()) : null;
            if (row == -1) {
                return;
            }
            if (this.lastClickedRow == row) {
                if (colName == null && this.lastClickedElement == null) {
                    return;
                }
                if (colName == null || colName.equalsIgnoreCase(this.lastClickedElement)) {
                    return;
                }
            }
            EFCBusinessDataTablePanel src = EFCBusinessDataTablePanel.this;
            Point oldPoint = new Point(this.lastClickedColumn, this.lastClickedRow);
            Point newPoint = new Point(column, row);
            SelectionContextChangeEvent sece = new SelectionContextChangeEvent(src, 2079, EFCBusinessDataTablePanel.this.getIdent(), oldPoint, newPoint);
            TableModel tableModel = EFCBusinessDataTablePanel.this.jxTable.getModel();
            if (tableModel instanceof EFCBoModel && column >= 0) {
                EFCBoModel boTableModel = (EFCBoModel)EFCBusinessDataTablePanel.this.jxTable.getModel();
                sece.setSelected(boTableModel.getValueAt(row, column));
                DataChangeManager dcm = EFCBusinessDataTablePanel.this.getDataChangeManager();
                if (dcm != null) {
                    dcm.onSelectionContextChanged(sece);
                }
            }
            this.lastClickedRow = row;
            this.lastClickedColumn = column;
            this.lastClickedElement = colName;
        }
    }
}

