/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.panel;

import de.effectivecompany.base.data.LazyLoader;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.data.DummyBusinessObject;
import de.effectivecompany.graph.gui.GraphListener;
import de.effectivecompany.graph.gui.GraphView;
import de.effectivecompany.gui.components.frame.EFCGraphInfo;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.data.graph.Graph;
import de.effectivecompany.gui.events.SelectionContextChangeEvent;
import de.effectivecompany.gui.interfaces.listeners.UserInputListener;
import de.effectivecompany.gui.interfaces.manager.DataChangeManager;
import de.effectivecompany.gui.interfaces.manager.ElementManager;
import de.effectivecompany.gui.manager.EFCBaseViewManager;
import de.effectivecompany.gui.manager.EFCDataChangeManager;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCGraphPanel
extends EFCPanel
implements GraphListener {
    private static final Logger logger = LoggerFactory.getLogger(EFCGraphPanel.class);
    private EFCGraphInfo infoBox;
    private EFCMap<String, BusinessObject> nodeMap = new EFCMap();
    public static final long serialVersionUID = -129313190L;
    private Graph data = null;
    private Vector<UserInputListener> userInputListeners = new Vector();
    private GraphView panel = new GraphView();
    private boolean datamodified = false;

    public EFCGraphPanel(ElementManager eManager, DataChangeManager dcManager, String ident, String parentIdent, boolean border) {
        super(eManager, dcManager, ident, parentIdent, border);
        this.panel.addGraphLIstener(this);
        this.add((Component)this.panel, "Center");
    }

    public void addUserInputListener(UserInputListener listener) {
        this.userInputListeners.add(listener);
    }

    public UserInputListener[] getUserInputListeners() {
        return this.userInputListeners.toArray(new UserInputListener[0]);
    }

    public void removeUserInputListener(UserInputListener listener) {
        this.userInputListeners.remove(listener);
    }

    public Graph getData() {
        return this.data;
    }

    public void setData(Graph data) {
        this.data = data;
        this.datamodified = true;
        this.repaint();
    }

    public void reloadData() {
        this.nodeMap.clear();
        if (this.data == null) {
            return;
        }
        this.data.getElements().forEach(element -> this.nodeMap.put((Object)element.getElementid().getData(), element.getBo() != null ? element.getBo() : new DummyBusinessObject()));
        this.panel.setData(this.data);
    }

    private void loadData() {
        LazyLoader loader;
        if (this.data instanceof LazyLoader && !(loader = (LazyLoader)this.data).isLoaded()) {
            this.panel.setLocked(true);
            EFCThreadUtil.edtBuilder(th -> th.doOutside(() -> {
                if (this.data != null) {
                    loader.lock();
                    if (!loader.isLoaded()) {
                        try {
                            loader.load();
                        }
                        catch (Exception e) {
                            logger.error(Translator.tr((String)"MSG_FRAME_EXCEPTION"), (Throwable)e);
                        }
                    }
                    loader.unlock();
                    th.edt(() -> {
                        try {
                            this.reloadData();
                        }
                        catch (Throwable e) {
                            EFCDesktop.reportError(e);
                        }
                    });
                }
            }));
        }
        this.datamodified = false;
    }

    public void setLocked(boolean locked) {
        EFCThreadUtil.doLater(() -> this.panel.setLocked(locked));
    }

    @Override
    public void paint(Graphics g) {
        if (this.datamodified) {
            this.loadData();
        }
        super.paint(g);
    }

    @Override
    public void terminate() {
        this.panel.terminate();
        if (this.infoBox != null) {
            this.infoBox.dispose();
        }
        this.nodeMap.clear();
        this.nodeMap = null;
        this.userInputListeners.clear();
        this.removeAll();
        this.userInputListeners = null;
        this.infoBox = null;
        super.terminate();
    }

    @Override
    public void onSelection(String mouse, String id) {
        BusinessObject selectedBusObj = (BusinessObject)this.nodeMap.get((Object)id);
        SelectionContextChangeEvent seceBusObj = new SelectionContextChangeEvent(this, 2081, this.getIdent(), null, selectedBusObj);
        seceBusObj.setSelected(selectedBusObj);
        DataChangeManager dcm = this.getDataChangeManager();
        if (dcm != null) {
            dcm.onSelectionContextChanged(seceBusObj);
        }
        if (this.infoBox == null) {
            if ("right".equals(mouse)) {
                this.infoBox = new EFCGraphInfo(this, new EFCBaseViewManager(), new EFCDataChangeManager(), selectedBusObj);
                EFCDesktop.getInstance().add(this.infoBox);
            }
        } else {
            if ("right".equals(mouse)) {
                this.infoBox.setVisible(true);
            }
            if (selectedBusObj != null) {
                this.infoBox.setBoData(selectedBusObj);
                this.infoBox.toFront();
            }
        }
    }
}

