/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.panel;

import de.effectivecompany.gui.events.FocusChangeEvent;
import de.effectivecompany.gui.interfaces.listeners.FocusChangeListener;
import de.effectivecompany.gui.interfaces.manager.DataChangeManager;
import de.effectivecompany.gui.interfaces.manager.ElementManager;
import de.effectivecompany.gui.interfaces.panel.Panel;
import java.awt.BorderLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.ref.WeakReference;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCPanel
extends JPanel
implements Panel,
Comparable<EFCPanel> {
    private static Logger logger = LoggerFactory.getLogger(EFCPanel.class);
    public static final long serialVersionUID = -1293190L;
    private String ident = "";
    private String parentIdent = "";
    private WeakReference<ElementManager> elementManager;
    private WeakReference<DataChangeManager> dataChangeManager;
    private Vector<FocusChangeListener> focusChangeListeners = new Vector();

    public EFCPanel(String ident) {
        this(ident, null, false);
    }

    public EFCPanel(ElementManager eManager, DataChangeManager dcManager, String ident) {
        this(eManager, dcManager, ident, null, false);
    }

    public EFCPanel(ElementManager eManager, DataChangeManager dcManager, String ident, String parentIdent) {
        this(eManager, dcManager, ident, parentIdent, false);
    }

    public EFCPanel(ElementManager eManager, DataChangeManager dcManager, String ident, String parentIdent, boolean border) {
        super(new BorderLayout());
        this.elementManager = new WeakReference<ElementManager>(eManager);
        this.dataChangeManager = new WeakReference<DataChangeManager>(dcManager);
        this.setIdent(ident);
        this.setParentIdent(parentIdent);
        if (border) {
            this.setBorder(BorderFactory.createTitledBorder(this.ident));
        }
    }

    public EFCPanel(String ident, String parentIdent, boolean border) {
        super(new BorderLayout());
        this.setIdent(ident);
        this.setParentIdent(parentIdent);
        if (border) {
            this.setBorder(BorderFactory.createTitledBorder(this.ident));
        }
    }

    public void addFocusChangeListener(FocusChangeListener listener) {
        this.focusChangeListeners.add(listener);
    }

    public FocusChangeListener[] getFocusChangeListeners() {
        return this.focusChangeListeners.toArray(new FocusChangeListener[0]);
    }

    public void removeFocusChangeListener(FocusChangeListener listener) {
        this.focusChangeListeners.remove(listener);
    }

    protected void fireFocusGainedEvent() {
        this.fireFocusEvent(2030);
    }

    protected void fireFocusLostEvent() {
        this.fireFocusEvent(2029);
    }

    private void fireFocusEvent(int focusChangeEvent) {
        FocusChangeEvent event = new FocusChangeEvent(this, focusChangeEvent, this.getIdent());
        for (FocusChangeListener listener : this.getFocusChangeListeners()) {
            listener.onFocusChanged(event);
        }
    }

    @Override
    public String getIdent() {
        return this.ident;
    }

    @Override
    public void setIdent(String ident) {
        this.ident = ident == null ? "" : ident;
    }

    public String getParentIdent() {
        return this.parentIdent;
    }

    public void setParentIdent(String parentIdent) {
        this.parentIdent = parentIdent == null ? "" : parentIdent;
    }

    @Override
    public ElementManager getElementManager() {
        if (this.elementManager != null) {
            return (ElementManager)this.elementManager.get();
        }
        return null;
    }

    @Override
    public DataChangeManager getDataChangeManager() {
        return (DataChangeManager)this.dataChangeManager.get();
    }

    @Override
    public void terminate() {
        this.removeAll();
        this.focusChangeListeners = null;
        if (this.elementManager != null) {
            this.elementManager.clear();
            this.elementManager = null;
        }
        if (this.dataChangeManager != null) {
            this.dataChangeManager.clear();
            this.dataChangeManager = null;
        }
    }

    @Override
    public int compareTo(EFCPanel o) {
        if (this.getIdent().length() < o.getIdent().length()) {
            return -1;
        }
        if (this.getIdent().length() == o.getIdent().length()) {
            return 0;
        }
        return 1;
    }

    protected class MyFocusHandler
    implements FocusListener {
        protected MyFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent event) {
            EFCPanel.this.fireFocusGainedEvent();
            logger.debug("Focus gained");
        }

        @Override
        public void focusLost(FocusEvent event) {
            EFCPanel.this.fireFocusLostEvent();
            logger.debug("Focus lost");
        }
    }
}

