/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.panel;

import de.effectivecompany.base.data.LazyLoader;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.gui.components.frame.EFCResDiagramDialog;
import de.effectivecompany.gui.components.panel.CustomToolTipGenerator;
import de.effectivecompany.gui.components.panel.EFCCategoryItemEntity;
import de.effectivecompany.gui.components.panel.EFCGanttRenderer;
import de.effectivecompany.gui.components.panel.EFCGlassPanel;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.components.swing.gantt.EFCTask;
import de.effectivecompany.gui.data.BusinessObjectModel;
import de.effectivecompany.gui.data.gantt.EFCBarPainter;
import de.effectivecompany.gui.data.gantt.EFCDefaultResourceGantt;
import de.effectivecompany.gui.events.SelectionContextChangeEvent;
import de.effectivecompany.gui.interfaces.manager.DataChangeManager;
import de.effectivecompany.gui.interfaces.manager.ElementManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyVetoException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.annotations.CategoryAnnotation;
import org.jfree.chart.annotations.CategoryTextAnnotation;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;

public class EFCResourceGanttPanel
extends EFCPanel
implements ChartMouseListener,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -550464318124421491L;
    private ChartPanel chartPanel;
    private EFCGlassPanel glass;
    private boolean dataModified = false;
    private EFCDefaultResourceGantt dataSet;
    boolean canMove = false;
    double initialMovePointY = 0.0;
    double finalMovePointY = 0.0;
    double initialMovePixelY = 0.0;
    double finalMovePixelY = 0.0;
    CategoryItemEntity catItemEntity = null;
    private EFCTask lastSelection;

    public void setLocked(boolean locked) {
        if (this.glass != null) {
            this.glass.setEnabled(!locked);
            if (locked) {
                this.setCursor(new Cursor(3));
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    public EFCResourceGanttPanel(ElementManager eManager, DataChangeManager dcManager, String ident, String parentIdent, boolean border) {
        super(eManager, dcManager, ident, parentIdent, border);
        JScrollPane scrollPane = new JScrollPane();
        this.chartPanel = new ChartPanel(null);
        this.chartPanel.addChartMouseListener((ChartMouseListener)this);
        this.chartPanel.addMouseMotionListener((MouseMotionListener)this);
        this.chartPanel.addMouseListener((MouseListener)this);
        this.chartPanel.setAutoscrolls(false);
        this.chartPanel.setMouseZoomable(false);
        this.chartPanel.setDomainZoomable(false);
        this.chartPanel.setRangeZoomable(false);
        this.chartPanel.setMouseWheelEnabled(true);
        scrollPane.getViewport().add((Component)this.chartPanel);
        this.glass = new EFCGlassPanel(scrollPane);
        this.add(this.glass);
    }

    private Boolean createChart(EFCDefaultResourceGantt dataset) {
        JFreeChart chart = ChartFactory.createGanttChart((String)dataset.getTitle(), (String)dataset.getDomainAxisLabel(), (String)dataset.getRangeAxisLabel(), (IntervalCategoryDataset)dataset, (boolean)dataset.getLegendVisible(), (boolean)dataset.getTooltipsVisible(), (boolean)dataset.getUrlVisible());
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        for (int k = 0; k < dataset.getSeriesCount(); ++k) {
            TaskSeries taskSeries = dataset.getSeries(k);
            for (Object task : taskSeries.getTasks()) {
                if (!(task instanceof EFCTask)) continue;
                EFCTask efcTask = (EFCTask)((Object)task);
                for (int subIndex = 0; subIndex < efcTask.getSubtaskCount(); ++subIndex) {
                    EFCTask efcSubTask;
                    if (!(efcTask.getSubtask(subIndex) instanceof EFCTask) || (efcSubTask = (EFCTask)efcTask.getSubtask(subIndex)).getAnnotationText() == null) continue;
                    CategoryTextAnnotation an = new CategoryTextAnnotation(efcSubTask.getAnnotationText(), (Comparable)plot.getCategories().get(plot.getCategories().indexOf(efcTask.getDescription())), (double)efcSubTask.getDuration().getStart().getTime());
                    an.setTextAnchor(TextAnchor.BOTTOM_CENTER);
                    an.setCategoryAnchor(CategoryAnchor.START);
                    plot.addAnnotation((CategoryAnnotation)an);
                }
            }
        }
        EFCGanttRenderer efcGanttRenderer = new EFCGanttRenderer();
        plot.setRenderer((CategoryItemRenderer)efcGanttRenderer);
        efcGanttRenderer.setDefaultToolTipGenerator((CategoryToolTipGenerator)new CustomToolTipGenerator());
        StandardChartTheme chartTheme = (StandardChartTheme)ChartFactory.getChartTheme();
        chartTheme.setBarPainter((BarPainter)new EFCBarPainter());
        if (dataset.getLableFont() != null) {
            chartTheme.setRegularFont(dataset.getLableFont());
        }
        chartTheme.apply(chart);
        if (dataset.isShowDomainGridLines()) {
            plot.setDomainGridlineStroke((Stroke)new BasicStroke(0.5f));
            plot.setDomainGridlinesVisible(true);
            plot.setDomainGridlinePaint((Paint)Color.GRAY);
        }
        DateAxis dateAxis = (DateAxis)plot.getRangeAxis();
        dateAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat("dd.MM. HH:mm"));
        plot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        if (dataset.getDateTickUnit() != null) {
            dateAxis.setTickUnit(dataset.getDateTickUnit());
        }
        CategoryItemRenderer renderer = plot.getRenderer();
        List<Color> colors = dataset.getSeriesColors();
        if (colors != null) {
            for (int i = 0; i < colors.size(); ++i) {
                renderer.setSeriesPaint(i, (Paint)colors.get(i));
            }
        }
        if (dataset.getTitleFont() != null && chart.getTitle() != null) {
            chart.getTitle().setFont(dataset.getTitleFont());
        }
        if (dataset.getMaxDomainAxisLines() != null) {
            plot.getDomainAxis().setMaximumCategoryLabelLines(dataset.getMaxDomainAxisLines().intValue());
        }
        this.chartPanel.setChart(chart);
        this.chartPanel.setPreferredSize(dataset.getDimension());
        this.chartPanel.setMinimumDrawHeight((int)dataset.getDimension().getHeight());
        this.chartPanel.setMaximumDrawHeight((int)dataset.getDimension().getHeight());
        this.chartPanel.setMinimumDrawWidth((int)dataset.getDimension().getWidth());
        this.chartPanel.setMaximumDrawWidth((int)dataset.getDimension().getWidth());
        this.chartPanel.updateUI();
        return true;
    }

    private void loadData() {
        LazyLoader loader;
        EFCDefaultResourceGantt data = this.getDataset();
        if (data instanceof LazyLoader && !(loader = (LazyLoader)data).isLoaded()) {
            new LoaderRunner().execute();
        }
        this.dataModified = false;
    }

    @Override
    public void paint(Graphics g) {
        if (this.dataModified) {
            this.loadData();
        }
        super.paint(g);
    }

    public void setDataset(EFCDefaultResourceGantt dataset) {
        this.dataSet = dataset;
        this.dataModified = true;
        this.repaint();
    }

    public EFCDefaultResourceGantt getDataset() {
        if (this.dataSet != null) {
            return this.dataSet;
        }
        return new EFCDefaultResourceGantt();
    }

    public void chartMouseClicked(ChartMouseEvent event) {
        EFCCategoryItemEntity result;
        EFCDefaultResourceGantt data;
        Task task;
        ChartEntity entity = event.getEntity();
        event.getSource();
        EFCTask newSelection = null;
        SelectionContextChangeEvent sece = null;
        if (entity instanceof EFCCategoryItemEntity && (task = (data = (EFCDefaultResourceGantt)(result = (EFCCategoryItemEntity)entity).getDataset()).getSeries((Comparable)((Object)((CategoryItemEntity)entity).getColumnKey().toString())).get(((CategoryItemEntity)entity).getRowKey().toString())) instanceof EFCTask) {
            EFCTask efcTask;
            newSelection = efcTask = (EFCTask)task;
            if (efcTask.getSubtaskCount() > 0 && efcTask.getSubtask(result.getSubTaskIndex()) instanceof EFCTask) {
                EFCTask subefcTask;
                newSelection = subefcTask = (EFCTask)efcTask.getSubtask(result.getSubTaskIndex());
            }
        }
        BusinessObject newBusinessObject = null;
        BusinessObject oldBusinessObject = null;
        if (newSelection != null) {
            newSelection.setSelected(true);
            newBusinessObject = newSelection.getBusinessObject();
        }
        if (this.lastSelection != null) {
            this.lastSelection.setSelected(false);
            oldBusinessObject = this.lastSelection.getBusinessObject();
        }
        EFCResourceGanttPanel src = this;
        if (newBusinessObject != null) {
            if (newBusinessObject != oldBusinessObject) {
                sece = new SelectionContextChangeEvent(src, 2083, this.getIdent(), oldBusinessObject, newBusinessObject);
                sece.setSelected(newBusinessObject);
            }
        } else {
            sece = new SelectionContextChangeEvent(src, 2083, this.getIdent(), oldBusinessObject, newBusinessObject);
            sece.setSelected(newBusinessObject);
        }
        if (sece != null) {
            DataChangeManager dcm = this.getDataChangeManager();
            if (dcm != null) {
                dcm.onSelectionContextChanged(sece);
            }
            this.lastSelection = newSelection;
        }
        if (event.getTrigger().getClickCount() == 2 && newBusinessObject != null) {
            EFCResDiagramDialog optionPane = new EFCResDiagramDialog(this, "FA umterminieren", "prd/TdPrdDocOpr_ResDiagInfo.xml", new BusinessObjectModel(newBusinessObject));
            EFCDesktop.getInstance().add(optionPane);
            EFCDesktop.getInstance().moveToFront(optionPane);
            EFCDesktop.getInstance().setSelectedFrame(optionPane);
            try {
                optionPane.setSelected(true);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
        }
    }

    public void chartMouseMoved(ChartMouseEvent paramChartMouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.movePoint(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.canMove = false;
        this.initialMovePointY = 0.0;
        this.chartPanel.setCursor(new Cursor(0));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        EntityCollection entities = this.chartPanel.getChartRenderingInfo().getEntityCollection();
        ChartMouseEvent cme = new ChartMouseEvent(this.chartPanel.getChart(), e, entities.getEntity((double)x, (double)y));
        ChartEntity entity = cme.getEntity();
        if (entity != null && entity instanceof CategoryItemEntity) {
            this.catItemEntity = (CategoryItemEntity)entity;
        } else if (!(entity instanceof CategoryItemEntity)) {
            this.catItemEntity = null;
            return;
        }
        if (this.catItemEntity == null) {
            return;
        }
        Point pt = e.getPoint();
        CategoryPlot cp = this.chartPanel.getChart().getCategoryPlot();
        Rectangle2D dataArea = this.chartPanel.getChartRenderingInfo().getPlotInfo().getDataArea();
        Point2D p = this.chartPanel.translateScreenToJava2D(pt);
        this.initialMovePixelY = p.getX();
        this.initialMovePointY = cp.getRangeAxis().java2DToValue(p.getX(), dataArea, cp.getRangeAxisEdge());
        this.canMove = true;
        this.chartPanel.setCursor(new Cursor(12));
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.canMove = false;
        this.initialMovePointY = 0.0;
        this.chartPanel.setCursor(new Cursor(0));
    }

    public void movePoint(MouseEvent me) {
        try {
            if (this.canMove) {
                Point pt = me.getPoint();
                CategoryPlot cat = this.chartPanel.getChart().getCategoryPlot();
                Rectangle2D dataArea = this.chartPanel.getChartRenderingInfo().getPlotInfo().getDataArea();
                Point2D p = this.chartPanel.translateScreenToJava2D(pt);
                this.finalMovePixelY = p.getX();
                double rangeUB = cat.getRangeAxis().getUpperBound();
                double rangeLB = cat.getRangeAxis().getLowerBound();
                double rangeMillis = cat.getRangeAxis().getRange().getLength();
                double height = dataArea.getWidth();
                double millisPerPixel = rangeMillis / height;
                double deltaPixel = this.finalMovePixelY - this.initialMovePixelY;
                double deltaMillis = deltaPixel * millisPerPixel;
                this.finalMovePointY = this.initialMovePointY + deltaMillis;
                if (this.finalMovePointY > rangeUB) {
                    this.finalMovePointY = rangeUB;
                }
                if (this.finalMovePointY < rangeLB) {
                    this.finalMovePointY = rangeLB;
                }
                long fMPY = new Double(this.finalMovePointY).longValue();
                Date targetEnd = new Date(fMPY);
                EFCDefaultResourceGantt data = (EFCDefaultResourceGantt)this.catItemEntity.getDataset();
                EFCTask efcTask = (EFCTask)data.getSeries(this.catItemEntity.getRowKey()).get(this.catItemEntity.getColumnKey().toString());
                TimePeriod periode = efcTask.getDuration();
                long time = periode.getEnd().getTime() - periode.getStart().getTime();
                long newStart = targetEnd.getTime() - time;
                efcTask.setDuration((TimePeriod)new SimpleTimePeriod(new Date(newStart), targetEnd));
                efcTask.getBusinessObject();
                this.chartPanel.getChart().fireChartChanged();
                this.chartPanel.updateUI();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class LoaderRunner
    extends SwingWorker<Boolean, Object> {
        LazyLoader loadData;

        public LoaderRunner() {
            EFCResourceGanttPanel.this.setLocked(true);
            EFCDefaultResourceGantt data = EFCResourceGanttPanel.this.getDataset();
            if (data instanceof LazyLoader) {
                this.loadData = data;
            }
        }

        @Override
        protected Boolean doInBackground() {
            if (this.loadData != null) {
                this.loadData.lock();
                if (!this.loadData.isLoaded()) {
                    this.loadData.load();
                }
                this.loadData.unlock();
            }
            return EFCResourceGanttPanel.this.createChart(EFCResourceGanttPanel.this.getDataset());
        }

        @Override
        protected void done() {
            try {
                this.get();
            }
            catch (Throwable e) {
                EFCDesktop.reportError(e);
            }
            EFCResourceGanttPanel.this.setLocked(false);
        }
    }
}

