/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.panel;

import de.effectivecompany.base.data.LazyLoader;
import de.effectivecompany.base.data.StatisticDataObject;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.model.table.StatisticDataTableModel;
import de.effectivecompany.gui.components.panel.EFCGlassPanel;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.components.swing.EFCTableCellRenderer;
import de.effectivecompany.gui.components.swing.EFCTableRowHeader;
import de.effectivecompany.gui.events.FocusChangeEvent;
import de.effectivecompany.gui.interfaces.listeners.FocusChangeListener;
import de.effectivecompany.gui.interfaces.listeners.UserInputListener;
import de.effectivecompany.gui.interfaces.manager.DataChangeManager;
import de.effectivecompany.gui.interfaces.manager.ElementManager;
import de.effectivecompany.gui.interfaces.panel.StatisticPanel;
import de.effectivecompany.gui.interfaces.panel.TablePanel;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCStatisticTablePanel
extends EFCPanel
implements StatisticPanel,
TablePanel {
    public static final long serialVersionUID = -733455L;
    private static final Logger logger = LoggerFactory.getLogger(EFCStatisticTablePanel.class);
    private JXTable jxTable = new JXTable(1, 1);
    private JScrollPane scroll = new JScrollPane((Component)this.jxTable);
    private EFCGlassPanel glass = new EFCGlassPanel(this.scroll);
    private Vector<FocusChangeListener> focusChangeListeners = new Vector();
    private Vector<UserInputListener> userInputListeners = new Vector();
    private int fractionDigits = 2;
    private StatisticDataObject dataobject;
    private boolean datamodified;
    private String sidecol;
    private String bottomcol;
    private EFCTableRowHeader rowTable;

    public void setFractionDigits(String fractionDigits) {
        this.fractionDigits = Integer.parseInt(fractionDigits);
        this.jxTable.setDefaultRenderer(Object.class, (TableCellRenderer)new ListCellRenderer());
    }

    public EFCStatisticTablePanel(ElementManager manager, DataChangeManager dcm, String ident, String parentIdent, boolean border) {
        super(manager, dcm, ident, parentIdent, border);
        EFCPanel.MyFocusHandler focusHandler = new EFCPanel.MyFocusHandler();
        this.jxTable.addFocusListener((FocusListener)focusHandler);
        this.jxTable.setDragEnabled(true);
        this.jxTable.setSortable(false);
        this.jxTable.setHorizontalScrollEnabled(true);
        this.jxTable.getSelectionModel().setSelectionMode(0);
        this.jxTable.setDefaultRenderer(Object.class, (TableCellRenderer)new ListCellRenderer());
        this.rowTable = new EFCTableRowHeader((JTable)this.jxTable, null);
        this.scroll.setRowHeaderView((Component)((Object)this.rowTable));
        this.scroll.setCorner("UPPER_LEFT_CORNER", this.rowTable.getTableHeader());
        this.add(this.glass);
    }

    public void addUserInputListener(UserInputListener listener) {
        this.userInputListeners.add(listener);
    }

    public UserInputListener[] getUserInputListeners() {
        return this.userInputListeners.toArray(new UserInputListener[0]);
    }

    public void removeUserInputListener(UserInputListener listener) {
        this.userInputListeners.remove(listener);
    }

    @Override
    public void addFocusChangeListener(FocusChangeListener listener) {
        this.focusChangeListeners.add(listener);
    }

    @Override
    public FocusChangeListener[] getFocusChangeListeners() {
        return this.focusChangeListeners.toArray(new FocusChangeListener[0]);
    }

    @Override
    public void removeFocusChangeListener(FocusChangeListener listener) {
        this.focusChangeListeners.remove(listener);
    }

    @Override
    public void fireFocusGainedEvent() {
        FocusChangeEvent event = new FocusChangeEvent(this, 2030, this.getIdent());
        this.notifyListeners(event);
    }

    @Override
    public void fireFocusLostEvent() {
        FocusChangeEvent event = new FocusChangeEvent(this, 2029, this.getIdent());
        this.notifyListeners(event);
    }

    private void notifyListeners(FocusChangeEvent event) {
        for (FocusChangeListener listener : this.getFocusChangeListeners()) {
            listener.onFocusChanged(event);
        }
    }

    public void setData(List<BusinessObject> data) {
        ElementManager em = this.getElementManager();
        if (em != null) {
            em.resetAllFields(this.getIdent() + ".");
        }
    }

    @Override
    public void setDataSource(StatisticDataObject data) {
        this.dataobject = data;
        this.datamodified = true;
        this.repaint();
    }

    public void setSideBarType(String type) {
        this.sidecol = type;
    }

    public void setBottomBarType(String type) {
        this.bottomcol = type;
    }

    public void setLocked(boolean locked) {
        if (this.glass != null) {
            this.glass.setEnabled(!locked);
            if (locked) {
                this.setCursor(new Cursor(3));
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void loadData() {
        if (this.dataobject != null) {
            this.setLocked(true);
            new LoaderRunner(this.dataobject).execute();
        }
        this.datamodified = false;
    }

    @Override
    public void paint(Graphics g) {
        if (this.datamodified) {
            this.loadData();
        }
        super.paint(g);
    }

    @Override
    public int getSelectedColumn() {
        return this.jxTable.getSelectedColumn();
    }

    @Override
    public int getSelectedIndex() {
        return this.jxTable.getSelectedRow();
    }

    @Override
    public TableModel getTableModel() {
        return this.jxTable.getModel();
    }

    @Override
    public void terminate() {
        for (FocusListener focusListener : this.jxTable.getFocusListeners()) {
            this.jxTable.removeFocusListener(focusListener);
        }
        this.focusChangeListeners.clear();
        this.focusChangeListeners = null;
        this.userInputListeners.clear();
        this.focusChangeListeners = null;
        this.removeAll();
        this.jxTable = null;
        this.dataobject = null;
        this.glass = null;
        super.terminate();
    }

    @Override
    public JXTable getTable() {
        return this.jxTable;
    }

    @Override
    public void setColumnModelXML(String code) {
    }

    @Override
    public String getLayoutFileName() {
        return null;
    }

    @Override
    public void clearTableColums() {
    }

    @Override
    public void reloadColumnModel() {
    }

    @Override
    public String getColumnModelXML() {
        return null;
    }

    private class LoaderRunner
    extends SwingWorker<StatisticDataTableModel, Object> {
        private StatisticDataObject data2load;

        public LoaderRunner(StatisticDataObject data) {
            this.data2load = data;
            EFCStatisticTablePanel.this.jxTable.setEnabled(false);
        }

        @Override
        protected StatisticDataTableModel doInBackground() throws Exception {
            LazyLoader lazyLoader;
            this.data2load.lock();
            if (this.data2load instanceof LazyLoader && !(lazyLoader = (LazyLoader)this.data2load).isLoaded()) {
                lazyLoader.load();
            }
            this.data2load.unlock();
            return new StatisticDataTableModel(this.data2load);
        }

        @Override
        protected void done() {
            try {
                StatisticDataTableModel model = (StatisticDataTableModel)this.get();
                model.setSideBarType(EFCStatisticTablePanel.this.sidecol);
                model.setBottomBarType(EFCStatisticTablePanel.this.bottomcol);
                EFCStatisticTablePanel.this.jxTable.setModel((TableModel)model);
                EFCStatisticTablePanel.this.rowTable.updateTable();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.error(Translator.tr((String)"MSG_FRAME_EXCEPTION"), (Throwable)e);
            }
            EFCStatisticTablePanel.this.jxTable.setEnabled(true);
            EFCStatisticTablePanel.this.setLocked(false);
        }
    }

    private class ListCellRenderer
    extends EFCTableCellRenderer {
        private static final long serialVersionUID = 7575179805835429100L;

        private ListCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            component.setFont(EFCLookAndFeelManager.FONT_TABLE_CELLS);
            if (component instanceof JLabel) {
                JLabel label = (JLabel)component;
                if (value instanceof Number[]) {
                    Number[] data = (Number[])value;
                    if (data.length > 0) {
                        if (data[0] != null) {
                            try {
                                value = Double.parseDouble(data[0].toString());
                            }
                            catch (NumberFormatException ex) {
                                value = data[0].toString();
                            }
                        } else {
                            label.setText("");
                        }
                    } else {
                        label.setText("-");
                    }
                }
                if (value instanceof Float || value instanceof Double) {
                    NumberFormat nf = (NumberFormat)NumberFormat.getInstance().clone();
                    nf.setMaximumFractionDigits(EFCStatisticTablePanel.this.fractionDigits);
                    nf.setMinimumFractionDigits(EFCStatisticTablePanel.this.fractionDigits);
                    label.setText(nf.format(value));
                    label.setHorizontalAlignment(4);
                } else if (value instanceof Integer || value instanceof Long) {
                    label.setHorizontalAlignment(4);
                }
                label.setBorder(EFCLookAndFeelManager.TABLE_CELL_BORRDER_EMPTYBORDER);
            }
            return component;
        }

        @Override
        protected void setValue(Object value) {
            if (value instanceof Number[]) {
                Number[] data = (Number[])value;
                if (data.length > 0) {
                    if (data[0] != null) {
                        this.setText(data[0].toString());
                    } else {
                        this.setText("");
                    }
                } else {
                    this.setText("-");
                }
            } else {
                super.setValue(value);
            }
        }
    }
}

