/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.root;

import de.effectivecompany.app.app.service.SvSysUser;
import de.effectivecompany.app.bascl.ClBasCompany;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.root.EFCMainFrame;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.EFCThreadUtil;
import de.effectivecompany.thread.ResultRunnable;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.control.TextInputDialog;
import javafx.stage.Stage;
import javax.swing.DefaultDesktopManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCDesktop
extends JDesktopPane {
    public static final long serialVersionUID = -16242345452L;
    private static final Logger logger = LoggerFactory.getLogger(EFCDesktop.class);
    private static ClBasCompany company;
    private SvSysUser svSysUser = (SvSysUser)SpringHelper.getService(SvSysUser.class);
    private static EFCDesktop instance;
    public static final int OPTION_YES = 0;
    public static final int OPTION_NO = 1;
    public static final int OPTION_OK = 0;
    public static final int OPTION_CANCEL = 2;
    public static final int OPTION_CLOSE = -1;

    private EFCDesktop() {
        this.setBackground(EFCLookAndFeelManager.COLOR_DESKTOP_BACKGROUND);
        this.setBorder(EFCLookAndFeelManager.STYLE_DESKTOP_BORDER);
        company = this.svSysUser.getUsrClBasCompany();
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                KeyEvent e;
                if (event instanceof KeyEvent && (e = (KeyEvent)event).isControlDown() && e.getKeyCode() == 9 && e.getID() == 401) {
                    EFCDesktop.this.selectFrame(!e.isShiftDown());
                    e.consume();
                }
            }
        }, 8L);
        this.setDesktopManager(new DefaultDesktopManager(){
            private static final long serialVersionUID = 1L;

            @Override
            public void iconifyFrame(JInternalFrame f) {
                Rectangle r = this.getBoundsForIconOf(f);
                r.width = f.getDesktopIcon().getPreferredSize().width;
                f.getDesktopIcon().setBounds(r);
                super.iconifyFrame(f);
            }

            @Override
            public void setBoundsForFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
                boolean didResize;
                boolean bl = didResize = f.getWidth() != newWidth || f.getHeight() != newHeight;
                if (!this.inBounds((JInternalFrame)f, newX, newY, newWidth, newHeight)) {
                    Container parent = f.getParent();
                    Dimension parentSize = parent.getSize();
                    int boundedX = (int)Math.min((double)Math.max(0, newX), parentSize.getWidth() - (double)newWidth);
                    int boundedY = (int)Math.min((double)Math.max(0, newY), parentSize.getHeight() - (double)newHeight);
                    f.setBounds(boundedX, boundedY, newWidth, newHeight);
                } else {
                    f.setBounds(newX, newY, newWidth, newHeight);
                }
                if (didResize) {
                    f.validate();
                }
            }

            protected boolean inBounds(JInternalFrame f, int newX, int newY, int newWidth, int newHeight) {
                if (newX < 0 || newY < 0) {
                    return false;
                }
                if (newX + newWidth > f.getDesktopPane().getWidth()) {
                    return false;
                }
                return newY + newHeight <= f.getDesktopPane().getHeight();
            }
        });
        Object isFullWindowDragsOn = Toolkit.getDefaultToolkit().getDesktopProperty("win.frame.fullWindowDragsOn");
        if (isFullWindowDragsOn == null || !((Boolean)isFullWindowDragsOn).booleanValue()) {
            this.setDragMode(1);
        }
    }

    public static EFCDesktop getInstance() {
        if (instance == null) {
            instance = new EFCDesktop();
        }
        return instance;
    }

    public static void reportError(Throwable e) {
        EFCDesktop.reportError(e.getClass().getSimpleName() + ": " + e.getMessage(), e);
    }

    public static void reportError(String message, Throwable e) {
        EFCThreadUtil.doLater(() -> {
            JXErrorPane jPane = new JXErrorPane();
            jPane.setErrorInfo(new ErrorInfo("Error", message, null, "some cat", e, Level.SEVERE, null));
            ErrorReporter eR = new ErrorReporter(){

                public void reportError(ErrorInfo info) throws NullPointerException {
                    try {
                        Class<?> clazz = Class.forName("de.effectivecompany.gui.util.MailTools", false, this.getClass().getClassLoader());
                        clazz.getMethod("createErrorMsgMailDialog", ErrorInfo.class).invoke(null, info);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                        EFCDesktop.reportError(ex);
                    }
                }
            };
            jPane.setErrorReporter(eR);
            jPane.getActionMap().get("report-action").putValue("Name", "Bericht senden");
            JXErrorPane.showDialog((Component)EFCDesktop.getInstance(), (JXErrorPane)jPane);
        });
        logger.error(Translator.tr((String)"MSG_FRAME_EXCEPTION"), e);
    }

    public static void showErrorDlg(String message) {
        EFCThreadUtil.doLater(() -> JOptionPane.showMessageDialog(instance, message, Translator.tr((String)"DLG_TITLE_ERROR"), 0));
    }

    public static void showErrorDlg(Object message, String title) {
        EFCThreadUtil.doLater(() -> JOptionPane.showMessageDialog(instance, message, title, 0));
    }

    public static void showWarningDlg(String message) {
        EFCThreadUtil.doLater(() -> JOptionPane.showMessageDialog(instance, message, Translator.tr((String)"DLG_TITLE_INFO"), 2));
    }

    public static void showWarningDlg(Object message, String title) {
        EFCThreadUtil.doLater(() -> JOptionPane.showMessageDialog(instance, message, title, 2));
    }

    public static void showInfoDlg(Object message) {
        EFCThreadUtil.doLater(() -> JOptionPane.showMessageDialog(instance, message, Translator.tr((String)"DLG_TITLE_INFO"), 1));
    }

    public static void showInfoDlg(Object message, String title) {
        EFCDesktop.showInfoDlg(message, title, null);
    }

    public static void showInfoDlg(Object message, String title, Integer showForSeconds) {
        EFCDesktop.showInfoDlg(message, title, showForSeconds, null);
    }

    public static void showInfoDlg(Object message, String title, Integer showForSeconds, Integer disableCloseForSeconds) {
        JButton okButton = new JButton(Translator.tr((String)"_OK"));
        final JDialog dialog = new JDialog(EFCMainFrame.getInstance(), title, true);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        if (showForSeconds != null) {
            Executors.newSingleThreadScheduledExecutor().schedule(() -> dialog.dispose(), (long)showForSeconds.intValue(), TimeUnit.SECONDS);
        }
        if (disableCloseForSeconds != null) {
            okButton.setEnabled(false);
            Executors.newSingleThreadScheduledExecutor().schedule(() -> okButton.setEnabled(true), (long)disableCloseForSeconds.intValue(), TimeUnit.SECONDS);
        }
        EFCThreadUtil.doLater(() -> {
            JOptionPane pane = new JOptionPane(message, 1, 0, null, new Object[]{okButton}, okButton);
            pane.setInitialValue(okButton);
            dialog.setContentPane(pane);
            dialog.setDefaultCloseOperation(0);
            pane.selectInitialValue();
            dialog.pack();
            dialog.setLocationRelativeTo(EFCMainFrame.getInstance());
            dialog.setVisible(true);
        });
    }

    public static String showInputDialog(String title, String headerText, String contentText, String value) {
        return EFCDesktop.showInputDialog(title, headerText, contentText, value, null);
    }

    public static String showInputDialog(final String title, final String headerText, final String contentText, final String value, final Integer maxTextLength) {
        FutureTask<String> task = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                TextInputDialog dialog = EFCDesktop.createTextInputDialog(title, headerText, contentText, value, maxTextLength);
                Optional result = dialog.showAndWait();
                if (result.isPresent()) {
                    return (String)result.get();
                }
                return null;
            }
        });
        EFCThreadUtil.doLaterFAT(task);
        try {
            return task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("showInputDialog", (Throwable)e);
            return null;
        }
    }

    private static TextInputDialog createTextInputDialog(String title, String headerText, String contentText, String value) {
        return EFCDesktop.createTextInputDialog(title, headerText, contentText, value, null);
    }

    private static TextInputDialog createTextInputDialog(String title, String headerText, String contentText, String value, final Integer maxTextLength) {
        final TextInputDialog dialog = new TextInputDialog(value);
        dialog.setTitle(title);
        dialog.setHeaderText(headerText);
        dialog.setContentText(contentText);
        if (maxTextLength != null) {
            dialog.getEditor().textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> ov, String oldValue, String newValue) {
                    if (dialog.getEditor().getText().length() > maxTextLength) {
                        String s = dialog.getEditor().getText().substring(0, maxTextLength);
                        dialog.getEditor().setText(s);
                    }
                }
            });
        }
        Stage stage = (Stage)dialog.getDialogPane().getScene().getWindow();
        stage.getIcons().addAll(EFCLookAndFeelManager.ICON_APP_FX);
        return dialog;
    }

    private static Alert createAlert(Alert.AlertType type, String title, String headerText, String contentText, ButtonType ... buttonTypes) {
        Alert alert = new Alert(type);
        alert.setTitle(title);
        alert.setHeaderText(headerText);
        alert.setContentText(contentText);
        if (buttonTypes.length > 0) {
            alert.getButtonTypes().setAll((Object[])buttonTypes);
        }
        alert.getDialogPane().getButtonTypes().stream().map(arg_0 -> ((DialogPane)alert.getDialogPane()).lookupButton(arg_0)).forEach(node -> {
            if (node instanceof Button) {
                ((Button)node).setAlignment(Pos.CENTER);
            }
        });
        Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
        stage.getIcons().addAll(EFCLookAndFeelManager.ICON_APP_FX);
        return alert;
    }

    public static void showWarningDialog(String title, String headerText, String contentText) {
        EFCThreadUtil.doLaterFAT(() -> {
            Alert alert = EFCDesktop.createAlert(Alert.AlertType.WARNING, title, headerText, contentText, new ButtonType[0]);
            alert.showAndWait();
        });
    }

    public static void showInfoDialog(String title, String headerText, String contentText) {
        EFCThreadUtil.doLaterFAT(() -> {
            Alert alert = EFCDesktop.createAlert(Alert.AlertType.INFORMATION, title, headerText, contentText, new ButtonType[0]);
            alert.showAndWait();
        });
    }

    public static Boolean showYesNoDialog(final String title, final String headerText, final String contentText) {
        FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                ButtonType buttonTypeYes = new ButtonType(Translator.tr((String)"_YES"));
                ButtonType buttonTypeNo = new ButtonType(Translator.tr((String)"_NO"));
                Alert alert = EFCDesktop.createAlert(Alert.AlertType.CONFIRMATION, title, headerText, contentText, buttonTypeYes, buttonTypeNo);
                Optional result = alert.showAndWait();
                if (result.get() == buttonTypeYes) {
                    return true;
                }
                return false;
            }
        });
        EFCThreadUtil.doLaterFAT(task);
        try {
            return task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("showYesNoDialog: ", (Throwable)e);
            return null;
        }
    }

    public static Boolean showYesNoCancelDialog(final String title, final String headerText, final String contentText) {
        FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                ButtonType buttonTypeYes = new ButtonType(Translator.tr((String)"_YES"), ButtonBar.ButtonData.YES);
                ButtonType buttonTypeNo = new ButtonType(Translator.tr((String)"_NO"), ButtonBar.ButtonData.NO);
                ButtonType buttonTypeCancel = new ButtonType(Translator.tr((String)"_CANCEL"), ButtonBar.ButtonData.CANCEL_CLOSE);
                Alert alert = EFCDesktop.createAlert(Alert.AlertType.CONFIRMATION, title, headerText, contentText, buttonTypeYes, buttonTypeNo, buttonTypeCancel);
                Optional result = alert.showAndWait();
                if (result.get() == buttonTypeYes) {
                    return true;
                }
                if (result.get() == buttonTypeNo) {
                    return false;
                }
                return null;
            }
        });
        EFCThreadUtil.doLaterFAT(task);
        try {
            return task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("showYesNoCancelDialog: ", (Throwable)e);
            return null;
        }
    }

    public static Boolean showOkCancelDialog(final String title, final String headerText, final String contentText) {
        FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Alert alert = EFCDesktop.createAlert(Alert.AlertType.CONFIRMATION, title, headerText, contentText, new ButtonType[0]);
                Optional result = alert.showAndWait();
                if (result.get() == ButtonType.OK) {
                    return true;
                }
                return false;
            }
        });
        EFCThreadUtil.doLaterFAT(task);
        try {
            return task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("showOkCancelDialog", (Throwable)e);
            return null;
        }
    }

    public static int showYesNoDlg(Object message, String title, int defaultButton) {
        Object[] options = new Object[]{UIManager.getString("OptionPane.yesButtonText"), UIManager.getString("OptionPane.noButtonText")};
        return JOptionPane.showOptionDialog(instance, message, title, 0, 3, null, options, options[defaultButton]);
    }

    public static int showYesNoDlg(Object message, String title) {
        return EFCDesktop.showYesNoDlg(message, title, 0);
    }

    public static int showOkCancelDlg(Object message, String title, int defaultButton) {
        Object[] options = new Object[]{UIManager.getString("OptionPane.okButtonText"), UIManager.getString("OptionPane.cancelButtonText")};
        return JOptionPane.showOptionDialog(instance, message, title, 2, 2, null, options, options[defaultButton]);
    }

    public static int showOkCancelDlg(Object message, String title) {
        return EFCDesktop.showOkCancelDlg(message, title, 0);
    }

    public static int showYesNoCancelDlg(String message, String title, int defaultButton) {
        Object[] options = new Object[]{UIManager.getString("OptionPane.yesButtonText"), UIManager.getString("OptionPane.noButtonText"), UIManager.getString("OptionPane.cancelButtonText")};
        return JOptionPane.showOptionDialog(instance, message, title, 1, 3, null, options, options[defaultButton]);
    }

    public static int showYesNoCancelDlg(String message, String title) {
        return EFCDesktop.showYesNoCancelDlg(message, title, 0);
    }

    public static int showOptionDlg(String message, String title, Object[] options, int defaultButton) {
        return JOptionPane.showOptionDialog(instance, message, title, 1, 3, null, options, options[defaultButton]);
    }

    public static int showOptionDlg(String message, String title, Object[] options) {
        return EFCDesktop.showOptionDlg(message, title, options, 0);
    }

    @Override
    public Component add(final Component arg0) {
        ResultRunnable<Component> r = new ResultRunnable<Component>(){
            public Component component;

            @Override
            public void run() {
                this.component = EFCDesktop.super.add(arg0);
                if (this.component instanceof JInternalFrame) {
                    EFCDesktop.this.moveToFront(this.component);
                    this.component.requestFocus();
                }
            }

            @Override
            public Component getResult() {
                return this.component;
            }
        };
        EFCThreadUtil.doAndWait(r);
        return (Component)r.getResult();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setFont(EFCLookAndFeelManager.FONT_FRAME_BACKGROUND);
        if (EFCLookAndFeelManager.IS_REMOTE_DESKTOP_SESSION) {
            String logo = "W\u00fchler & Gebauer EDV-Consulting GmbH";
            String info = "TERMINAL VERSION - \u00a9 2020 W\u00fchler & Gebauer EDV-Consulting GmbH - W&G effective company\u00ae - TERMINAL VERSION";
            g.drawString(logo, (int)((double)this.getWidth() - g.getFontMetrics().getStringBounds(logo, g).getWidth() - 5.0), (int)g.getFontMetrics().getStringBounds(logo, g).getHeight());
            g.drawString(info, (int)((double)this.getWidth() - g.getFontMetrics().getStringBounds(info, g).getWidth() - 5.0), (int)((double)this.getHeight() - g.getFontMetrics().getStringBounds(info, g).getHeight()));
            if (EFCLookAndFeelManager.IS_TEST_VERSION) {
                String testNote = "TEST VERSION";
                g.setFont(new Font("SansSerif", 1, 48));
                g.drawString(testNote, (int)((double)(this.getWidth() / 2) - g.getFontMetrics().getStringBounds(testNote, g).getWidth() / 2.0), this.getHeight() / 2);
            }
        } else {
            ImageIcon background = EFCLookAndFeelManager.ICON_BACKGROUND_CENTER;
            ImageIcon logo = EFCLookAndFeelManager.ICON_BACKGROUND_ICON;
            ImageIcon info = EFCLookAndFeelManager.ICON_BACKGROUND_INFO;
            g.drawImage(background.getImage(), this.getWidth() / 2 - background.getIconWidth() / 2, this.getHeight() / 2 - background.getIconHeight() / 2, this);
            g.drawImage(logo.getImage(), this.getWidth() - logo.getIconWidth(), 0, this);
            g.drawImage(info.getImage(), this.getWidth() - info.getIconWidth(), this.getHeight() - info.getIconHeight(), this);
            if (EFCLookAndFeelManager.IS_TEST_VERSION) {
                String testNote = "TEST VERSION";
                g.setFont(new Font("SansSerif", 1, 48));
                g.drawString(testNote, (int)((double)(this.getWidth() / 2) - g.getFontMetrics().getStringBounds(testNote, g).getWidth() / 2.0), this.getHeight() / 2);
            }
        }
        g.drawString(company.getStext().toString(), 10, this.getHeight() - 10);
    }

    public static String getCompany() {
        return company.getCompany().getData();
    }

    static {
        instance = null;
    }
}

