/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.root;

import de.effectivecompany.app.app.service.SvSysApp;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.EFC;
import de.effectivecompany.gui.components.frame.EFCCalculatorFrame;
import de.effectivecompany.gui.components.frame.EFCFrameLayoutInfo;
import de.effectivecompany.gui.components.frame.EFCHelp;
import de.effectivecompany.gui.components.frame.EFCInternalFrameView;
import de.effectivecompany.gui.components.fx.dialog.EFCNewVersionReminderDialog;
import de.effectivecompany.gui.components.fx.dialog.EFCStartServerShutdownReminderDialog;
import de.effectivecompany.gui.components.fx.dialog.EFCTextMessageDialog;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.components.root.EFCMainPanel;
import de.effectivecompany.gui.exceptions.ActionNotAllowedException;
import de.effectivecompany.gui.factory.EFCPanelSingleton;
import de.effectivecompany.gui.interfaces.handler.ActionHandler;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.cef.CefApp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCMainFrame
extends JFrame
implements ActionHandler {
    public static final long serialVersionUID = -1542678L;
    private static Logger logger = LoggerFactory.getLogger(EFCMainFrame.class);
    private EFCMainPanel panel = new EFCMainPanel(this);
    private SvSysApp svSysApp = (SvSysApp)SpringHelper.getService(SvSysApp.class);
    private static EFCMainFrame instance = new EFCMainFrame();

    protected EFCMainFrame() {
        this.setContentPane(this.panel);
        this.setMinimumSize(new Dimension(600, 400));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                EFCMainFrame.this.handleAction("exit", null);
            }
        });
        this.setIconImages(EFCLookAndFeelManager.ICON_APP);
        this.setTitle("effective company");
        EFCPanelSingleton.getInstance();
    }

    public static EFCMainFrame getInstance() {
        return instance;
    }

    public EFCMainPanel getPanel() {
        return this.panel;
    }

    @Override
    public void handleAction(String ident, Object param) {
        if ("exit".equals(ident)) {
            boolean closeAllowed = true;
            boolean additionalInfo = true;
            Component[] components = EFCDesktop.getInstance().getComponents();
            for (int i = 0; i < components.length; ++i) {
                if (!(components[i] instanceof EFCInternalFrameView)) continue;
                try {
                    closeAllowed = closeAllowed && ((EFCInternalFrameView)components[i]).getController().isClosingAllowed();
                    continue;
                }
                catch (ActionNotAllowedException anae) {
                    if (!anae.isNotified()) {
                        EFCDesktop.showWarningDlg(anae.getMessage(), Translator.tr((String)"MSG_FRAME_ACTION_NOT_ALLOWED_TITLE"));
                        anae.notified();
                    }
                    additionalInfo = false;
                    closeAllowed = false;
                }
            }
            if (closeAllowed) {
                if (EFCDesktop.showYesNoDlg(Translator.tr((String)"MSG_FRAME_EXIT_EFC"), Translator.tr((String)"MSG_FRAME_EXIT_EFC_TITLE"), 0) == 0) {
                    this.terminate();
                }
            } else if (additionalInfo) {
                EFCDesktop.showInfoDlg(Translator.tr((String)"MSG_FRAME_ACTION_CLOSE_NOT_ALLOWED_BY_PROGRAMMS"));
            }
        } else if ("calc".equals(ident)) {
            EFCDesktop.getInstance().add(new EFCCalculatorFrame());
        } else if ("help".equals(ident)) {
            EFCDesktop.getInstance().add(new EFCHelp());
        } else if ("windowlock".equals(ident)) {
            this.lockWindowPosition((Boolean)param);
        } else if ("textMessage".equals(ident)) {
            this.openTextMessageDialog();
        } else if ("startServerShutdown".equals(ident)) {
            this.openStartServerShutdownReminderDialog();
        } else if ("stopServerShutdown".equals(ident)) {
            this.stopServerShutdownReminder();
        } else if ("sendNewVersionReminder".equals(ident)) {
            this.sendNewVersionReminder();
        } else {
            logger.debug("DEBUG: EFCMainFrame: unhandled action: " + ident);
        }
    }

    public void terminate() {
        try {
            CefApp.getInstance().dispose();
        }
        catch (Throwable t) {
            logger.error("Error during shutdown CEF", t);
        }
        try {
            EFC.getInstance().shutdown();
        }
        catch (Throwable t) {
            logger.error("Error during shutdown EFC", t);
        }
        EFCThreadUtil.edtBuilder(th -> th.doOutside(() -> {
            try {
                this.svSysApp.getSysInfoForLogout();
            }
            catch (Throwable throwable) {
            }
            finally {
                System.exit(0);
            }
        }));
    }

    private void lockWindowPosition(Boolean isLocked) {
        if (isLocked.booleanValue()) {
            String frameName = this.getClass().getSimpleName();
            Dimension preferredSize = this.panel.getNavigatorFrame().getSize();
            Point location = this.panel.getNavigatorFrame().getLocation();
            EFCFrameLayoutInfo layoutInfo = new EFCFrameLayoutInfo(frameName, preferredSize.getSize().width, preferredSize.getSize().height, location.x, location.y, false);
            EFCPanelSingleton.getInstance().setFramePosition(frameName, null, layoutInfo);
        } else {
            EFCPanelSingleton.getInstance().removeFramePosition(this.getClass().getSimpleName(), null);
        }
    }

    private void openTextMessageDialog() {
        EFCThreadUtil.doLaterFAT(() -> new EFCTextMessageDialog());
    }

    private void openStartServerShutdownReminderDialog() {
        EFCThreadUtil.doLaterFAT(() -> new EFCStartServerShutdownReminderDialog());
    }

    private void stopServerShutdownReminder() {
        EFCThreadUtil.edtBuilder(th -> th.doOutside(() -> this.svSysApp.stopDcShutdownReminder()));
    }

    private void sendNewVersionReminder() {
        EFCThreadUtil.doLaterFAT(() -> new EFCNewVersionReminderDialog());
    }
}

