/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.root;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.effectivecompany.app.app.service.SvSysApp;
import de.effectivecompany.app.sys.DcShutdownReminder;
import de.effectivecompany.app.sys.SysInfo;
import de.effectivecompany.app.sys.TextMsg;
import de.effectivecompany.app.syswfl.service.SvBoWflProcDef;
import de.effectivecompany.base.efcbl.error.ApplicationException;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.client.controller.XciActions;
import de.effectivecompany.gui.components.EFCStatusBar;
import de.effectivecompany.gui.components.EFCTAPIEventDataNotificationPane;
import de.effectivecompany.gui.components.frame.EFCFrameLayoutInfo;
import de.effectivecompany.gui.components.fx.EFCFxButton;
import de.effectivecompany.gui.components.fx.EFCMainMenu;
import de.effectivecompany.gui.components.fx.dialog.Notification;
import de.effectivecompany.gui.components.fx.event.EFCAbstractAction;
import de.effectivecompany.gui.components.fx.event.EFCActionCalculator;
import de.effectivecompany.gui.components.fx.event.EFCActionExit;
import de.effectivecompany.gui.components.fx.event.EFCActionHelp;
import de.effectivecompany.gui.components.fx.event.EFCActionWindowLock;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.fx.wfl.service.EFCHasWorkflowService;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.components.root.EFCMainFrame;
import de.effectivecompany.gui.components.root.EFCNavigator;
import de.effectivecompany.gui.constants.EFCPredefinedMenu;
import de.effectivecompany.gui.events.ActivitiChangedEvent;
import de.effectivecompany.gui.events.DcShutdownReminderEvent;
import de.effectivecompany.gui.events.TAPIEvent;
import de.effectivecompany.gui.events.TextMsgEvent;
import de.effectivecompany.gui.events.util.EFCEventBus;
import de.effectivecompany.gui.factory.EFCPanelSingleton;
import de.effectivecompany.gui.interfaces.handler.ActionHandler;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.manager.EFCPropertyManager;
import de.effectivecompany.gui.util.EFCThreadUtil;
import de.effectivecompany.tapimon.TAPIEventData;
import groovy.lang.Binding;
import impl.org.controlsfx.skin.NotificationBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyVetoException;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ToolBar;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Screen;
import javafx.util.Duration;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import org.controlsfx.control.Notifications;

public class EFCMainPanel
extends JPanel {
    public static final long serialVersionUID = -154745L;
    private EFCStatusBar statusbar;
    private SvSysApp svSysApp = (SvSysApp)SpringHelper.getService(SvSysApp.class);
    private JInternalFrame iframe;
    private EFCActionWindowLock windowLockAction;
    private EFCHasWorkflowService hasWorkFlowService;
    private EFCMainMenu menu = new EFCMainMenu(EFCPredefinedMenu.P_MAINFRAME);
    MenuItem menuitem;
    boolean menuVisible = false;
    Timeline timeline = null;
    Label timerLabel = null;
    private Notification shutdownReminderNotification;
    private SysInfo sysInfo;

    public EFCMainPanel(ActionHandler parent) {
        this.setLayout(new BorderLayout());
        this.menu.setActionHandler(parent);
        this.hasWorkFlowService = new EFCHasWorkflowService();
        JPanel navigatorPanel = new JPanel(new BorderLayout());
        JFXPanel rootpanel = new JFXPanel();
        EFCFrameLayoutInfo posInfo = EFCPanelSingleton.getInstance().getFramePosition(EFCMainFrame.class.getSimpleName(), null);
        EFCNavigator.getInstance();
        Platform.runLater(() -> {
            BorderPane root = new BorderPane();
            ToolBar toolbar = new ToolBar();
            VBox top = new VBox();
            root.setTop((Node)top);
            root.setCenter((Node)EFCNavigator.getInstance());
            EFCAbstractAction abstractAction = new EFCActionExit();
            abstractAction.setActionHandler(parent);
            EFCFxButton exitButton = new EFCFxButton(abstractAction, EFCFxButton.ButtonState.TOOLBAR);
            exitButton.setTextInvisible(true);
            abstractAction = new EFCActionCalculator();
            abstractAction.setActionHandler(parent);
            EFCFxButton calcButton = new EFCFxButton(abstractAction, EFCFxButton.ButtonState.TOOLBAR);
            calcButton.setTextInvisible(true);
            abstractAction = new EFCActionHelp();
            abstractAction.setActionHandler(parent);
            EFCFxButton helpButton = new EFCFxButton(abstractAction, EFCFxButton.ButtonState.TOOLBAR);
            helpButton.setTextInvisible(true);
            this.windowLockAction = new EFCActionWindowLock();
            this.windowLockAction.setActionHandler(parent);
            EFCFxButton button = new EFCFxButton(this.windowLockAction, EFCFxButton.ButtonState.TOOLBAR);
            button.setTextInvisible(true);
            top.getChildren().add((Object)toolbar);
            toolbar.getItems().addAll((Object[])new Node[]{exitButton, calcButton, helpButton, button});
            if (posInfo != null) {
                this.windowLockAction.setIsSelected(true);
            }
            rootpanel.setScene(new Scene((Parent)root));
        });
        navigatorPanel.add((Component)rootpanel);
        EFCDesktop desktop = EFCDesktop.getInstance();
        this.iframe = new JInternalFrame(Translator.tr((String)"FRAME_TITLE_NAVIGATOR"));
        this.iframe.setContentPane(navigatorPanel);
        this.iframe.setMinimumSize(new Dimension(140, 200));
        this.iframe.setSize(EFCLookAndFeelManager.SIZE_FRAME_NAVIGATOR);
        this.iframe.setVisible(true);
        this.iframe.setClosable(false);
        this.iframe.setResizable(true);
        this.iframe.setMaximizable(false);
        this.iframe.setIconifiable(false);
        this.iframe.setFrameIcon(EFCLookAndFeelManager.ICON_APP_WUG);
        this.iframe.addInternalFrameListener(EFCNavigator.getInstance());
        this.add((Component)desktop, "Center");
        if (posInfo != null) {
            Dimension dim = new Dimension(posInfo.getWidth(), posInfo.getHeight());
            this.iframe.setSize(dim);
            this.iframe.setPreferredSize(dim);
            this.iframe.setLocation(posInfo.getLocationX(), posInfo.getLocationY());
        }
        desktop.add(this.iframe);
        this.statusbar = EFCLookAndFeelManager.IS_TEST_VERSION ? new EFCStatusBar(6, EFCPanelSingleton.getInstance().getIsShowProgressBar()) : new EFCStatusBar(5, EFCPanelSingleton.getInstance().getIsShowProgressBar());
        JFXPanel panel = new JFXPanel();
        panel.setScene(new Scene((Parent)this.statusbar));
        this.add((Component)panel, "South");
        JFXPanel panel1 = new JFXPanel();
        VBox top = new VBox();
        top.getChildren().add((Object)this.menu);
        panel1.setScene(new Scene((Parent)top));
        this.add((Component)panel1, "North");
        EFCThreadUtil.fatBuilder(th -> th.doOutside(() -> {
            this.sysInfo = this.svSysApp.getSysInfoForLogin();
            th.fat(() -> {
                this.statusbar.setStatusText("Versionen: CL: 3.3.08-07.05 SV: " + this.sysInfo.getAppServerVersion() + " DB: " + this.sysInfo.getDatabaseVersion());
                Properties props = EFCPropertyManager.getClientProperties();
                if (props != null) {
                    this.statusbar.setStatusText(this.sysInfo.getAppServerHostName() + props.getProperty("efcserver.contextPath", "/"), 1);
                }
                this.statusbar.setStatusText("Datenbank: " + this.sysInfo.getDatabaseName() + " (" + this.sysInfo.getDatabaseProductName() + " " + this.sysInfo.getDatabaseProductVersion() + ") ", 2);
                this.statusbar.setStatusText("Login: " + this.sysInfo.getEfcUserName(), 3);
            });
        }));
        if (EFCDesktop.getCompany() != null && !EFCDesktop.getCompany().isEmpty()) {
            this.statusbar.setStatusText("Firma: " + EFCDesktop.getCompany(), 4);
        } else {
            this.statusbar.setStatusText("alle Firmen", 4);
        }
        if (EFCLookAndFeelManager.IS_TEST_VERSION) {
            this.statusbar.setStatusText("TEST VERSION", 5, Color.RED);
        }
        EFCThreadUtil.doLater(() -> {
            try {
                this.iframe.setSelected(true);
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
            }
        });
        if (!EFCNavigator.getInstance().startTerminalFrame()) {
            final SvBoWflProcDef processes = (SvBoWflProcDef)SpringHelper.getBean((String)"syswfl_SvBoWflProcDef");
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (processes.hasWorkflow().getData().booleanValue()) {
                        EFCMainPanel.this.add((Component)WflController.getInstance().getFxpanel(), "East");
                        EFCMainPanel.this.hasWorkFlowService.startService();
                    }
                }
            });
            EFCEventBus.getInstance().register(this);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onActivitiChangedEvent(ActivitiChangedEvent event) {
        try {
            if (!event.getData().getEventType().getData().equals("SYS_WFL_PARAM_UPDATED")) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        EFCMainPanel.this.hasWorkFlowService.startService();
                    }
                });
            }
        }
        catch (ApplicationException ae) {
            EFCDesktop.reportError(ae);
        }
        catch (Throwable th) {
            EFCDesktop.reportError(th);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onTextMsgEvent(TextMsgEvent event) {
        Platform.runLater(() -> this.showUpdateNotification(event.getData()));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onTAPIEvent(TAPIEvent event) {
        Platform.runLater(() -> this.showTAPINotification(event.getData()));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onDcShutdownReminderEvent(DcShutdownReminderEvent event) {
        Platform.runLater(() -> this.showDcShutdownReminder(event.getData()));
    }

    private void showUpdateNotification(TextMsg msg) {
        ImageView icon = new ImageView(EFCLookAndFeelManager.ICON_APP_SENDMSG_FX);
        icon.setFitWidth(64.0);
        icon.setFitHeight(64.0);
        Duration hiderAfter = Duration.seconds((double)5.0);
        if (msg.getSticky().getData().booleanValue()) {
            hiderAfter = Duration.INDEFINITE;
        }
        Notifications.create().title("EFC Nachricht von " + msg.getSenderName().getData()).text(msg.getText().getData()).graphic((Node)icon).position(Pos.BOTTOM_RIGHT).hideAfter(hiderAfter).onAction(this::onTextNotificationClicked).show();
    }

    private void showTAPINotification(TAPIEventData msg) {
        Notifications.create().title("Anruf von: " + msg.getIncommingID()).text(" ").graphic((Node)new EFCTAPIEventDataNotificationPane(msg)).position(Pos.BOTTOM_RIGHT).hideAfter(Duration.INDEFINITE).onAction(this::onTAPINotificationClicked).show();
    }

    private void showDcShutdownReminder(DcShutdownReminder msg) {
        if (this.shutdownReminderNotification == null && msg.getShutdowntime().getData() != null) {
            this.timerLabel = new Label();
            this.timerLabel.setPrefSize(200.0, 100.0);
            this.createTimer(this.timerLabel, msg);
            try {
                this.shutdownReminderNotification = Notification.create().title("Serverneustart in:").graphic((Node)this.timerLabel).position(Pos.BOTTOM_RIGHT).owner(Screen.getPrimary()).onAction(null).hideAfter(null).hideCloseButton();
                this.shutdownReminderNotification.show();
            }
            catch (Throwable throwable) {}
        } else if (this.shutdownReminderNotification != null && msg.getShutdowntime().getData() == null) {
            this.shutdownReminderNotification.hide();
            this.shutdownReminderNotification = null;
        } else {
            this.createTimer(this.timerLabel, msg);
        }
    }

    private void createTimer(Label timerLabel, DcShutdownReminder actMsg) {
        if (this.timeline != null) {
            this.timeline.stop();
        }
        this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1000.0), ae -> {
            if (actMsg.getShutdowntime().getData() != null) {
                long different = actMsg.getShutdowntime().getData() - new Date().getTime();
                if (different <= 0L) {
                    this.timeline.stop();
                    this.timeline = null;
                    this.shutdownReminderNotification.hide();
                    this.shutdownReminderNotification = null;
                } else {
                    long secondsInMilli = 1000L;
                    long minutesInMilli = secondsInMilli * 60L;
                    long hoursInMilli = minutesInMilli * 60L;
                    long daysInMilli = hoursInMilli * 24L;
                    long elapsedHours = (different %= daysInMilli) / hoursInMilli;
                    long elapsedMinutes = (different %= hoursInMilli) / minutesInMilli;
                    long elapsedSeconds = (different %= minutesInMilli) / secondsInMilli;
                    timerLabel.setText(elapsedHours + " Std " + elapsedMinutes + " Min " + elapsedSeconds + " Sek\n" + actMsg.getMessage().getData());
                }
            }
        }, new KeyValue[0])});
        this.timeline.setCycleCount(-1);
        this.timeline.play();
    }

    private void onTextNotificationClicked(ActionEvent event) {
    }

    private void onTAPINotificationClicked(ActionEvent event) {
        if (event.getSource() instanceof NotificationBar && ((NotificationBar)event.getSource()).getGraphic() instanceof EFCTAPIEventDataNotificationPane) {
            EFCTAPIEventDataNotificationPane notification = (EFCTAPIEventDataNotificationPane)((NotificationBar)event.getSource()).getGraphic();
            HashMap<String, TAPIEventData> bindings = new HashMap<String, TAPIEventData>();
            bindings.put("tapiEvent", notification.getTapiEventData());
            Binding binding = new Binding(bindings);
            XciActions.executeXciEvent(null, binding, "EFCMainPanel", "onTAPINotificationClicked");
            EFCThreadUtil.fatBuilder(th -> th.doOutside(() -> this.svSysApp.getSoTapiResultIncomingCall(notification.getTapiEventData().getIncommingID())));
        }
    }

    public EFCMainMenu getMenu() {
        return this.menu;
    }

    public JInternalFrame getNavigatorFrame() {
        return this.iframe;
    }

    public EFCStatusBar getStatusBar() {
        return this.statusbar;
    }

    public SysInfo getSysInfo() {
        return this.sysInfo;
    }
}

