/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.root;

import de.effectivecompany.app.app.service.SvSysUser;
import de.effectivecompany.app.sys.DcMdSysMenu;
import de.effectivecompany.app.sys.DcMdSysMenuItem;
import de.effectivecompany.app.sys.MdSysMenuItem;
import de.effectivecompany.app.sys.MdSysProg;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.frame.EFCMenuFavouriteInfo;
import de.effectivecompany.gui.components.fx.EFCMenuFavouriteItem;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.components.root.EFCMainFrame;
import de.effectivecompany.gui.factory.EFCPanelSingleton;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import javax.swing.JOptionPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCNavigator
extends BorderPane
implements InternalFrameListener {
    private static Logger logger = LoggerFactory.getLogger(EFCNavigator.class);
    public static final long serialVersionUID = -162445522L;
    private TextField quickstart = new TextField();
    private TreeItem<Leaf> rootNode;
    private TreeView<Leaf> tree;
    private Map<String, ExecProg> execSysProgs = new HashMap<String, ExecProg>();
    private boolean isInfoModus;
    private static EFCNavigator instance;
    private SvSysUser svSysUsr = (SvSysUser)SpringHelper.getService(SvSysUser.class);

    public static EFCNavigator getInstance() {
        if (instance == null) {
            instance = new EFCNavigator(false);
            instance.createMenu(null);
        }
        return instance;
    }

    public static EFCNavigator getInfoView(String menuName) {
        EFCNavigator navigator = new EFCNavigator(true);
        navigator.createMenu(menuName);
        return navigator;
    }

    private void attachSubMenu(DcMdSysMenu actMenu, TreeItem<Leaf> parent, String key) {
        logger.debug("creating submenu: " + key);
        for (DcMdSysMenuItem item : actMenu.getSys_menuitemList()) {
            TreeItem childTree;
            Leaf child;
            if (item.getSys_menu() != null) {
                child = new Leaf(item.getStext().toString());
                childTree = new TreeItem((Object)child);
                parent.getChildren().add((Object)childTree);
                this.attachSubMenu(item.getSys_menu(), (TreeItem<Leaf>)childTree, item.getMenucode().toString());
                continue;
            }
            if (item.getSysprog().optainValue() != null) {
                this.attachProgram(parent, item.getSysprog().toString(), (MdSysMenuItem)item);
                continue;
            }
            logger.warn("attaching item to menu: " + key + " with no Funktion: " + item.getMenucode().toString());
            child = new Leaf(item.getStext().toString());
            childTree = new TreeItem((Object)child);
            parent.getChildren().add((Object)childTree);
        }
    }

    public boolean startTerminalFrame() {
        Leaf leaf;
        if (this.rootNode.getChildren().size() == 1 && !(leaf = (Leaf)((TreeItem)this.rootNode.getChildren().get(0)).getValue()).getSysProg().isEmpty()) {
            ExecProg prog = this.execSysProgs.get(leaf.getSysProg());
            this.launchSelectedProgram(prog);
            return true;
        }
        return false;
    }

    private void attachProgram(TreeItem<Leaf> parent, String key, MdSysMenuItem item) {
        ExecProg prog = this.execSysProgs.get(key);
        String stext = "NULL";
        if (item.getStext() != null) {
            stext = item.getStext().toString();
        }
        if (prog != null) {
            Image icon = prog.getIcon();
            try {
                logger.debug("attaching menu item (" + key + ") with executable program: " + key);
                Leaf progLeaf = new Leaf(stext, icon, key);
                TreeItem progItem = new TreeItem((Object)progLeaf);
                parent.getChildren().add((Object)progItem);
            }
            catch (NoClassDefFoundError err) {
                JOptionPane.showMessageDialog(null, "Class not defined:" + err.getMessage(), "Menu Load Error", 0);
            }
        } else {
            logger.warn("attaching menu item (" + key + ") with no Funktion: " + stext);
        }
    }

    private EFCNavigator(boolean infoModus) {
        this.createProgs();
        this.isInfoModus = infoModus;
        if (!this.isInfoModus) {
            this.quickstart = new TextField();
            this.quickstart.setOnKeyPressed(event -> {
                if (event.getCode() == KeyCode.ENTER) {
                    String searchText = this.quickstart.getText().toUpperCase();
                    ExecProg execProg = this.execSysProgs.get(searchText);
                    if (execProg != null) {
                        this.launchSelectedProgram(execProg);
                    } else {
                        JOptionPane.showMessageDialog(EFCDesktop.getInstance(), Translator.tr((String)"MSG_NAVIGATOR_PROGRAM_NOT_FOUND"));
                    }
                    this.quickstart.setText("");
                }
            });
            this.setTop((Node)this.quickstart);
        }
    }

    private ImageView checkImageViewScale(ImageView view) {
        if (view != null && EFCLookAndFeelManager.SIZE_MULTIPLIER != 1.0) {
            view.setScaleX(EFCLookAndFeelManager.SIZE_MULTIPLIER);
            view.setScaleY(EFCLookAndFeelManager.SIZE_MULTIPLIER);
        }
        return view;
    }

    public void updateInfoView(String menuName) {
        this.createMenu(menuName);
    }

    public void launchSelectedProgram(ExecProg execProg) {
        EFCThreadUtil.doLater(() -> this.launchProgram(execProg.getClazz(), execProg.getParam()));
    }

    public void launchSelectedProgram(ExecProg execProg, Map<String, Object> params) {
        EFCThreadUtil.doLater(() -> this.launchProgram(execProg.getClazz(), params));
    }

    public Object launchProgram(Class<?> clazz, Map<String, Object> param) {
        Object result = null;
        if (clazz != null) {
            try {
                logger.debug("creation started...");
                Constructor<?> con = clazz.getConstructor(Map.class);
                result = con.newInstance(param);
                logger.debug("creation finished...");
            }
            catch (Exception ex) {
                EFCDesktop.reportError(ex);
                ex.printStackTrace();
            }
        } else {
            JOptionPane.showMessageDialog(EFCDesktop.getInstance(), Translator.tr((String)"MSG_NAVIGATOR_PROGRAM_NOT_FOUND"));
        }
        return result;
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent event) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EFCNavigator.this.quickstart.requestFocus();
            }
        });
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent event) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent event) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent event) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent event) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent event) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent event) {
    }

    private void createMenu(final String menuName) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EFCNavigator.this.rootNode = new TreeItem((Object)new Leaf("effective company"));
                EFCNavigator.this.rootNode.setExpanded(true);
                EFCNavigator.this.tree = new TreeView(EFCNavigator.this.rootNode);
                EFCNavigator.this.tree.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<TreeItem<Leaf>>(){

                    public void changed(ObservableValue<? extends TreeItem<Leaf>> observable, TreeItem<Leaf> oldValue, TreeItem<Leaf> newValue) {
                        if (newValue != null && newValue.getValue() instanceof Leaf && ((Leaf)newValue.getValue()).getSysProg() != null) {
                            Leaf selected = (Leaf)newValue.getValue();
                            EFCNavigator.this.quickstart.setText(selected.sysProg);
                        } else {
                            EFCNavigator.this.quickstart.setText("");
                        }
                    }
                });
                EFCNavigator.this.tree.setOnKeyPressed(e -> {
                    TreeItem item = (TreeItem)EFCNavigator.this.tree.getSelectionModel().getSelectedItem();
                    if (item != null && item.isLeaf() && ((Leaf)item.getValue()).getSysProg() != null && e.getCode() == KeyCode.ENTER) {
                        Leaf selected = (Leaf)item.getValue();
                        ExecProg execProg = EFCNavigator.this.execSysProgs.get(selected.getSysProg());
                        EFCNavigator.this.launchSelectedProgram(execProg);
                    }
                });
                EFCNavigator.this.tree.setCellFactory((Callback)new Callback<TreeView<Leaf>, TreeCell<Leaf>>(){

                    public TreeCell<Leaf> call(TreeView<Leaf> param) {
                        return new EFCNavigatorTreeCellImpl();
                    }
                });
                EFCNavigator.this.setCenter((Node)EFCNavigator.this.tree);
                String newMenu = menuName;
                if (menuName == null || menuName.isEmpty()) {
                    newMenu = EFCNavigator.this.svSysUsr.getUsrMenuName().getData();
                }
                logger.info("creating menu: " + newMenu);
                EFCNavigator.this.attachSubMenu(EFCNavigator.this.svSysUsr.getMdSysMenuTree(newMenu), EFCNavigator.this.rootNode, newMenu);
            }
        });
    }

    private void createProgs() {
        EFCList items = this.svSysUsr.getMdSysProgList();
        for (MdSysProg prog : items) {
            try {
                ExecProg execProg = new ExecProg(prog);
                logger.debug("adding sysProg with key " + prog.getSysprog().toString());
                this.execSysProgs.put(prog.getSysprog().toString(), execProg);
            }
            catch (ClassNotFoundException ex) {
                logger.warn("program not found: " + ex.getMessage());
            }
            catch (NoClassDefFoundError err) {
                JOptionPane.showMessageDialog(null, "Class not defined:" + err.getMessage(), "Menu Load Error", 0);
            }
        }
    }

    public ExecProg getProgram(String progName) {
        if (this.execSysProgs != null && !this.execSysProgs.isEmpty()) {
            return this.execSysProgs.get(progName);
        }
        return null;
    }

    private final class EFCNavigatorTreeCellImpl
    extends TreeCell<Leaf> {
        public EFCNavigatorTreeCellImpl() {
            this.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && event.getButton() == MouseButton.PRIMARY && event.getSource() != null && event.getSource() instanceof TreeCell && ((TreeCell)event.getSource()).getItem() instanceof Leaf && ((Leaf)((TreeCell)event.getSource()).getItem()).getSysProg() != null) {
                    Leaf selected = (Leaf)((TreeCell)event.getSource()).getItem();
                    ExecProg execProg = EFCNavigator.this.execSysProgs.get(selected.getSysProg());
                    EFCNavigator.this.launchSelectedProgram(execProg);
                }
            });
            this.setFont(EFCLookAndFeelManager.FONT_NAVIGATOR);
        }

        private ContextMenu createContextMenu(Leaf cell) {
            ContextMenu cm = new ContextMenu();
            MenuItem addMenuFavItem = new MenuItem(Translator.tr((String)"ACTION_ADD_MENUFAVOURITE"));
            addMenuFavItem.setOnAction(event -> {
                Leaf file = cell;
                if (file != null) {
                    EFCMenuFavouriteInfo favourite = new EFCMenuFavouriteInfo(cell.getSysProg(), cell.getTitle(), EFCMainFrame.class.getSimpleName());
                    favourite.setUuid(UUID.randomUUID().toString());
                    int size = EFCMainFrame.getInstance().getPanel().getMenu().getMenuFavourite().getItems().stream().filter(i1 -> {
                        if (i1 instanceof EFCMenuFavouriteItem && ((EFCMenuFavouriteItem)((Object)((Object)i1))).getAction() != null) {
                            return ((EFCMenuFavouriteItem)((Object)((Object)i1))).getAction().getInfo() != null;
                        }
                        return false;
                    }).collect(Collectors.toList()).size();
                    favourite.setOrder(size + 1);
                    EFCPanelSingleton.getInstance().setMenuFavourite(EFCMainFrame.class.getSimpleName(), favourite);
                }
            });
            cm.getItems().add((Object)addMenuFavItem);
            return cm;
        }

        public void updateItem(Leaf item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                TreeItem treeItem = this.getTreeItem();
                if (!treeItem.isLeaf()) {
                    if (treeItem.isExpanded()) {
                        this.setGraphic((Node)EFCNavigator.this.checkImageViewScale(new ImageView(EFCLookAndFeelManager.ICON_MENU_FOLDER_OPENED)));
                    } else {
                        this.setGraphic((Node)EFCNavigator.this.checkImageViewScale(new ImageView(EFCLookAndFeelManager.ICON_MENU_FOLDER_CLOSED)));
                    }
                } else {
                    if (((Leaf)treeItem.getValue()).getIcon() != null) {
                        this.setGraphic((Node)EFCNavigator.this.checkImageViewScale(new ImageView(((Leaf)treeItem.getValue()).getIcon())));
                    }
                    if (((Leaf)treeItem.getValue()).getSysProg() != null) {
                        this.setContextMenu(this.createContextMenu((Leaf)treeItem.getValue()));
                    }
                }
                this.setText(((Leaf)treeItem.getValue()).getTitle());
            }
        }
    }

    public static class ExecProg {
        private Class<?> clazz;
        private Map<String, Object> param;
        private MdSysProg mdSysProg;
        private Image icon;

        public ExecProg(MdSysProg prog) throws ClassNotFoundException {
            this.mdSysProg = prog;
            Object className = "";
            if (prog.getSysprogcode() != null) {
                className = "de.effectivecompany.client.forms." + prog.getSysprogcode().toString();
            }
            this.clazz = Class.forName((String)className, false, this.getClass().getClassLoader());
            String code = "";
            if (prog.getCode() != null) {
                code = prog.getCode().toString();
            }
            this.param = new HashMap<String, Object>();
            String[] params = code.split(",");
            for (int i = 0; i < params.length; ++i) {
                String[] valgroup = params[i].split("=", 2);
                if (valgroup.length == 2) {
                    this.param.put(valgroup[0].trim(), valgroup[1].trim());
                    logger.debug("parameter added: '" + valgroup[0].trim() + "':'" + valgroup[1].trim() + "'");
                    continue;
                }
                logger.debug("MENU: parameter ignored: " + params[i]);
            }
            switch (prog.getSysprogtype().getIntValue()) {
                case 0: {
                    this.icon = EFCLookAndFeelManager.ICON_MENU_LEAF;
                    break;
                }
                case 10: {
                    this.icon = EFCLookAndFeelManager.ICON_MENU_LEAF_MASTER;
                    break;
                }
                case 20: {
                    this.icon = EFCLookAndFeelManager.ICON_MENU_LEAF_STATISTIC;
                    break;
                }
                case 30: {
                    this.icon = EFCLookAndFeelManager.ICON_MENU_LEAF_INFO;
                    break;
                }
                case 40: {
                    this.icon = EFCLookAndFeelManager.ICON_MENU_LEAF_TRANSACTION;
                    break;
                }
                case 45: {
                    this.icon = EFCLookAndFeelManager.ICON_MENU_LEAF_WORKFLOW;
                    break;
                }
                case 50: {
                    this.icon = EFCLookAndFeelManager.ICON_MENU_LEAF_CHECKLIST;
                    break;
                }
                case 60: {
                    this.icon = EFCLookAndFeelManager.ICON_MENU_LEAF_TERMINAL;
                    break;
                }
                case 70: {
                    this.icon = EFCLookAndFeelManager.ICON_MENU_LEAF_EXTERNAL;
                    break;
                }
                case 71: {
                    this.icon = EFCLookAndFeelManager.ICON_MENU_LEAF_EXTERNAL_EXE;
                    break;
                }
                case 72: {
                    this.icon = EFCLookAndFeelManager.ICON_MENU_LEAF_EXTERNAL_OFFICE;
                    break;
                }
                case 73: {
                    this.icon = EFCLookAndFeelManager.ICON_MENU_LEAF_EXTERNAL_STATISTIC;
                }
            }
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public Map<String, Object> getParam() {
            return this.param;
        }

        public MdSysProg getMdSysProg() {
            return this.mdSysProg;
        }

        public Image getIcon() {
            return this.icon;
        }
    }

    public class Leaf {
        private int alias;
        private String title;
        private String sysProg;
        private Image icon;

        public Leaf(String title) {
            this.title = title;
        }

        public Leaf(String title, Image icon, String sysProg) {
            this.title = title;
            this.icon = icon;
            this.sysProg = sysProg;
        }

        public String getTitle() {
            return this.title;
        }

        public Image getIcon() {
            return this.icon;
        }

        public String getSysProg() {
            return this.sysProg;
        }

        public int getAlias() {
            return this.alias;
        }
    }
}

