/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.swing;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import de.effectivecompany.base.datatypes.EFCPercent;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.base.meta.ColorInfo;
import de.effectivecompany.base.util.ObjectUtil2;
import de.effectivecompany.gui.components.editor.EFCAbstractPrimaryEditor;
import de.effectivecompany.gui.components.editor.EFCLabel;
import de.effectivecompany.gui.components.panel.EFCFormPanel;
import de.effectivecompany.gui.data.BusinessObjectModel;
import de.effectivecompany.gui.factory.EFCPanelSingleton;
import de.effectivecompany.gui.interfaces.element.EditorComponent;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;

public class EFCBoCellComponent
extends JPanel {
    private JPanel panel;
    private static final long serialVersionUID = 5214201319042060346L;
    private boolean valueSet;
    private boolean firstRun = true;
    private double sizeMultiplier;
    private boolean onlyLabels;

    public boolean isValueSet() {
        return this.valueSet;
    }

    public void setValueSet(boolean valueSet) {
        this.valueSet = valueSet;
    }

    public EFCBoCellComponent(String cellLayout, BusinessObject businessObject, double sizeMultiplier, boolean onlyLabels) {
        this.setLayout(new BorderLayout());
        this.sizeMultiplier = sizeMultiplier;
        this.onlyLabels = onlyLabels;
        if (businessObject != null) {
            this.panel = EFCPanelSingleton.getInstance().generateTableCellPanel(cellLayout, businessObject.getClass(), new BusinessObjectModel(businessObject), null);
            this.add((Component)this.panel, "Center");
        }
        this.valueSet = false;
    }

    public void updateData(BusinessObject businessObject, boolean isSelected, JTable table) {
        if (!this.isValueSet()) {
            if (this.panel != null) {
                for (Component compo : this.panel.getComponents()) {
                    if (!(compo instanceof EditorComponent)) continue;
                    String ident = ((EditorComponent)((Object)compo)).getIdent();
                    ((EditorComponent)((Object)compo)).setValue(ObjectUtil2.getAttributeByDomainName((String)ident, (Object)businessObject));
                    if (!(compo instanceof EFCAbstractPrimaryEditor)) continue;
                    EFCAbstractPrimaryEditor editor = (EFCAbstractPrimaryEditor)compo;
                    if (editor.getInfotextComponent() != null) {
                        String infoIdent = ((EFCLabel)((EFCAbstractPrimaryEditor)compo).getInfotextComponent()).getIdent();
                        ((EFCLabel)editor.getInfotextComponent()).setText(ObjectUtil2.getAttributeByDomainName((String)infoIdent, (Object)businessObject).toString());
                        if (this.firstRun) {
                            editor.getInfotextComponent().setFont(editor.getInfotextComponent().getFont().deriveFont((float)((double)editor.getInfotextComponent().getFont().getSize() * this.sizeMultiplier)));
                        }
                    }
                    if (businessObject != null && businessObject instanceof ColorInfo) {
                        ColorInfo colorInfo = (ColorInfo)businessObject;
                        for (Component co : this.panel.getComponents()) {
                            co.setBackground(colorInfo.getColor());
                        }
                        Color identColor = colorInfo.getAttrColor(editor.getIdent());
                        if (identColor != null && editor.getEditorComponent() != null) {
                            editor.getEditorComponent().setBackground(identColor);
                        }
                    }
                    if (editor.getIdent().equals("disposability") && editor.getValue() != null) {
                        EFCPercent value = (EFCPercent)editor.getValue();
                        if (editor.getInfotextComponent() != null) {
                            editor.getInfotextComponent().setOpaque(true);
                        }
                        Color background = value.getData() != null && value.getData() >= 90.0 ? Color.GREEN : (value.getData() != null && value.getData() >= 50.0 ? Color.YELLOW : EFCLookAndFeelManager.COLOR_INFOTEXT_BACKGROUND);
                        for (Component co : this.panel.getComponents()) {
                            co.setBackground(background);
                        }
                    }
                    if (!this.firstRun) continue;
                    if (editor.getLinkedLabel() != null) {
                        editor.getLinkedLabel().setFont(editor.getLinkedLabel().getFont().deriveFont((float)((double)editor.getLinkedLabel().getFont().getSize() * this.sizeMultiplier)));
                    }
                    editor.setEditorSizing((int)((double)editor.getEditorSizing() * this.sizeMultiplier));
                    if (this.onlyLabels) {
                        editor.setEditorSizing(0);
                        editor.setEditorComponent(null);
                        if (editor.getInfotextComponent() != null) {
                            ((JLabel)editor.getInfotextComponent()).setForeground(Color.BLACK);
                        }
                    } else {
                        editor.getEditorComponent().setFont(editor.getEditorComponent().getFont().deriveFont((float)((double)editor.getEditorComponent().getFont().getSize() * this.sizeMultiplier)));
                    }
                    editor.reorganize();
                }
            }
            if (this.firstRun && this.panel != null && this.panel instanceof EFCFormPanel) {
                String startCode;
                String code;
                int i;
                EFCFormPanel formPanel = (EFCFormPanel)this.panel;
                for (i = 1; i <= ((FormLayout)formPanel.getLayout()).getColumnCount(); ++i) {
                    ColumnSpec spec = ((FormLayout)formPanel.getLayout()).getColumnSpec(i);
                    startCode = code = spec.encode();
                    if (!Pattern.matches("\\d+", code)) {
                        code = code.replaceAll("\\D+", "");
                    }
                    int size = (int)((double)Integer.parseInt(code) * this.sizeMultiplier);
                    startCode = startCode.replaceAll("\\d+", "" + size);
                    ((FormLayout)formPanel.getLayout()).setColumnSpec(i, ColumnSpec.decode((String)startCode));
                }
                for (i = 1; i <= ((FormLayout)formPanel.getLayout()).getRowCount(); ++i) {
                    RowSpec spec = ((FormLayout)formPanel.getLayout()).getRowSpec(i);
                    startCode = code = spec.encode();
                    if (!Pattern.matches("\\d+", code)) {
                        code = code.replaceAll("\\D+", "");
                    }
                    int size = (int)((double)Integer.parseInt(code) * this.sizeMultiplier);
                    startCode = startCode.replaceAll("\\d+", "" + size);
                    ((FormLayout)formPanel.getLayout()).setRowSpec(i, RowSpec.decode((String)startCode));
                }
            }
            this.firstRun = false;
            this.valueSet = true;
        }
        if (businessObject != null && businessObject instanceof ColorInfo) {
            this.panel.setBackground(((ColorInfo)businessObject).getColor() == null ? null : (((ColorInfo)businessObject).getColor().equals(Color.WHITE) ? EFCLookAndFeelManager.COLOR_INFOTEXT_BACKGROUND : ((ColorInfo)businessObject).getColor()));
        } else {
            this.panel.setBackground(EFCLookAndFeelManager.COLOR_INFOTEXT_BACKGROUND);
        }
        if (isSelected) {
            this.setBorder(BorderFactory.createLineBorder(table.getSelectionBackground(), 3));
        } else {
            this.setBorder(null);
            this.setBackground(EFCLookAndFeelManager.COLOR_INFOTEXT_BACKGROUND);
        }
    }

    public JPanel getBoCellComponent() {
        return this.panel;
    }
}

