/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.swing;

import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.msg.Msg;
import de.effectivecompany.base.msg.MsgType;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.UnitConverter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class EFCMessageListDialog
extends JDialog {
    private static final long serialVersionUID = -7881805294996782434L;
    private JTable messageTable = new JTable();
    private JScrollPane commentScroll;
    private JScrollPane detailScroll;
    private JTextArea commentArea = new JTextArea();
    private JTextArea detailArea = new JTextArea();
    private JPanel buttonBar = new JPanel(new FlowLayout(1));
    private JPanel contentPanel = new JPanel(new BorderLayout());
    private MessageListModel listModel = new MessageListModel();
    private int dividerLocation = 140;

    public EFCMessageListDialog(Frame parentFrame, boolean withDetails) {
        super(parentFrame);
        this.setTitle(Translator.tr((String)"DLG_TITLE_MESSAGELIST"));
        this.setVisible(false);
        this.setSize(UnitConverter.sizeFromDLU(EFCLookAndFeelManager.SIZE_DIALOG_MESSAGELIST, EFCDesktop.getInstance()));
        this.setContentPane(this.contentPanel);
        this.createTextArea(this.commentArea);
        this.createTextArea(this.detailArea);
        this.createButtonBar();
        this.createContentPanel(withDetails);
        this.setModal(true);
    }

    public EFCMessageListDialog(Dialog parentFrame, boolean withDetails) {
        super(parentFrame);
        this.setTitle(Translator.tr((String)"DLG_TITLE_MESSAGELIST"));
        this.setVisible(false);
        this.setSize(UnitConverter.sizeFromDLU(EFCLookAndFeelManager.SIZE_DIALOG_MESSAGELIST, EFCDesktop.getInstance()));
        this.setContentPane(this.contentPanel);
        this.createTextArea(this.commentArea);
        this.createTextArea(this.detailArea);
        this.createButtonBar();
        this.createContentPanel(withDetails);
        this.setModal(true);
    }

    private void createContentPanel(boolean withDetails) {
        this.messageTable.setDefaultRenderer(Object.class, new MessageTableCellRenderer());
        JScrollPane tableScroll = new JScrollPane(this.messageTable);
        if (withDetails) {
            JSplitPane splitPane = new JSplitPane(0);
            this.contentPanel.add((Component)splitPane, "Center");
            this.commentScroll = new JScrollPane(this.commentArea);
            this.detailScroll = new JScrollPane(this.detailArea);
            splitPane.add(tableScroll);
            splitPane.setDividerLocation(this.dividerLocation);
            splitPane.add(this.createTabbbedPane());
            this.messageTable.getSelectionModel().setSelectionMode(0);
            this.messageTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    int selectedIndex = EFCMessageListDialog.this.messageTable.getSelectedRow();
                    if (selectedIndex == -1) {
                        EFCMessageListDialog.this.commentArea.setText("");
                        EFCMessageListDialog.this.detailArea.setText("");
                    } else {
                        TableModel model = EFCMessageListDialog.this.messageTable.getModel();
                        if (model instanceof MessageListModel) {
                            MessageListModel messageListModel = (MessageListModel)model;
                            int selectedModelIndex = EFCMessageListDialog.this.messageTable.convertRowIndexToModel(selectedIndex);
                            String commentSText = messageListModel.data.get(selectedModelIndex).getMsg();
                            String commentLText = messageListModel.data.get(selectedModelIndex).getHelp();
                            EFCMessageListDialog.this.commentArea.setText(commentSText + "\n" + commentLText);
                            EFCMessageListDialog.this.detailArea.setText("\nMessage # " + messageListModel.data.get(selectedModelIndex).getMsgNumber() + "\n" + messageListModel.data.get(selectedModelIndex).getDetailSource());
                        }
                    }
                }
            });
        } else {
            this.contentPanel.add((Component)tableScroll, "Center");
        }
        this.contentPanel.add((Component)this.buttonBar, "South");
    }

    private void createTextArea(JTextArea textArea) {
        textArea.setEditable(false);
        textArea.setFont(EFCLookAndFeelManager.FONT_FORM);
        textArea.setBorder(BorderFactory.createEmptyBorder());
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
    }

    private JTabbedPane createTabbbedPane() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add(Translator.tr((String)"DLG_TAB_TP_MSGDLG_COMMENT"), this.commentScroll);
        tabbedPane.add(Translator.tr((String)"DLG_TAB_TP_MSGDLG_DETAIL"), this.detailScroll);
        return tabbedPane;
    }

    private void createButtonBar() {
        this.buttonBar.removeAll();
        JButton okButton = new JButton(Translator.tr((String)"_OK"));
        okButton.setDefaultCapable(true);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EFCMessageListDialog.this.setVisible(false);
                EFCMessageListDialog.this.dispose();
            }
        });
        okButton.setSelected(true);
        okButton.requestFocusInWindow();
        this.buttonBar.add(okButton);
        JButton copyButton = new JButton(Translator.tr((String)"_COPY_TO_CLIPBOARD"));
        copyButton.setDefaultCapable(true);
        copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringBuilder builder = new StringBuilder();
                EFCMessageListDialog.this.listModel.getData().forEach(msg -> EFCMessageListDialog.this.append(builder, (TranslatedMessage)msg));
                Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
                clip.setContents(new StringSelection(builder.toString()), null);
            }
        });
        this.buttonBar.add(copyButton);
        JButton mailButton = new JButton(Translator.tr((String)"_SEND_ERROR_REPORT"));
        mailButton.setDefaultCapable(true);
        mailButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Class<?> clazz = Class.forName("de.effectivecompany.gui.util.MailTools", false, this.getClass().getClassLoader());
                    clazz.getMethod("createErrorMailDialog", List.class).invoke(null, EFCMessageListDialog.this.listModel.getMsgList());
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                    EFCDesktop.reportError(ex);
                }
            }
        });
        this.buttonBar.add(mailButton);
    }

    public void show(List<Msg> messages) {
        this.setVisible(false);
        Boolean isResort = false;
        for (Msg msg : messages) {
            if (msg.getType() != MsgType.ERROR) continue;
            isResort = true;
        }
        if (isResort.booleanValue()) {
            messages.sort(Comparator.comparing(Msg::getType).reversed());
        }
        this.listModel.setData(messages);
        this.messageTable.setModel(this.listModel);
        this.messageTable.getColumnModel().getColumn(1).setMaxWidth(80);
        if (messages.size() > 0) {
            this.messageTable.setRowSelectionInterval(0, 0);
        }
        if (this.getParent() != null) {
            this.setLocationRelativeTo(this.getParent());
        }
        this.setVisible(true);
        this.requestFocusInWindow();
    }

    private void append(StringBuilder builder, TranslatedMessage msg) {
        builder.append(msg.msgNumber);
        builder.append(System.getProperty("line.separator"));
        builder.append(msg.msg);
        builder.append(System.getProperty("line.separator"));
        builder.append(msg.help);
        builder.append(System.getProperty("line.separator"));
        builder.append(msg.detailSource);
        builder.append(System.getProperty("line.separator"));
        builder.append(System.getProperty("line.separator"));
    }

    @Override
    protected JRootPane createRootPane() {
        ActionListener keyActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EFCMessageListDialog.this.setVisible(false);
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane rootPane = new JRootPane();
        rootPane.registerKeyboardAction(keyActionListener, stroke, 2);
        return rootPane;
    }

    @Override
    public void dispose() {
        this.listModel = null;
        this.messageTable = null;
        this.detailScroll = null;
        this.detailArea = null;
        if (this.contentPanel != null) {
            this.contentPanel.removeAll();
        }
        this.contentPanel = null;
        this.commentScroll = null;
        this.commentArea = null;
        if (this.buttonBar != null) {
            this.buttonBar.removeAll();
        }
        this.buttonBar = null;
        super.dispose();
    }

    public class MessageTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 7675975711944923230L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            TranslatedMessage msgObj = EFCMessageListDialog.this.listModel.getData().get(row);
            if (msgObj instanceof TranslatedMessage) {
                TranslatedMessage msg = msgObj;
                if (msg.getMsgType().equals((Object)MsgType.FATAL) || msg.getMsgType().equals((Object)MsgType.ERROR)) {
                    component.setBackground(EFCLookAndFeelManager.COLOR_TABLE_MSG_ERROR);
                } else if (msg.getMsgType().equals((Object)MsgType.WARNING)) {
                    component.setBackground(EFCLookAndFeelManager.COLOR_TABLE_MSG_WARNING);
                } else if (msg.getMsgType().equals((Object)MsgType.INFO)) {
                    component.setBackground(EFCLookAndFeelManager.COLOR_TABLE_MSG_INFO);
                }
                table.setSelectionForeground(Color.BLACK);
            }
            this.setFont(EFCLookAndFeelManager.FONT_TABLE_CELLS);
            this.setBorder(EFCLookAndFeelManager.TABLE_CELL_BORRDER_EMPTYBORDER);
            return this;
        }
    }

    private class TranslatedMessage {
        private String msg;
        private int msgNumber;
        private String help;
        private String detailSource;
        private MsgType msgType;

        public TranslatedMessage(String msg, int msgNumber, String help, String detailSource, MsgType msgType) {
            this.msg = msg;
            this.msgNumber = msgNumber;
            this.help = help;
            this.detailSource = detailSource;
            this.msgType = msgType;
        }

        public String getMsg() {
            return this.msg;
        }

        public int getMsgNumber() {
            return this.msgNumber;
        }

        public String getHelp() {
            return this.help;
        }

        public String getDetailSource() {
            return this.detailSource;
        }

        public MsgType getMsgType() {
            return this.msgType;
        }
    }

    private class MessageListModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 8530677783832932298L;
        private List<TranslatedMessage> data;
        private List<Msg> msgList;
        private String[] columns = new String[]{Translator.tr((String)"DLG_FLD_MSGDLG_COL_STEXT"), Translator.tr((String)"DLG_FLD_MSGDLG_COL_MSGNUM")};

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columns[column];
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            TranslatedMessage message = this.data.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return message.getMsg();
                }
                case 1: {
                    return message.getMsgNumber();
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public List<TranslatedMessage> getData() {
            return this.data;
        }

        public List<Msg> getMsgList() {
            return this.msgList;
        }

        public void setData(List<Msg> data) {
            this.msgList = data;
            this.data = new ArrayList<TranslatedMessage>();
            for (Msg msg : data) {
                this.data.add(new TranslatedMessage(msg.getMsg().getMsg(), msg.getMsg().getMsgNumber(), msg.getMsg().getHelp(), msg.getDetailSource(), msg.getType()));
            }
        }
    }
}

