/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.swing;

import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

public class EFCSmallToggleButton
extends JToggleButton
implements ItemListener {
    private static final long serialVersionUID = -6224973358447395945L;
    protected Border raised;
    protected Border lowered;

    public EFCSmallToggleButton(boolean selected, ImageIcon imgUnselected, ImageIcon imgSelected, String tip, boolean withBorder) {
        super(imgUnselected, selected);
        this.setHorizontalAlignment(0);
        this.setBorderPainted(true);
        if (withBorder) {
            this.raised = new BevelBorder(0);
            this.lowered = new BevelBorder(1);
            this.setBorder(selected ? this.lowered : this.raised);
        }
        this.setMargin(new Insets(1, 1, 1, 1));
        this.setToolTipText(tip);
        this.setRequestFocusEnabled(false);
        this.setSelectedIcon(imgSelected);
        this.addItemListener(this);
    }

    public EFCSmallToggleButton(boolean selected, ImageIcon imgUnselected, ImageIcon imgSelected, String tip, Action action, boolean withBorder) {
        super(action);
        this.setIcon(imgUnselected);
        this.setText("");
        this.setSelected(selected);
        this.setHorizontalAlignment(0);
        this.setBorderPainted(true);
        if (withBorder) {
            this.raised = new BevelBorder(0);
            this.lowered = new BevelBorder(1);
            this.setBorder(selected ? this.lowered : this.raised);
        }
        this.setMargin(new Insets(1, 1, 1, 1));
        this.setToolTipText(tip);
        this.setRequestFocusEnabled(false);
        this.setSelectedIcon(imgSelected);
        this.addItemListener(this);
    }

    @Override
    public float getAlignmentY() {
        return 0.5f;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.lowered != null && this.raised != null) {
            this.setBorder(this.isSelected() ? this.lowered : this.raised);
        }
    }
}

