/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.swing;

import de.effectivecompany.base.datatypes.EFCDate;
import de.effectivecompany.base.datatypes.EFCDateTime;
import de.effectivecompany.base.datatypes.EFCFloat;
import de.effectivecompany.base.datatypes.EFCInteger;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.datatypes.EFCOption;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.EFCController;
import de.effectivecompany.gui.components.edgeicon.EITextField;
import de.effectivecompany.gui.components.editor.EFCAbstractEditor;
import de.effectivecompany.gui.components.editor.EFCDateEditor;
import de.effectivecompany.gui.components.editor.EFCDateTimeEditor;
import de.effectivecompany.gui.components.editor.EFCFloatEditor;
import de.effectivecompany.gui.components.editor.EFCOptionEditor;
import de.effectivecompany.gui.components.editor.EFCStringEditor;
import de.effectivecompany.gui.components.model.CBEntry;
import de.effectivecompany.gui.components.model.MapComboBoxModel;
import de.effectivecompany.gui.components.model.table.EFCColumnModel;
import de.effectivecompany.gui.components.model.table.EFCTableColExt;
import de.effectivecompany.gui.components.model.table.ListTableModel;
import de.effectivecompany.gui.components.swing.ColumnFilterType;
import de.effectivecompany.gui.components.swing.EFCTableCellRenderer;
import de.effectivecompany.gui.interfaces.element.EditorComponent;
import de.effectivecompany.gui.interfaces.model.EFCTableModel;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jdesktop.swingx.JXTable;

public class EFCTable
extends JXTable {
    private static final long serialVersionUID = 6961840454365097728L;
    private EFCController controller;
    private String tableIdent;
    List<RowFilter<Object, Object>> filters = new ArrayList<RowFilter<Object, Object>>();

    public EFCTable() {
        this(null, null, null, null);
    }

    public EFCTable(TableModel tableModel, EFCController controller, EFCMap<String, Font> columnFonts) {
        this(tableModel, null, null, columnFonts);
        this.controller = controller;
    }

    public EFCTable(TableModel tableModel) {
        this(tableModel, null, null, null);
    }

    public EFCTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        this(tableModel, tableColumnModel, null, null);
    }

    public EFCTable(TableModel tableModel, TableColumnModel columnModel, ListSelectionModel listSelectionModel, EFCMap<String, Font> columnFonts) {
        super(tableModel, columnModel, listSelectionModel);
        this.putClientProperty("useDTCRColorMemoryHack", Boolean.FALSE);
        this.setHorizontalScrollEnabled(true);
        this.setEditable(false);
        this.setFocusable(true);
        this.setDefaultRenderer(Object.class, new EFCTableCellRenderer(columnFonts));
        this.getSelectionModel().setSelectionMode(0);
        this.setColumnControlVisible(true);
        this.setAutoCreateRowSorter(true);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(119, 0), "none");
        this.setSelectionBackground(Color.WHITE);
        this.setSelectionForeground(Color.BLACK);
        this.getTableHeader().addMouseListener(new ColumnListener(this));
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.getModel());
        this.setRowSorter(sorter);
        this.getTableHeader().addMouseListener(new MouseAdapter(){
            private SortOrder currentOrder = SortOrder.UNSORTED;

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    int column = EFCTable.this.getColumn(EFCTable.this.getTableHeader().columnAtPoint(e.getPoint())).getModelIndex();
                    RowSorter sorter = EFCTable.this.getRowSorter();
                    ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
                    switch (this.currentOrder) {
                        case UNSORTED: {
                            this.currentOrder = SortOrder.ASCENDING;
                            sortKeys.add(new RowSorter.SortKey(column, this.currentOrder));
                            break;
                        }
                        case ASCENDING: {
                            this.currentOrder = SortOrder.DESCENDING;
                            sortKeys.add(new RowSorter.SortKey(column, this.currentOrder));
                            break;
                        }
                        case DESCENDING: {
                            this.currentOrder = SortOrder.UNSORTED;
                            sortKeys.add(new RowSorter.SortKey(column, this.currentOrder));
                        }
                    }
                    sorter.setSortKeys(sortKeys);
                }
            }
        });
    }

    public String getTableIdent() {
        return this.tableIdent;
    }

    public void setTableIdent(String tableIdent) {
        this.tableIdent = tableIdent;
    }

    public EFCController getController() {
        return this.controller;
    }

    public void newFilter() {
        this.setRowFilter(null);
        this.filters.clear();
        for (final EFCTableColExt col : ((EFCColumnModel)((Object)this.getColumnModel())).getActColumns()) {
            final int modelIndex = this.getModel() instanceof EFCTableModel ? ((EFCTableModel)((Object)this.getModel())).getColIndex((String)col.getIdentifier()) : ((ListTableModel)this.getModel()).getColIndex((String)col.getIdentifier());
            int i = 0;
            try {
                i = this.getColumnModel().getColumnIndex((String)col.getIdentifier());
            }
            catch (IllegalArgumentException ill) {
                continue;
            }
            if (col.getFilter() != null && !col.getFilter().isEmpty()) {
                RowFilter<AbstractTableModel, Integer> rowFilter;
                block41: {
                    this.getTableHeader().getColumnModel().getColumn(i).setHeaderValue(this.getModel().getColumnName(modelIndex) + " " + col.getColumnFilterType().getIdent() + " " + col.getFilter());
                    Object filter = "";
                    rowFilter = null;
                    Class<?> clazz = this.getModel().getColumnClass(modelIndex);
                    if (EFCString.class.isAssignableFrom(clazz)) {
                        switch (col.getColumnFilterType()) {
                            case BIGGER_OR_EQUAL: {
                                break;
                            }
                            case CONTAIN: {
                                filter = col.getFilter();
                                break;
                            }
                            case ENDS_WITH: {
                                filter = col.getFilter() + "$";
                                break;
                            }
                            case EQUAL: {
                                filter = "^" + col.getFilter() + "$";
                                break;
                            }
                            case LESSER_OR_EQUAL: {
                                break;
                            }
                            case NOT_CONTAIN: {
                                filter = "^((?!" + col.getFilter() + ").)*$";
                                break;
                            }
                            case NOT_EQUAL: {
                                filter = "^(?!" + col.getFilter() + "$)";
                                break;
                            }
                            case STARTS_WITH: {
                                filter = "^" + col.getFilter();
                                break;
                            }
                        }
                        try {
                            rowFilter = RowFilter.regexFilter((String)filter, modelIndex);
                            break block41;
                        }
                        catch (PatternSyntaxException e) {
                            continue;
                        }
                    }
                    if (EFCDateTime.class.isAssignableFrom(clazz)) {
                        switch (col.getColumnFilterType()) {
                            case BIGGER_OR_EQUAL: {
                                rowFilter = new RowFilter<AbstractTableModel, Integer>(){

                                    @Override
                                    public boolean include(RowFilter.Entry<? extends AbstractTableModel, ? extends Integer> entry) {
                                        Date value;
                                        Date filter = new EFCDateTime(col.getFilter()).getDate();
                                        return filter.equals(value = ((EFCDateTime)entry.getModel().getValueAt(entry.getIdentifier(), modelIndex)).getDate()) || filter.before(value);
                                    }
                                };
                                break;
                            }
                            case EQUAL: {
                                rowFilter = new RowFilter<AbstractTableModel, Integer>(){

                                    @Override
                                    public boolean include(RowFilter.Entry<? extends AbstractTableModel, ? extends Integer> entry) {
                                        return new EFCDateTime(col.getFilter()).getDate().equals(((EFCDateTime)entry.getModel().getValueAt(entry.getIdentifier(), modelIndex)).getDate());
                                    }
                                };
                                break;
                            }
                            case LESSER_OR_EQUAL: {
                                rowFilter = new RowFilter<AbstractTableModel, Integer>(){

                                    @Override
                                    public boolean include(RowFilter.Entry<? extends AbstractTableModel, ? extends Integer> entry) {
                                        Date value;
                                        Date filter = new EFCDateTime(col.getFilter()).getDate();
                                        return filter.equals(value = ((EFCDateTime)entry.getModel().getValueAt(entry.getIdentifier(), modelIndex)).getDate()) || filter.after(value);
                                    }
                                };
                                break;
                            }
                            case NOT_EQUAL: {
                                rowFilter = new RowFilter<AbstractTableModel, Integer>(){

                                    @Override
                                    public boolean include(RowFilter.Entry<? extends AbstractTableModel, ? extends Integer> entry) {
                                        Date value;
                                        Date filter = new EFCDateTime(col.getFilter()).getDate();
                                        return !filter.equals(value = ((EFCDateTime)entry.getModel().getValueAt(entry.getIdentifier(), modelIndex)).getDate());
                                    }
                                };
                                break;
                            }
                        }
                    } else if (EFCFloat.class.isAssignableFrom(clazz)) {
                        switch (col.getColumnFilterType()) {
                            case BIGGER_OR_EQUAL: {
                                rowFilter = new RowFilter<AbstractTableModel, Integer>(){

                                    @Override
                                    public boolean include(RowFilter.Entry<? extends AbstractTableModel, ? extends Integer> entry) {
                                        return new EFCFloat(col.getFilter()).getData() <= ((EFCFloat)entry.getModel().getValueAt(entry.getIdentifier(), modelIndex)).getData();
                                    }
                                };
                                break;
                            }
                            case EQUAL: {
                                rowFilter = new RowFilter<AbstractTableModel, Integer>(){

                                    @Override
                                    public boolean include(RowFilter.Entry<? extends AbstractTableModel, ? extends Integer> entry) {
                                        return entry.getModel().getValueAt(entry.getIdentifier(), modelIndex).equals(new EFCFloat(col.getFilter()));
                                    }
                                };
                                break;
                            }
                            case LESSER_OR_EQUAL: {
                                rowFilter = new RowFilter<AbstractTableModel, Integer>(){

                                    @Override
                                    public boolean include(RowFilter.Entry<? extends AbstractTableModel, ? extends Integer> entry) {
                                        return new EFCFloat(col.getFilter()).getData() >= ((EFCFloat)entry.getModel().getValueAt(entry.getIdentifier(), modelIndex)).getData();
                                    }
                                };
                                break;
                            }
                            case NOT_EQUAL: {
                                rowFilter = new RowFilter<AbstractTableModel, Integer>(){

                                    @Override
                                    public boolean include(RowFilter.Entry<? extends AbstractTableModel, ? extends Integer> entry) {
                                        return !new EFCFloat(col.getFilter()).getData().equals(((EFCFloat)entry.getModel().getValueAt(entry.getIdentifier(), modelIndex)).getData());
                                    }
                                };
                                break;
                            }
                        }
                    } else if (EFCInteger.class.isAssignableFrom(clazz)) {
                        switch (col.getColumnFilterType()) {
                            case BIGGER_OR_EQUAL: {
                                rowFilter = new RowFilter<AbstractTableModel, Integer>(){

                                    @Override
                                    public boolean include(RowFilter.Entry<? extends AbstractTableModel, ? extends Integer> entry) {
                                        return new EFCInteger(col.getFilter()).getData() <= ((EFCInteger)entry.getModel().getValueAt(entry.getIdentifier(), modelIndex)).getData();
                                    }
                                };
                                break;
                            }
                            case EQUAL: {
                                rowFilter = new RowFilter<AbstractTableModel, Integer>(){

                                    @Override
                                    public boolean include(RowFilter.Entry<? extends AbstractTableModel, ? extends Integer> entry) {
                                        return entry.getModel().getValueAt(entry.getIdentifier(), modelIndex).equals(new EFCInteger(col.getFilter()));
                                    }
                                };
                                break;
                            }
                            case LESSER_OR_EQUAL: {
                                rowFilter = new RowFilter<AbstractTableModel, Integer>(){

                                    @Override
                                    public boolean include(RowFilter.Entry<? extends AbstractTableModel, ? extends Integer> entry) {
                                        return new EFCInteger(col.getFilter()).getData() >= ((EFCInteger)entry.getModel().getValueAt(entry.getIdentifier(), modelIndex)).getData();
                                    }
                                };
                                break;
                            }
                            case NOT_EQUAL: {
                                rowFilter = new RowFilter<AbstractTableModel, Integer>(){

                                    @Override
                                    public boolean include(RowFilter.Entry<? extends AbstractTableModel, ? extends Integer> entry) {
                                        return !new EFCInteger(col.getFilter()).getData().equals(((EFCInteger)entry.getModel().getValueAt(entry.getIdentifier(), modelIndex)).getData());
                                    }
                                };
                                break;
                            }
                        }
                    }
                }
                if (rowFilter == null) continue;
                this.filters.add((RowFilter<Object, Object>)rowFilter);
                continue;
            }
            if (i == -1 || modelIndex == -1) continue;
            this.getTableHeader().getColumnModel().getColumn(i).setHeaderValue(this.getModel().getColumnName(modelIndex));
        }
        if (!this.filters.isEmpty()) {
            this.setRowFilter(RowFilter.andFilter(this.filters));
        }
        ((AbstractTableModel)this.getModel()).fireTableDataChanged();
    }

    private class ColumnListener
    extends MouseAdapter {
        protected JXTable table;

        public ColumnListener(JXTable t) {
            this.table = t;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 3) {
                TableColumnModel colModel = this.table.getColumnModel();
                int colIndex = colModel.getColumnIndexAtX(e.getX());
                TableColumn colExt = EFCTable.this.getColumnModel().getColumn(colIndex);
                if (colModel instanceof EFCColumnModel) {
                    EFCTableColExt col = ((EFCColumnModel)((Object)colModel)).getActColumns().stream().filter(a -> a.getIdentifier().equals(colExt.getIdentifier())).findFirst().get();
                    final JDialog menu = new JDialog();
                    JPanel borderPanel = new JPanel(new BorderLayout());
                    JPanel buttonPanel = new JPanel();
                    buttonPanel.setLayout(new GridLayout(8, 1));
                    ColumnTextFilter filterText = new ColumnTextFilter(menu, col);
                    ColumnFilterToggleButtonGroup group = new ColumnFilterToggleButtonGroup(this.table, col, filterText);
                    Iterator<AbstractButton> it = group.getButtons().asIterator();
                    while (it.hasNext()) {
                        buttonPanel.add(it.next());
                    }
                    borderPanel.add((Component)buttonPanel, "South");
                    borderPanel.add((Component)((EFCAbstractEditor)filterText.getEditorComponent()), "North");
                    menu.addWindowFocusListener(new WindowFocusListener(){

                        @Override
                        public void windowLostFocus(WindowEvent e) {
                            menu.dispose();
                        }

                        @Override
                        public void windowGainedFocus(WindowEvent e) {
                        }
                    });
                    menu.add(borderPanel);
                    Rectangle rect = this.table.getTableHeader().getHeaderRect(colIndex);
                    menu.setUndecorated(true);
                    menu.pack();
                    menu.setFocusable(true);
                    Point p = new Point((int)rect.getX(), (int)rect.getY() + (int)rect.getHeight());
                    SwingUtilities.convertPointToScreen(p, this.table.getTableHeader());
                    menu.setLocation(p);
                    menu.setVisible(true);
                    menu.requestFocusInWindow();
                    filterText.getEditorComponent().getEditorComponent().requestFocusInWindow();
                    if (filterText.getEditorComponent().getEditorComponent() instanceof EITextField) {
                        ((EITextField)filterText.getEditorComponent().getEditorComponent()).selectAll();
                    }
                }
            }
        }
    }

    private class ColumnFilterToggleButtonGroup
    extends ButtonGroup {
        EFCTableColExt col;
        JXTable table;

        public ColumnFilterToggleButtonGroup(JXTable table, EFCTableColExt col, ColumnTextFilter filterComp) {
            this.col = col;
            this.table = table;
            for (ColumnFilterType value : ColumnFilterType.values()) {
                ColumnFilterToggleButton filter = new ColumnFilterToggleButton(value);
                if (col.getColumnFilterType() == value) {
                    filter.setSelected(true);
                }
                filter.addActionListener(actionEvent -> {
                    col.setColumnFilterType(((ColumnFilterToggleButton)actionEvent.getSource()).type);
                    filterComp.getEditorComponent().getEditorComponent().requestFocusInWindow();
                    if (filterComp.getEditorComponent().getEditorComponent() instanceof EITextField) {
                        ((EITextField)filterComp.getEditorComponent().getEditorComponent()).selectAll();
                    }
                });
                this.add(filter);
                Class<?> clazz = EFCTable.this.getModel().getColumnClass(col.getModelIndex());
                if (EFCDate.class.isAssignableFrom(clazz)) {
                    switch (value) {
                        case BIGGER_OR_EQUAL: 
                        case EQUAL: 
                        case LESSER_OR_EQUAL: 
                        case NOT_EQUAL: {
                            filter.setEnabled(true);
                            break;
                        }
                        default: {
                            filter.setEnabled(false);
                        }
                    }
                    if (col.getColumnFilterType() != null) continue;
                    col.setColumnFilterType(ColumnFilterType.EQUAL);
                    continue;
                }
                if (EFCFloat.class.isAssignableFrom(clazz) || EFCInteger.class.isAssignableFrom(clazz)) {
                    switch (value) {
                        case BIGGER_OR_EQUAL: 
                        case EQUAL: 
                        case LESSER_OR_EQUAL: 
                        case NOT_EQUAL: {
                            filter.setEnabled(true);
                            break;
                        }
                        default: {
                            filter.setEnabled(false);
                        }
                    }
                    if (col.getColumnFilterType() != null) continue;
                    col.setColumnFilterType(ColumnFilterType.EQUAL);
                    continue;
                }
                if (col.getColumnFilterType() != null) continue;
                col.setColumnFilterType(ColumnFilterType.DEFAULT);
            }
        }

        public Enumeration<AbstractButton> getButtons() {
            return this.getElements();
        }
    }

    private class ColumnFilterToggleButton
    extends JToggleButton {
        ColumnFilterType type;

        public ColumnFilterToggleButton(ColumnFilterType type) {
            this.setFont(EFCLookAndFeelManager.FONT_TABLE_CELLS);
            this.type = type;
            switch (type) {
                case BIGGER_OR_EQUAL: {
                    this.setText(Translator.tr((String)"DLG_SEARCH_CRITERIA_BIGGER_OR_EQUAL") + " " + type.getIdent());
                    break;
                }
                case CONTAIN: {
                    this.setText(Translator.tr((String)"DLG_SEARCH_CRITERIA_CONTAINS") + " " + type.getIdent());
                    break;
                }
                case ENDS_WITH: {
                    this.setText(Translator.tr((String)"DLG_SEARCH_CRITERIA_ENDS_WITH") + " " + type.getIdent());
                    break;
                }
                case EQUAL: {
                    this.setText(Translator.tr((String)"DLG_SEARCH_CRITERIA_EXACT") + " " + type.getIdent());
                    break;
                }
                case LESSER_OR_EQUAL: {
                    this.setText(Translator.tr((String)"DLG_SEARCH_CRITERIA_LESSER_OR_EQUAL") + " " + type.getIdent());
                    break;
                }
                case NOT_CONTAIN: {
                    this.setText(Translator.tr((String)"DLG_SEARCH_CRITERIA_NOT_CONTAIN") + " " + type.getIdent());
                    break;
                }
                case NOT_EQUAL: {
                    this.setText(Translator.tr((String)"DLG_SEARCH_CRITERIA_IS_NOT") + " " + type.getIdent());
                    break;
                }
                case STARTS_WITH: {
                    this.setText(Translator.tr((String)"DLG_SEARCH_CRITERIA_STARTS_WITH") + " " + type.getIdent());
                    break;
                }
            }
        }
    }

    private class ColumnTextFilter {
        EFCTableColExt col;
        EditorComponent editorComponent;

        public ColumnTextFilter(final JDialog menu, final EFCTableColExt col) {
            this.col = col;
            Class<?> columnClass = EFCTable.this.getModel().getColumnClass(col.getModelIndex());
            if (EFCDate.class.isAssignableFrom(columnClass)) {
                this.editorComponent = new EFCDateEditor("datefilter", false, false, null, false);
            } else if (EFCDateTime.class.isAssignableFrom(columnClass)) {
                this.editorComponent = new EFCDateTimeEditor("datetimefilter", false, false, null, false);
            } else if (EFCFloat.class.isAssignableFrom(columnClass)) {
                this.editorComponent = new EFCFloatEditor("floatfilter");
            } else if (EFCOption.class.isAssignableFrom(columnClass)) {
                this.editorComponent = new EFCOptionEditor(EFCTable.this.getTableIdent() + "." + col.getIdentifier(), null, EFCTable.this.controller.getBusinessObjectModel(), false, false, "", false);
                ((MapComboBoxModel)((JComboBox)((EFCOptionEditor)this.editorComponent).getEditorComponent()).getModel()).getData().add(0, new CBEntry("-", -1, ((EFCOptionEditor)this.editorComponent).getOptionClass()));
            } else {
                this.editorComponent = new EFCStringEditor("stringfilter", null, false, false, col.getPreferredWidth(), col.getPreferredWidth(), "", false);
            }
            if (this.editorComponent.getEditorComponent() instanceof JComboBox && col.getFilter() != null) {
                ((JComboBox)this.editorComponent.getEditorComponent()).setSelectedIndex(((MapComboBoxModel)((JComboBox)((EFCOptionEditor)this.editorComponent).getEditorComponent()).getModel()).getValueIndex(Integer.valueOf(col.getFilter())));
            } else {
                this.editorComponent.setValue(col.getFilter());
            }
            this.editorComponent.getEditorComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        String filter = null;
                        if (ColumnTextFilter.this.editorComponent.getSimpleValue() != null) {
                            filter = ColumnTextFilter.this.editorComponent.getSimpleValue().toString();
                        }
                        col.setFilter(filter);
                        EFCTable.this.newFilter();
                        menu.dispose();
                    }
                }
            });
            if (this.editorComponent.getEditorComponent() instanceof JComboBox) {
                ((JComboBox)this.editorComponent.getEditorComponent()).addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        String filter = null;
                        if (((CBEntry)e.getItem()).value != -1 && ((CBEntry)e.getItem()).value != null) {
                            filter = ((CBEntry)e.getItem()).value.toString();
                        }
                        col.setFilter(filter);
                        EFCTable.this.newFilter();
                        menu.dispose();
                    }
                });
            }
        }

        public EFCTableColExt getCol() {
            return this.col;
        }

        public EditorComponent getEditorComponent() {
            return this.editorComponent;
        }
    }
}

