/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.swing;

import de.effectivecompany.gui.components.model.interfaces.NamedRowsTableModel;
import de.effectivecompany.gui.components.table.EFCColumnResizer;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.JXTable;

public class EFCTableRowHeader
extends JXTable
implements ChangeListener,
PropertyChangeListener {
    private static final long serialVersionUID = 9208887497946994203L;
    private JTable main;
    private Integer colSize;
    private TableColumn column;

    public EFCTableRowHeader(JTable table, Integer colSize) {
        this.main = table;
        this.colSize = colSize;
        this.main.addPropertyChangeListener(this);
        this.setSortable(false);
        this.setAutoCreateRowSorter(false);
        this.setFocusable(false);
        this.setAutoCreateColumnsFromModel(false);
        this.setModel(this.main.getModel());
        this.setSelectionModel(this.main.getSelectionModel());
        this.column = new TableColumn();
        this.column.setCellRenderer(new EFCTableRowHeaderRenderer());
    }

    public void updateTable() {
        if (this.getColumnModel().getColumnCount() == 0) {
            this.column.setHeaderValue(" ");
            this.addColumn(this.column);
        }
        if (this.colSize != null) {
            this.getColumnModel().getColumn(0).setMinWidth(this.colSize);
            this.getColumnModel().getColumn(0).setMaxWidth(this.colSize);
        } else {
            EFCColumnResizer.sizeColumnsToFit((JTable)((Object)this), 5);
        }
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
    }

    public void addNotify() {
        super.addNotify();
        Container c = this.getParent();
        if (c instanceof JViewport) {
            JViewport viewport = (JViewport)c;
            viewport.addChangeListener(this);
        }
    }

    public int getRowCount() {
        return this.main.getRowCount();
    }

    public int getRowHeight(int row) {
        return this.main.getRowHeight(row);
    }

    public Object getValueAt(int row, int column) {
        return Integer.toString(row + 1);
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JViewport viewport = (JViewport)e.getSource();
        JScrollPane scrollPane = (JScrollPane)viewport.getParent();
        scrollPane.getVerticalScrollBar().setValue(viewport.getViewPosition().y);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("rowHeight".equals(e.getPropertyName())) {
            this.updateRowHeight();
        }
        if ("selectionModel".equals(e.getPropertyName())) {
            this.updateSelectionModel();
        }
        if ("model".equals(e.getPropertyName())) {
            this.updateModel();
        }
    }

    private void updateModel() {
        this.setModel(this.main.getModel());
    }

    private void updateRowHeight() {
        this.setRowHeight(this.main.getRowHeight());
    }

    private void updateSelectionModel() {
        this.setSelectionModel(this.main.getSelectionModel());
    }

    private static class EFCTableRowHeaderRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 3197905532378543739L;

        public EFCTableRowHeaderRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            if (table != null && (header = table.getTableHeader()) != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
            if (isSelected) {
                this.setFont(this.getFont().deriveFont(1));
            }
            if (table.getModel() instanceof NamedRowsTableModel) {
                this.setText(((NamedRowsTableModel)table.getModel()).getRowName(row).toString());
            } else {
                this.setText("Row " + (row + 1));
            }
            return this;
        }
    }
}

