/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.swing;

import de.effectivecompany.gui.data.explorer.ExplorerElement;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.awt.Component;
import java.awt.SystemColor;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public class ETreeRenderer
implements TreeCellRenderer {
    private static List<Icon> icons = EFCLookAndFeelManager.EXPLORER_ICONS_OPEN;
    private static List<Icon> iconsClosed = EFCLookAndFeelManager.EXPLORER_ICONS_CLOSED;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value == null) {
            return new JLabel();
        }
        if (value instanceof ExplorerElement) {
            Icon ico = null;
            ExplorerElement element = null;
            int iconNum = 0;
            JLabel component = null;
            element = (ExplorerElement)value;
            int n = iconNum = element.getIconType() != null ? element.getIconType().ordinal() : 0;
            if (iconNum >= 0 && iconNum < icons.size()) {
                ico = expanded ? icons.get(iconNum) : iconsClosed.get(iconNum);
            }
            component = new JLabel();
            component.setIcon(ico);
            component.setText(element.getTitle());
            if (selected) {
                component.setForeground(SystemColor.textHighlightText);
                component.setBackground(SystemColor.textHighlight);
                component.setOpaque(true);
            }
            return component;
        }
        return new JLabel(value.toString());
    }
}

