/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.swing.gantt;

import de.effectivecompany.gui.components.swing.gantt.EGanttGraphView;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.util.Date;

public class EGanttGraphPainter {
    private int yOffset = 20;
    private final DateFormat df = DateFormat.getDateTimeInstance();

    protected String getTextForValue(long val) {
        return this.df.format(new Date(val));
    }

    public void paintHeader(Graphics g, EGanttGraphView context) {
        int width = g.getClipBounds().width;
        double zoom = context.getZoom();
        int stepSubSteps = context.getStepSubSteps();
        double xStartOffset = 0.0;
        double xStepWidth = 0.0;
        double barFactor = context.getBarWidthFactor();
        long date = context.getViewportStart().getTime();
        date -= (long)(context.getSubStepSize() * stepSubSteps);
        xStepWidth = (double)context.getSubStepSize() * barFactor;
        double fullStepWidth = xStepWidth * (double)context.getStepSubSteps();
        xStartOffset = context.getGridStart().getTime() - context.getViewportStart().getTime();
        date = (long)((double)date + xStartOffset);
        xStartOffset *= barFactor;
        while (xStartOffset > fullStepWidth) {
            xStartOffset -= fullStepWidth;
            date -= (long)(context.getSubStepSize() * stepSubSteps);
        }
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, this.yOffset);
        g.setFont(context.getFont().deriveFont(8.0f));
        FontMetrics fm = context.getFontMetrics(g.getFont());
        for (double d = (xStartOffset - fullStepWidth) * zoom; d <= (double)width + fullStepWidth; d += xStepWidth * zoom * (double)stepSubSteps) {
            String dateSt = this.getTextForValue(date);
            Rectangle2D strDim = fm.getStringBounds(dateSt, g);
            g.setColor(Color.BLACK);
            g.drawLine((int)d, 14, (int)d, this.yOffset);
            g.drawString(dateSt, (int)(d - strDim.getCenterX()), this.yOffset / 3 * 2);
            date += (long)(context.getSubStepSize() * stepSubSteps);
        }
        g.setColor(Color.BLACK);
        g.drawLine(0, this.yOffset, width, this.yOffset);
    }

    public void paintGrid(Graphics g, Color mainColor, Color stepColor, EGanttGraphView context) {
        double d;
        int width = g.getClipBounds().width;
        int height = g.getClipBounds().height;
        double zoom = context.getZoom();
        int lineHeight = context.getLineHeight();
        int stepSubSteps = context.getStepSubSteps();
        double xStartOffset = 0.0;
        double xStepWidth = 0.0;
        double barFactor = context.getBarWidthFactor();
        xStepWidth = (double)context.getSubStepSize() * context.getBarWidthFactor();
        double fullStepWidth = xStepWidth * (double)context.getStepSubSteps();
        xStartOffset = context.getGridStart().getTime() - context.getViewportStart().getTime();
        xStartOffset *= barFactor;
        while (xStartOffset > fullStepWidth) {
            xStartOffset -= fullStepWidth;
        }
        g.setColor(mainColor);
        for (int i = (int)((double)lineHeight * zoom); i < height - 20; i += (int)((double)lineHeight * zoom)) {
            g.drawLine(0, this.yOffset + i, width, this.yOffset + i);
        }
        int num = 0;
        for (d = xStartOffset * zoom; d <= (double)width; d += xStepWidth * zoom) {
            g.setColor(num % stepSubSteps == 0 ? stepColor : mainColor);
            g.drawLine((int)d, this.yOffset, (int)d, height);
            ++num;
        }
        if (xStartOffset >= xStepWidth) {
            g.setColor(mainColor);
            for (d = (xStartOffset - fullStepWidth) * zoom; d < xStartOffset; d += xStepWidth * zoom) {
                g.drawLine((int)d, this.yOffset, (int)d, height);
            }
        }
    }
}

