/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.swing.gantt;

import de.effectivecompany.gui.components.swing.gantt.EGanttGraphView;
import de.effectivecompany.gui.components.swing.model.gantt.GanttTask;
import de.effectivecompany.gui.components.swing.model.gantt.GanttTaskLink;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;

public class EGanttGraphTaskPainter {
    protected Dimension getTaskDimension(EGanttGraphView context, GanttTask task) {
        int width = (int)(context.getZoom() * context.getBarWidthFactor() * (double)(task.getEnd().getTime() - task.getStart().getTime()));
        int height = (int)(context.getZoom() * (double)context.getBarHeight());
        return new Dimension(width, height);
    }

    public void paintTask(Graphics g, GanttTask task, EGanttGraphView context) {
        Color oldColor = g.getColor();
        Point p = context.getStartPoint(task);
        Dimension dim = this.getTaskDimension(context, task);
        if (task.isSelected()) {
            g.setColor(new Color(170, 170, 255));
        } else {
            g.setColor(new Color(130, 130, 240));
        }
        g.fillRect(p.x, p.y - dim.height / 2, dim.width, dim.height);
        if (task.hasPrecentState()) {
            double done = task.getPercent() / 100.0;
            int pHeight = dim.height / 4;
            int yOff = pHeight / 2;
            if (done > 1.0) {
                done = 1.0;
            }
            if (done < 0.0) {
                done = 0.0;
            }
            g.setColor(Color.GREEN);
            g.fillRect(p.x, p.y - yOff, (int)((double)dim.width * (task.getPercent() / 100.0)), pHeight);
        }
        g.setColor(oldColor);
    }

    public void paintLink(Graphics g, GanttTaskLink link, EGanttGraphView context) {
        Point start = context.getEndPoint(link.getSource());
        Point end = context.getStartPoint(link.getDestination());
        Color oldColor = g.getColor();
        boolean below = start.y < end.y;
        int barHeigth = (int)((double)context.getBarHeight() * context.getZoom());
        int lineSpace = (int)((double)(context.getLineHeight() - context.getBarHeight() / 2) * context.getZoom());
        Polygon poly = new Polygon();
        poly.addPoint(start.x, start.y);
        poly.addPoint(start.x + (int)(5.0 * context.getZoom()), start.y);
        if (below) {
            poly.addPoint(start.x + (int)(5.0 * context.getZoom()), start.y + barHeigth / 2 + lineSpace / 4);
            poly.addPoint(end.x - (int)(5.0 * context.getZoom()), start.y + barHeigth / 2 + lineSpace / 4);
        } else {
            poly.addPoint(start.x + (int)(5.0 * context.getZoom()), start.y - barHeigth / 2 - lineSpace / 4);
            poly.addPoint(end.x - (int)(5.0 * context.getZoom()), start.y - barHeigth / 2 - lineSpace / 4);
        }
        poly.addPoint(end.x - (int)(5.0 * context.getZoom()), end.y);
        poly.addPoint(end.x, end.y);
        g.setColor(Color.BLACK);
        g.drawPolyline(poly.xpoints, poly.ypoints, poly.npoints);
        g.drawLine(end.x, end.y, end.x - (int)(3.0 * context.getZoom()), end.y - (int)(2.0 * context.getZoom()));
        g.drawLine(end.x, end.y, end.x - (int)(3.0 * context.getZoom()), end.y + (int)(2.0 * context.getZoom()));
        g.setColor(oldColor);
    }
}

