/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.swing.gantt;

import de.effectivecompany.gui.components.swing.model.gantt.GanttElement;
import de.effectivecompany.gui.components.swing.model.gantt.GanttModel;
import de.effectivecompany.gui.components.swing.model.gantt.GanttProject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SystemColor;
import javax.swing.JComponent;

public class EGanttTreeView
extends JComponent {
    private static final long serialVersionUID = 6630756843515556774L;
    private GanttModel model;
    private double zoom = 1.0;
    private int lineHeight = 20;

    public void setZoom(double zoom) {
        double old = this.zoom;
        this.zoom = zoom;
        if (old != zoom) {
            this.repaint();
        }
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setModel(GanttModel model) {
        this.model = model;
    }

    public GanttModel getModel() {
        return this.model;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Font font = this.getFont();
        FontMetrics fontMetrics = g.getFontMetrics(font);
        int fontHeight = fontMetrics.getHeight();
        while (fontHeight > (int)((double)this.lineHeight * this.zoom)) {
            font = font.deriveFont(font.getSize2D() - 0.1f);
            fontMetrics = g.getFontMetrics(font);
            fontHeight = fontMetrics.getHeight();
        }
        g.setFont(font);
        int offset = (int)(((double)this.lineHeight * this.zoom - (double)fontHeight) / 2.0);
        int lineOffset = -offset - fontMetrics.getAscent() - fontMetrics.getLeading();
        int pos = 20 + offset + fontMetrics.getAscent() + fontMetrics.getLeading();
        if (this.model != null) {
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                GanttProject p = this.model.getProject(i);
                GanttElement e = this.model.getElement(i);
                g.setColor(Color.WHITE);
                g.drawLine(0, pos + lineOffset, g.getClipBounds().width, pos + lineOffset);
                g.setColor(SystemColor.controlText);
                if (p != null) {
                    g.drawString(p.getText(), 3, pos);
                } else if (e != null) {
                    g.drawString(e.getText(), 3, pos);
                }
                pos += (int)((double)this.lineHeight * this.zoom);
            }
            g.setColor(Color.WHITE);
            g.drawLine(0, pos + lineOffset, g.getClipBounds().width, pos + lineOffset);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if ((double)dim.width < 100.0 * this.getZoom()) {
            dim.width = (int)(100.0 * this.getZoom());
        }
        return dim;
    }
}

